/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.fluid_infuser;

import com.mojang.serialization.Codec;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.recipes.fluid_infuser.FluidInfuserRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class FluidInfuserRecipeSerializer
implements RecipeSerializer<FluidInfuserRecipe> {
    protected final IFactory<FluidInfuserRecipe> factory;

    public FluidInfuserRecipeSerializer(IFactory<FluidInfuserRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<FluidInfuserRecipe> codec() {
        return FluidInfuserRecipe.CODEC.codec();
    }

    @NotNull
    public FluidInfuserRecipe fromNetwork(FriendlyByteBuf buffer) {
        int energy = buffer.readVarInt();
        FluidStack inputFluid = RecipeHelper.FluidInput.fromNetwork(buffer);
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        FluidStack outputFluid = RecipeHelper.FluidOutput.fromNetwork(buffer);
        return this.factory.create(energy, inputFluid, ingredient, outputFluid);
    }

    public void toNetwork(FriendlyByteBuf buffer, FluidInfuserRecipe recipe) {
        buffer.writeVarInt(recipe.getEnergy());
        RecipeHelper.FluidInput.toNetwork(buffer, recipe.getInputFluid());
        RecipeHelper.IngredientInput.toNetwork(buffer, recipe.getIngredient());
        RecipeHelper.FluidOutput.toNetwork(buffer, recipe.getOutputFluid());
    }

    public static interface IFactory<T> {
        public T create(int var1, FluidStack var2, Ingredient var3, FluidStack var4);
    }
}

