/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.item_infuser;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.recipes.item_infuser.ItemInfuserRecipe;
import wootrevived.woot.util.helper.RecipeHelper;

public class ItemInfuserRecipeSerializer
implements RecipeSerializer<ItemInfuserRecipe> {
    protected final IFactory<ItemInfuserRecipe> factory;

    public ItemInfuserRecipeSerializer(IFactory<ItemInfuserRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<ItemInfuserRecipe> codec() {
        return ItemInfuserRecipe.CODEC.codec();
    }

    @NotNull
    public ItemInfuserRecipe fromNetwork(FriendlyByteBuf buffer) {
        int energy = buffer.readVarInt();
        FluidStack fluid = RecipeHelper.FluidInput.fromNetwork(buffer);
        Ingredient ingredient = RecipeHelper.IngredientInput.fromNetwork(buffer);
        Ingredient augment = null;
        if (buffer.readBoolean()) {
            augment = RecipeHelper.IngredientInput.fromNetwork(buffer);
        }
        ItemStack output = RecipeHelper.ItemOutput.fromNetwork(buffer);
        return this.factory.create(energy, fluid, ingredient, Optional.ofNullable(augment), output);
    }

    public void toNetwork(FriendlyByteBuf buffer, ItemInfuserRecipe recipe) {
        buffer.writeVarInt(recipe.getEnergy());
        RecipeHelper.FluidInput.toNetwork(buffer, recipe.getFluid());
        RecipeHelper.IngredientInput.toNetwork(buffer, recipe.getIngredient());
        buffer.writeBoolean(recipe.getAugment().isPresent());
        if (recipe.getAugment().isPresent()) {
            RecipeHelper.IngredientInput.toNetwork(buffer, recipe.getAugment().get());
        }
        RecipeHelper.ItemOutput.toNetwork(buffer, recipe.getOutput());
    }

    public static interface IFactory<T> {
        public T create(int var1, FluidStack var2, Ingredient var3, Optional<Ingredient> var4, ItemStack var5);
    }
}

