/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.stygian_anvil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.registries.RecipesRegistry;
import wootrevived.woot.util.recipes.WootContainer;

public class StygianAnvilRecipe
implements Recipe<WootContainer> {
    public static final MapCodec<StygianAnvilRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("base").forGetter(StygianAnvilRecipe::getBase), (App)Ingredient.CODEC.optionalFieldOf("first_complementary").forGetter(StygianAnvilRecipe::getFirstComplementary), (App)Ingredient.CODEC.optionalFieldOf("second_complementary").forGetter(StygianAnvilRecipe::getSecondComplementary), (App)Ingredient.CODEC.optionalFieldOf("third_complementary").forGetter(StygianAnvilRecipe::getThirdComplementary), (App)Ingredient.CODEC.optionalFieldOf("fourth_complementary").forGetter(StygianAnvilRecipe::getFourthComplementary), (App)ItemStack.CODEC.fieldOf("output").forGetter(StygianAnvilRecipe::getOutput)).apply((Applicative)inst, StygianAnvilRecipe::new));
    private final Ingredient base;
    private final Optional<Ingredient> firstComplementary;
    private final Optional<Ingredient> secondComplementary;
    private final Optional<Ingredient> thirdComplementary;
    private final Optional<Ingredient> fourthComplementary;
    private final ItemStack outputItem;
    private final int complementaryCount;

    public StygianAnvilRecipe(@NotNull Ingredient base, @NotNull Optional<Ingredient> firstComplementary, @NotNull Optional<Ingredient> secondComplementary, @NotNull Optional<Ingredient> thirdComplementary, @NotNull Optional<Ingredient> fourthComplementary, @NotNull ItemStack outputItem) {
        this.base = base;
        this.firstComplementary = firstComplementary;
        this.secondComplementary = secondComplementary;
        this.thirdComplementary = thirdComplementary;
        this.fourthComplementary = fourthComplementary;
        this.outputItem = outputItem;
        this.complementaryCount = Boolean.compare(firstComplementary.isPresent(), false) + Boolean.compare(secondComplementary.isPresent(), false) + Boolean.compare(thirdComplementary.isPresent(), false) + Boolean.compare(fourthComplementary.isPresent(), false);
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.ANVIL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipesRegistry.ANVIL_RECIPE_TYPE.get();
    }

    @NotNull
    public Ingredient getBase() {
        return this.base;
    }

    @NotNull
    public Optional<Ingredient> getFirstComplementary() {
        return this.firstComplementary;
    }

    @NotNull
    public Optional<Ingredient> getSecondComplementary() {
        return this.secondComplementary;
    }

    @NotNull
    public Optional<Ingredient> getThirdComplementary() {
        return this.thirdComplementary;
    }

    @NotNull
    public Optional<Ingredient> getFourthComplementary() {
        return this.fourthComplementary;
    }

    @NotNull
    public ItemStack getOutput() {
        return this.outputItem.copy();
    }

    public boolean matches(@NotNull WootContainer container, @NotNull Level level) {
        if (!this.getBase().test(container.getItem(0))) {
            return false;
        }
        int count = 0;
        for (int i = 1; i < container.getContainerSize(); ++i) {
            if (container.getItem(i).isEmpty()) continue;
            ++count;
        }
        if (this.complementaryCount != count) {
            return false;
        }
        ArrayList<Integer> validatedSlots = new ArrayList<Integer>();
        return this.matchComplementary(container, validatedSlots, this.firstComplementary) && this.matchComplementary(container, validatedSlots, this.secondComplementary) && this.matchComplementary(container, validatedSlots, this.thirdComplementary) && this.matchComplementary(container, validatedSlots, this.fourthComplementary);
    }

    private boolean matchComplementary(Container container, List<Integer> validatedSlots, @Nullable Optional<Ingredient> complementary) {
        if (complementary.isEmpty()) {
            return true;
        }
        boolean hasFound = false;
        for (int i = 1; i < container.getContainerSize(); ++i) {
            if (validatedSlots.contains(i) || !complementary.get().test(container.getItem(i))) continue;
            validatedSlots.add(i);
            hasFound = true;
            break;
        }
        return hasFound;
    }

    public static void loadRecipes(@NotNull RecipeManager manager) {
        Validator.clear();
        for (RecipeHolder recipeHolder : manager.getAllRecipesFor((RecipeType)RecipesRegistry.ANVIL_RECIPE_TYPE.get())) {
            Validator.add(((StygianAnvilRecipe)recipeHolder.value()).base, ((StygianAnvilRecipe)recipeHolder.value()).firstComplementary, ((StygianAnvilRecipe)recipeHolder.value()).secondComplementary, ((StygianAnvilRecipe)recipeHolder.value()).thirdComplementary, ((StygianAnvilRecipe)recipeHolder.value()).fourthComplementary);
        }
    }

    @NotNull
    public ItemStack assemble(@NotNull WootContainer container, @NotNull RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess registryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Validator {
        private static final List<Ingredient> validBaseInputs = new ArrayList<Ingredient>();
        private static final List<Ingredient> validIngredients = new ArrayList<Ingredient>();

        public static boolean isBaseValid(ItemStack base) {
            for (Ingredient ingredient : validBaseInputs) {
                if (!ingredient.test(base)) continue;
                return true;
            }
            return false;
        }

        public static boolean isIngredientValid(ItemStack item) {
            for (Ingredient ingredient : validIngredients) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        }

        protected static void add(@NotNull Ingredient base, @NotNull Optional<Ingredient> firstComplementary, @NotNull Optional<Ingredient> secondComplementary, @NotNull Optional<Ingredient> thirdComplementary, @NotNull Optional<Ingredient> fourthComplementary) {
            validBaseInputs.add(base);
            firstComplementary.ifPresent(validIngredients::add);
            secondComplementary.ifPresent(validIngredients::add);
            thirdComplementary.ifPresent(validIngredients::add);
            fourthComplementary.ifPresent(validIngredients::add);
        }

        protected static void clear() {
            validBaseInputs.clear();
            validIngredients.clear();
        }
    }
}

