/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.recipes.stygian_anvil;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import wootrevived.woot.Woot;
import wootrevived.woot.recipes.stygian_anvil.StygianAnvilRecipe;

public class StygianAnvilRecipeBuilder {
    private Ingredient base;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final ItemStack output;

    protected StygianAnvilRecipeBuilder(ItemLike output, int count) {
        this.output = output.asItem().getDefaultInstance();
        this.output.setCount(count);
    }

    public static StygianAnvilRecipeBuilder anvilRecipe(ItemLike output, int count) {
        return new StygianAnvilRecipeBuilder(output, count);
    }

    public static StygianAnvilRecipeBuilder anvilRecipe(ItemLike output) {
        return new StygianAnvilRecipeBuilder(output, 1);
    }

    public StygianAnvilRecipeBuilder base(Ingredient base) {
        this.base = base;
        return this;
    }

    public StygianAnvilRecipeBuilder ingredient(Ingredient ingredient) {
        this.ingredients.add(ingredient);
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BuiltInRegistries.ITEM.getKey((Object)this.output.getItem()).getPath());
    }

    public void save(RecipeOutput recipeOutput, String path) {
        recipeOutput.accept(Woot.location("stygian_anvil/" + path), (Recipe)new StygianAnvilRecipe(this.base, this.ingredients.isEmpty() ? Optional.empty() : Optional.of(this.ingredients.get(0)), this.ingredients.size() <= 1 ? Optional.empty() : Optional.of(this.ingredients.get(1)), this.ingredients.size() <= 2 ? Optional.empty() : Optional.of(this.ingredients.get(2)), this.ingredients.size() <= 3 ? Optional.empty() : Optional.of(this.ingredients.get(3)), this.output), null);
    }
}

