/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootFactoryMobRegistration;
import wootrevived.woot.init.WootPlugins;

public class WootFactoryMobsRegistry
extends WootFactoryMobRegistration {
    private static final Map<EntityType<?>, WootFactoryMob<?>> FACTORY_MOB_REGISTRY = new HashMap();
    private static final Map<EntityType<?>, List<Consumer<WootDropsProperties>>> ITEM_DROPS_REGISTRY = new HashMap();
    private static final List<Consumer<WootDropsProperties>> GLOBAL_ITEM_DROPS_REGISTRY = new ArrayList<Consumer<WootDropsProperties>>();

    public static void register() {
        WootPlugins.registerFactoryMobs(new WootFactoryMobsRegistry());
        for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
            if (WootFactoryMobsRegistry.hasFactoryMob(entityType) || !entityType.canSerialize()) continue;
            FACTORY_MOB_REGISTRY.put(entityType, new WootFactoryMob(entityType, new WootFactoryMob.Properties()));
        }
    }

    @Override
    public void registerFactoryMob(WootFactoryMob<?> mob) {
        FACTORY_MOB_REGISTRY.put(mob.getEntityType(), mob);
    }

    public static WootFactoryMob<?> getFactoryMob(CompoundTag mobTag) {
        return WootFactoryMobsRegistry.getFactoryMob(mobTag.getString("id"));
    }

    public static WootFactoryMob<?> getFactoryMob(String mobId) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)mobId));
        return WootFactoryMobsRegistry.getFactoryMob(entityType);
    }

    public static WootFactoryMob<?> getFactoryMob(EntityType<?> entityType) {
        return FACTORY_MOB_REGISTRY.get(entityType);
    }

    public static boolean hasFactoryMob(CompoundTag mobTag) {
        return WootFactoryMobsRegistry.hasFactoryMob(mobTag.getString("id"));
    }

    public static boolean hasFactoryMob(String mobId) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)mobId));
        return WootFactoryMobsRegistry.hasFactoryMob(entityType);
    }

    public static boolean hasFactoryMob(EntityType<?> entityType) {
        return FACTORY_MOB_REGISTRY.containsKey(entityType);
    }

    public static void removeFactoryMob(EntityType<?> entityType) {
        FACTORY_MOB_REGISTRY.remove(entityType);
    }

    public static Collection<WootFactoryMob<?>> getFactoryMobValues() {
        return FACTORY_MOB_REGISTRY.values();
    }

    @Override
    public void registerDropsModifier(EntityType<?> entityType, Consumer<WootDropsProperties> callback) {
        if (!ITEM_DROPS_REGISTRY.containsKey(entityType)) {
            ITEM_DROPS_REGISTRY.put(entityType, new ArrayList());
        }
        ITEM_DROPS_REGISTRY.get(entityType).add(callback);
    }

    public static List<Consumer<WootDropsProperties>> getDropsModifier(CompoundTag mobTag) {
        return WootFactoryMobsRegistry.getDropsModifier(mobTag.getString("id"));
    }

    public static List<Consumer<WootDropsProperties>> getDropsModifier(String mobId) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)mobId));
        return WootFactoryMobsRegistry.getDropsModifier(entityType);
    }

    public static List<Consumer<WootDropsProperties>> getDropsModifier(EntityType<?> entityType) {
        if (!WootFactoryMobsRegistry.hasDropsModifier(entityType)) {
            return List.of();
        }
        return ITEM_DROPS_REGISTRY.get(entityType);
    }

    public static boolean hasDropsModifier(CompoundTag mobTag) {
        return WootFactoryMobsRegistry.hasDropsModifier(mobTag.getString("id"));
    }

    public static boolean hasDropsModifier(String mobId) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.tryParse((String)mobId));
        return WootFactoryMobsRegistry.hasDropsModifier(entityType);
    }

    public static boolean hasDropsModifier(EntityType<?> entityType) {
        return ITEM_DROPS_REGISTRY.containsKey(entityType);
    }

    @Override
    public void registerGlobalDropsModifier(Consumer<WootDropsProperties> callback) {
        GLOBAL_ITEM_DROPS_REGISTRY.add(callback);
    }

    public static List<Consumer<WootDropsProperties>> getGlobalDropsModifier() {
        return GLOBAL_ITEM_DROPS_REGISTRY;
    }
}

