/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootSpawnProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.util.render.WootStyles;

public class Looting
extends WootUpgradeItem {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_LOOTING_TAG = "copper_looting_upgrade";
    public static final DeferredHolder<Item, Looting> COPPER_LOOTING_ITEM = ITEMS.register("copper_looting_upgrade", () -> new Looting(1));
    public static final String IRON_LOOTING_TAG = "iron_looting_upgrade";
    public static final DeferredHolder<Item, Looting> IRON_LOOTING_ITEM = ITEMS.register("iron_looting_upgrade", () -> new Looting(2));
    public static final String GOLD_LOOTING_TAG = "gold_looting_upgrade";
    public static final DeferredHolder<Item, Looting> GOLD_LOOTING_ITEM = ITEMS.register("gold_looting_upgrade", () -> new Looting(3));
    public static final String DIAMOND_LOOTING_TAG = "diamond_looting_upgrade";
    public static final DeferredHolder<Item, Looting> DIAMOND_LOOTING_ITEM = ITEMS.register("diamond_looting_upgrade", () -> new Looting(4));
    public static final String NETHERITE_LOOTING_TAG = "netherite_looting_upgrade";
    public static final DeferredHolder<Item, Looting> NETHERITE_LOOTING_ITEM = ITEMS.register("netherite_looting_upgrade", () -> new Looting(5));

    public Looting(int level) {
        super(new Item.Properties(), level);
    }

    @Override
    public void applySpawnProperties(WootSpawnProperties properties, CompoundTag upgradeTag) {
        ItemStack itemStack = properties.getMainHandItem();
        if (itemStack.getItem().isEnchantable(itemStack)) {
            itemStack.enchant(Enchantments.MOB_LOOTING, this.getLevel());
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.looting.desc.0", (Object[])new Object[]{this.getLevel()}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_LOOTING_ITEM);
        registration.register(IRON_LOOTING_ITEM);
        registration.register(GOLD_LOOTING_ITEM);
        registration.register(DIAMOND_LOOTING_ITEM);
        registration.register(NETHERITE_LOOTING_ITEM);
    }
}

