/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.upgrades;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootUpgradeItem;
import wootrevived.api.interfaces.WootDropsProperties;
import wootrevived.api.registrations.WootUpgradeItemRegistration;
import wootrevived.woot.items.xp.XpItem;
import wootrevived.woot.registries.ItemsRegistry;
import wootrevived.woot.util.render.WootStyles;

public class Xp
extends WootUpgradeItem {
    private static final int[] PERCENTAGES = new int[]{50, 75, 100, 125, 150};
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"woot_revived");
    public static final String COPPER_XP_TAG = "copper_xp_upgrade";
    public static final DeferredHolder<Item, Xp> COPPER_XP_ITEM = ITEMS.register("copper_xp_upgrade", () -> new Xp(1));
    public static final String IRON_XP_TAG = "iron_xp_upgrade";
    public static final DeferredHolder<Item, Xp> IRON_XP_ITEM = ITEMS.register("iron_xp_upgrade", () -> new Xp(2));
    public static final String GOLD_XP_TAG = "gold_xp_upgrade";
    public static final DeferredHolder<Item, Xp> GOLD_XP_ITEM = ITEMS.register("gold_xp_upgrade", () -> new Xp(3));
    public static final String DIAMOND_XP_TAG = "diamond_xp_upgrade";
    public static final DeferredHolder<Item, Xp> DIAMOND_XP_ITEM = ITEMS.register("diamond_xp_upgrade", () -> new Xp(4));
    public static final String NETHERITE_XP_TAG = "netherite_xp_upgrade";
    public static final DeferredHolder<Item, Xp> NETHERITE_XP_ITEM = ITEMS.register("netherite_xp_upgrade", () -> new Xp(5));

    public Xp(int level) {
        super(new Item.Properties(), level);
    }

    @Override
    public void modifyDrops(WootDropsProperties properties, CompoundTag upgradeTag) {
        List<ItemStack> drops = properties.getItemDrops();
        int experience = Math.round((float)properties.getExperience() * ((float)PERCENTAGES[this.getLevel() - 1] / 100.0f));
        if (experience <= 0) {
            return;
        }
        properties.setExperience(0);
        int shards = experience / 9;
        int splinters = experience % 9;
        if (shards != 0) {
            ItemStack shard = ((XpItem)((Object)ItemsRegistry.XP_SHARD_ITEM.get())).getDefaultInstance();
            shard.setCount(shards);
            drops.add(shard);
        }
        if (splinters != 0) {
            ItemStack splinter = ((XpItem)((Object)ItemsRegistry.XP_SPLINTER_ITEM.get())).getDefaultInstance();
            splinter.setCount(splinters);
            drops.add(splinter);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"info.woot_revived.upgrade.xp.desc.0", (Object[])new Object[]{PERCENTAGES[this.getLevel() - 1]}).setStyle(WootStyles.DESCRIPTION_STYLE));
    }

    public static void register(WootUpgradeItemRegistration registration) {
        ITEMS.register(registration.getWootEventBus());
        registration.register(COPPER_XP_ITEM);
        registration.register(IRON_XP_ITEM);
        registration.register(GOLD_XP_ITEM);
        registration.register(DIAMOND_XP_ITEM);
        registration.register(NETHERITE_XP_ITEM);
    }
}

