/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryBlockBaseEntity
extends BlockEntity {
    protected BlockPos heartPos = null;

    public FactoryBlockBaseEntity(BlockEntityType<?> entity, BlockPos pos, BlockState state) {
        super(entity, pos, state);
    }

    public boolean isHeartPosEmpty() {
        return this.heartPos == null;
    }

    public boolean isSameHeartPos(BlockPos blockPos) {
        return Objects.equals(blockPos, this.heartPos);
    }

    public void setHeartPos(BlockPos blockPos) {
        if (Objects.equals(blockPos, this.heartPos)) {
            return;
        }
        this.heartPos = blockPos;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.heartPos != null) {
            tag.putLong("HeartPos", this.heartPos.asLong());
        }
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.heartPos = tag.contains("HeartPos") ? BlockPos.of((long)tag.getLong("HeartPos")) : null;
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }
}

