/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.entity;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wootrevived.woot.blocks.dye_liquifier.DyeLiquifierBlockEntity;
import wootrevived.woot.network.WootMachineUpdate;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.handlers.WootEnergyStorage;
import wootrevived.woot.util.handlers.WootFluidTankHandler;
import wootrevived.woot.util.render.WootContainerData;

public abstract class WootMachineBlockEntity
extends BlockEntity
implements BlockEntityTicker<BlockEntity> {
    public static final int DATA_ENERGY = 0;
    public static final int DATA_PROGRESS = 1;
    public static final int DATA_FLUID_INPUT = 2;
    public static final int DATA_FLUID_OUTPUT = 3;
    public static final int DATA_ENERGY_TRANSFER = 4;
    public static final int DATA_LEFT_SECOND = 5;
    public WootContainerData data = new WootContainerData(){

        public int get(int i) {
            if (i == 0) {
                return WootMachineBlockEntity.this.energyHandler.getEnergyStored();
            }
            if (i == 1) {
                return WootMachineBlockEntity.this.calculateProgress();
            }
            if (i == 4) {
                return WootMachineBlockEntity.this.getEnergyProcessTransfer();
            }
            WootMachineBlockEntity wootMachineBlockEntity = WootMachineBlockEntity.this;
            if (wootMachineBlockEntity instanceof DyeLiquifierBlockEntity) {
                DyeLiquifierBlockEntity be = (DyeLiquifierBlockEntity)wootMachineBlockEntity;
                if (i == 10) {
                    return be.getRed();
                }
                if (i == 11) {
                    return be.getYellow();
                }
                if (i == 12) {
                    return be.getBlue();
                }
                if (i == 13) {
                    return be.getWhite();
                }
            }
            return 0;
        }

        @Override
        public float getFloat(int i) {
            if (i == 5) {
                return Math.max(0.0f, (float)WootMachineBlockEntity.this.processRemaining / ((float)WootMachineBlockEntity.this.getEnergyProcessTransfer() * 20.0f));
            }
            return 0.0f;
        }

        @Override
        public FluidStack getFluid(int i) {
            if (i == 2) {
                return WootMachineBlockEntity.this.inputTankHandler.getFluid();
            }
            if (i == 3) {
                return WootMachineBlockEntity.this.outputTankHandler.getFluid();
            }
            return FluidStack.EMPTY;
        }

        @Override
        public Direction getMachineFacing() {
            return (Direction)WootMachineBlockEntity.this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        }

        @Override
        public RedstoneMode getRedstoneMode() {
            return WootMachineBlockEntity.this.redstoneMode;
        }

        @Override
        public Map<MachineSide, MachineSideProperty> getMachineSideProperties(int index) {
            return WootMachineBlockEntity.this.getMachineSideProperties(index);
        }

        @Override
        public void setRedstoneMode(RedstoneMode mode) {
            WootMachineBlockEntity.this.redstoneMode = mode;
            WootMachineBlockEntity.this.sendNewState();
        }

        @Override
        public void setMachineSideProperties() {
            WootMachineBlockEntity.this.sendNewState();
        }

        public int getCount() {
            return 0;
        }

        public void set(int i, int v) {
        }
    };
    protected RedstoneMode redstoneMode = RedstoneMode.ALWAYS_ON;
    private boolean isProcessActive = false;
    private int processMax = 0;
    private int processRemaining = 0;
    private boolean lastRedstoneState = false;
    public final WootEnergyStorage energyHandler = this.createEnergy();
    public final WootFluidTankHandler inputTankHandler = this.createInputTank();
    public final WootFluidTankHandler outputTankHandler = this.createOutputTank();

    public WootMachineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract Map<MachineSide, MachineSideProperty> getMachineSideProperties(int var1);

    public abstract List<Map<MachineSide, MachineSideProperty>> getAllMachineSidesProperties();

    public abstract void setAllMachineSidesProperties(List<Map<MachineSide, MachineSideProperty>> var1);

    public boolean isProcessActive() {
        return this.isProcessActive;
    }

    public void tick(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        boolean isDisabled = this.isDisabled();
        if (!this.isProcessActive) {
            if (isDisabled) {
                return;
            }
            if (!this.canProcess(true)) {
                return;
            }
            this.processStart();
            this.processTick();
            return;
        }
        if (this.redstoneMode != RedstoneMode.ONCE && isDisabled) {
            this.processOff();
            return;
        }
        this.processTick();
        if (this.canFinish()) {
            this.processFinished();
            if (this.canProcess(true) && !isDisabled) {
                this.processStart();
            } else {
                this.processOff();
            }
            return;
        }
        if (!this.hasEnergy()) {
            this.processOff();
        }
    }

    protected abstract boolean canProcess(boolean var1);

    protected abstract void processFinished();

    protected abstract boolean hasEnergy();

    protected abstract int useEnergy();

    protected abstract void clearRecipe();

    protected abstract int getRecipeEnergy();

    protected boolean isDisabled() {
        if (this.redstoneMode == RedstoneMode.ALWAYS_ON) {
            return false;
        }
        boolean current = this.level.hasNeighborSignal(this.getBlockPos());
        if (this.redstoneMode != RedstoneMode.ONCE) {
            return this.redstoneMode == RedstoneMode.WITH_SIGNAL != current;
        }
        boolean risingEdge = !this.lastRedstoneState && current;
        this.lastRedstoneState = current;
        return !risingEdge;
    }

    private void processTick() {
        if (this.processRemaining <= 0) {
            return;
        }
        int energy = this.useEnergy();
        this.processRemaining -= energy;
        this.setChanged();
    }

    private boolean canFinish() {
        return this.processRemaining <= 0 && this.canProcess(false);
    }

    public int calculateProgress() {
        return this.processMax == 0 ? 0 : 100 - (int)(100.0f / (float)this.processMax * (float)this.processRemaining);
    }

    protected void processOff() {
        this.isProcessActive = false;
        this.processRemaining = 0;
        this.processMax = 0;
        this.setChanged();
        this.clearRecipe();
    }

    private void processStart() {
        this.isProcessActive = true;
        this.processMax = this.getRecipeEnergy();
        this.processRemaining = this.getRecipeEnergy();
    }

    public void onContentsChanged(int slot) {
        if (!this.isProcessActive) {
            return;
        }
        if (!this.canProcess(false)) {
            this.processOff();
        }
    }

    public void dropContents(List<ItemStack> items) {
        for (ItemStack itemStack : items) {
            if (itemStack.isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (ItemStack)itemStack);
        }
        this.setChanged();
    }

    public abstract IItemHandler getInventory();

    private WootEnergyStorage createEnergy() {
        if (!this.hasEnergyCapability()) {
            return null;
        }
        return new WootEnergyStorage(this.getEnergyCapacity(), this.getEnergyMaxTransfer()){

            @Override
            protected void onEnergyChanged() {
                WootMachineBlockEntity.this.setChanged();
            }

            public boolean canReceive() {
                return true;
            }

            public boolean canExtract() {
                return false;
            }
        };
    }

    public abstract int getEnergyCapacity();

    public abstract int getEnergyProcessTransfer();

    public abstract int getEnergyMaxTransfer();

    public abstract boolean hasEnergyCapability();

    private WootFluidTankHandler createInputTank() {
        if (!this.hasInputFluidCapability()) {
            return null;
        }
        return new WootFluidTankHandler(this.getInputTankCapacity(), false, this.getInputFluidValidator()){

            protected void onContentsChanged() {
                WootMachineBlockEntity.this.setChanged();
            }
        };
    }

    public WootFluidTankHandler getInputTank() {
        return this.inputTankHandler;
    }

    public abstract Predicate<FluidStack> getInputFluidValidator();

    public abstract int getInputTankCapacity();

    public abstract boolean hasInputFluidCapability();

    protected void tickFluid(WootFluidTankHandler fluidTank, BlockPos pos, int tickRate, Function<Direction, MachineSideProperty> getProperty) {
        for (Direction side : Direction.values()) {
            FluidStack simulation;
            IFluidHandler handler;
            if (getProperty.apply(side) == MachineSideProperty.PUSH) {
                handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(side), (Object)side.getOpposite());
                if (handler == null || (simulation = FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)fluidTank, (int)tickRate, (boolean)false)).isEmpty()) continue;
                FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)fluidTank, (int)simulation.getAmount(), (boolean)true);
                continue;
            }
            if (getProperty.apply(side) != MachineSideProperty.PULL || fluidTank.isOutput() || (handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(side), (Object)side.getOpposite())) == null || (simulation = FluidUtil.tryFluidTransfer((IFluidHandler)fluidTank, (IFluidHandler)handler, (int)tickRate, (boolean)false)).isEmpty()) continue;
            FluidUtil.tryFluidTransfer((IFluidHandler)fluidTank, (IFluidHandler)handler, (int)simulation.getAmount(), (boolean)true);
        }
    }

    private WootFluidTankHandler createOutputTank() {
        if (!this.hasOutputFluidCapability()) {
            return null;
        }
        return new WootFluidTankHandler(this.getOutputTankCapacity(), true){

            protected void onContentsChanged() {
                WootMachineBlockEntity.this.setChanged();
            }
        };
    }

    public WootFluidTankHandler getOutputTank() {
        return this.outputTankHandler;
    }

    public abstract int getOutputTankCapacity();

    public abstract boolean hasOutputFluidCapability();

    public static IEnergyStorage getEnergyStorageCapability(WootMachineBlockEntity blockEntity, Direction side) {
        return blockEntity.energyHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        long progress = (long)this.processMax << 32 | (long)this.processRemaining;
        tag.putLong("Progress", progress);
        tag.putInt("RedstoneMode", this.redstoneMode.ordinal());
        ListTag list = new ListTag();
        List<Map<MachineSide, MachineSideProperty>> directionsProperties = this.getAllMachineSidesProperties();
        for (Map<MachineSide, MachineSideProperty> machineProperties : directionsProperties) {
            ListTag properties = new ListTag();
            for (Map.Entry<MachineSide, MachineSideProperty> entry : machineProperties.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putInt("Side", entry.getKey().ordinal());
                compoundTag.putInt("Property", entry.getValue().ordinal());
                properties.add((Object)compoundTag);
            }
            list.add((Object)properties);
        }
        tag.put("MachineProperties", (Tag)list);
        if (this.hasEnergyCapability()) {
            tag.put("Energy", (Tag)this.energyHandler.serializeNBT());
        }
        if (this.hasInputFluidCapability()) {
            tag.put("InputTank", (Tag)this.inputTankHandler.writeToNBT(new CompoundTag()));
        }
        if (this.hasOutputFluidCapability()) {
            tag.put("OutputTank", (Tag)this.outputTankHandler.writeToNBT(new CompoundTag()));
        }
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        long progress = tag.getLong("Progress");
        this.processMax = (int)(progress >> 32);
        this.processRemaining = (int)progress;
        if (this.processRemaining > 0) {
            this.isProcessActive = true;
        }
        this.redstoneMode = RedstoneMode.byIndex(tag.getInt("RedstoneMode"));
        ListTag list = tag.getList("MachineProperties", 9);
        for (int i = 0; i < list.size(); ++i) {
            Map<MachineSide, MachineSideProperty> properties = this.getAllMachineSidesProperties().get(i);
            ListTag propertiesList = list.getList(i);
            for (int j = 0; j < propertiesList.size(); ++j) {
                CompoundTag compoundTag = propertiesList.getCompound(j);
                properties.put(MachineSide.byIndex(compoundTag.getInt("Side")), MachineSideProperty.byIndex(compoundTag.getInt("Property")));
            }
        }
        if (this.hasEnergyCapability()) {
            this.energyHandler.deserializeNBT((Tag)tag.getCompound("Energy"));
        }
        if (this.hasInputFluidCapability()) {
            this.inputTankHandler.readFromNBT(tag.getCompound("InputTank"));
        }
        if (this.hasOutputFluidCapability()) {
            this.outputTankHandler.readFromNBT(tag.getCompound("OutputTank"));
        }
    }

    @NotNull
    public CompoundTag getUpdateTag() {
        CompoundTag tag = super.getUpdateTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public void sendNewState() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new WootMachineUpdate(this.getBlockPos(), this.redstoneMode, this.getAllMachineSidesProperties())});
    }

    public void handleNewState(WootMachineUpdate update) {
        if (update.redstoneMode() != null) {
            this.redstoneMode = update.redstoneMode();
        }
        if (update.listMachineProperties().size() == this.getAllMachineSidesProperties().size()) {
            this.setAllMachineSidesProperties(update.listMachineProperties());
        }
        this.setChanged();
    }

    public boolean canPlayerAccess(ServerPlayer player) {
        return !(player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) > 64.0);
    }
}

