/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WootConcatItemStack {
    final Item item;
    final CompoundTag tag;

    public WootConcatItemStack(Item item, CompoundTag tag) {
        this.item = item;
        this.tag = tag;
    }

    public int hashCode() {
        return Objects.hash(this.item, this.tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WootConcatItemStack)) {
            return false;
        }
        WootConcatItemStack stack = (WootConcatItemStack)o;
        return this.item == stack.item && Objects.equals(this.tag, stack.tag);
    }

    public static List<ItemStack> merge(List<ItemStack> unconcatItems) {
        HashMap<WootConcatItemStack, ItemStack> map = new HashMap<WootConcatItemStack, ItemStack>();
        for (ItemStack itemStack : unconcatItems) {
            if (itemStack.isEmpty()) continue;
            WootConcatItemStack stack = new WootConcatItemStack(itemStack.getItem(), itemStack.getTag());
            if (map.containsKey(stack)) {
                ItemStack existing = (ItemStack)map.get(stack);
                existing.grow(itemStack.getCount());
                continue;
            }
            map.put(stack, itemStack.copy());
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack itemStack : map.values()) {
            int maxStack = itemStack.getMaxStackSize();
            int count = itemStack.getCount();
            int stacks = count / maxStack;
            int rest = count % maxStack;
            itemStack.setCount(maxStack);
            for (int i = 0; i < stacks; ++i) {
                items.add(itemStack.copy());
            }
            if (rest == 0) continue;
            itemStack.setCount(rest);
            items.add(itemStack);
        }
        return items;
    }
}

