/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.factory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import wootrevived.api.WootFactoryMob;
import wootrevived.api.enums.Tier;
import wootrevived.api.interfaces.WootGenerationProperties;
import wootrevived.woot.drops.simulator.DropSimulator;

public class WootFactoryGenerationProperties
implements WootGenerationProperties {
    private final Tier factoryTier;
    private final WootFactoryMob<?> factoryMob;
    private final CompoundTag factoryMobTag;
    private final ServerLevel heartLevel;
    private final BlockPos heartPos;
    private int spawnRate;
    private int vitalityFuelCost;
    private int numberOfSimulations = 1;

    public WootFactoryGenerationProperties(Tier factoryTier, WootFactoryMob<?> factoryMob, CompoundTag factoryMobTag, ServerLevel heartLevel, BlockPos heartPos, int spawnRate, int vitalityFuelCost) {
        this.factoryTier = factoryTier;
        this.factoryMob = factoryMob;
        this.factoryMobTag = factoryMobTag;
        this.heartLevel = heartLevel;
        this.heartPos = heartPos;
        this.spawnRate = spawnRate;
        this.vitalityFuelCost = vitalityFuelCost;
    }

    @Override
    public int getSpawnRate() {
        return this.spawnRate;
    }

    @Override
    public void setSpawnRate(int spawnRate) {
        this.spawnRate = Math.max(0, spawnRate);
    }

    @Override
    public int getVitalityFuelCost() {
        return this.vitalityFuelCost;
    }

    @Override
    public void setVitalityFuelCost(int vitalityFuelCost) {
        this.vitalityFuelCost = Math.max(0, vitalityFuelCost);
    }

    @Override
    public int getNumberOfSimulations() {
        return this.numberOfSimulations;
    }

    @Override
    public void setNumberOfSimulations(int numberOfSimulations) {
        this.numberOfSimulations = Math.max(1, numberOfSimulations);
    }

    @Override
    @NotNull
    public ServerLevel getLevel() {
        return DropSimulator.getLevel();
    }

    @Override
    @NotNull
    public RandomSource getRandom() {
        return DropSimulator.getRandom();
    }

    @Override
    @NotNull
    public HolderLookup.Provider getLookupProvider() {
        return DropSimulator.getLookupProvider();
    }

    @Override
    @NotNull
    public Tier getFactoryTier() {
        return this.factoryTier;
    }

    @Override
    @NotNull
    public WootFactoryMob<?> getFactoryMob() {
        return this.factoryMob;
    }

    @Override
    @NotNull
    public CompoundTag getFactoryMobTag() {
        return this.factoryMobTag.copy();
    }

    @Override
    @NotNull
    public ServerLevel getHeartLevel() {
        return this.heartLevel;
    }

    @Override
    @NotNull
    public BlockPos getHeartPos() {
        return this.heartPos;
    }
}

