/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class WootImportItemHandler
implements IItemHandler {
    private final Map<Integer, List<ItemStack>> importItems = new HashMap<Integer, List<ItemStack>>();
    private final Map<Integer, List<Integer>> items = new HashMap<Integer, List<Integer>>();

    public void setImportItem(int index, List<ItemStack> importItem) {
        if (this.isEqual(this.importItems.get(index), importItem)) {
            return;
        }
        this.importItems.put(index, importItem);
        if (importItem != null) {
            this.items.put(index, new ArrayList<Integer>(Collections.nCopies(importItem.size(), 0)));
        }
    }

    private boolean isEqual(List<ItemStack> list1, List<ItemStack> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            ItemStack item1 = list1.get(i);
            ItemStack item2 = list2.get(i);
            if (item1.getCount() != item2.getCount()) {
                return false;
            }
            if (item1.getItem() != item2.getItem()) {
                return false;
            }
            if (Objects.equals(item1.getTag(), item2.getTag())) continue;
            return false;
        }
        return true;
    }

    public boolean isImportValid(int index) {
        List<ItemStack> list = this.importItems.get(index);
        if (list == null) {
            return true;
        }
        List<Integer> counts = this.items.get(index);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getCount() == counts.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    public void consume(int index) {
        List<Integer> counts = this.items.get(index);
        if (counts == null) {
            return;
        }
        Collections.fill(counts, 0);
    }

    public int getSlots() {
        return 1;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack s : list) {
                if (stack.getItem() != s.getItem() || !Objects.equals(stack.getTag(), s.getTag())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.isItemValid(0, stack) || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            List<Integer> item = this.items.get(i);
            for (int j = 0; j < list.size(); ++j) {
                ItemStack s = list.get(j);
                if (stack.getItem() != s.getItem() || !Objects.equals(stack.getTag(), s.getTag())) continue;
                int amount = item.get(j);
                int needToBeAdded = s.getCount() - amount;
                if (stack.getCount() <= needToBeAdded) {
                    if (!simulate) {
                        item.set(j, amount + stack.getCount());
                    }
                    return ItemStack.EMPTY;
                }
                if (!simulate) {
                    item.set(j, amount + needToBeAdded);
                }
                stack.shrink(needToBeAdded);
            }
        }
        return stack;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            List<ItemStack> list = this.importItems.get(i);
            if (list == null) continue;
            for (ItemStack stack : list) {
                if (count >= stack.getCount()) continue;
                count = stack.getCount();
            }
        }
        return count;
    }

    public void save(CompoundTag tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = new CompoundTag();
            List<ItemStack> stackList = this.importItems.get(i);
            compoundTag.putBoolean("IsNull", stackList == null);
            if (stackList == null) {
                list.add((Object)compoundTag);
                continue;
            }
            ListTag stackListTag = new ListTag();
            for (int j = 0; j < stackList.size(); ++j) {
                CompoundTag stackTag = new CompoundTag();
                ItemStack itemStack = stackList.get(j);
                stackTag.put("Item", (Tag)itemStack.save(new CompoundTag()));
                stackTag.putInt("Count", this.items.get(i).get(j).intValue());
                stackListTag.add((Object)stackTag);
            }
            compoundTag.put("Stacks", (Tag)stackListTag);
            list.add((Object)compoundTag);
        }
        tag.put("ItemHandler", (Tag)list);
    }

    public void load(CompoundTag tag) {
        this.importItems.clear();
        this.items.clear();
        ListTag list = tag.getList("ItemHandler", 10);
        for (int i = 0; i < 4; ++i) {
            CompoundTag compoundTag = list.getCompound(i);
            if (compoundTag.getBoolean("IsNull")) continue;
            ListTag stackListTag = compoundTag.getList("Stacks", 10);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            ArrayList<Integer> items = new ArrayList<Integer>();
            for (int j = 0; j < stackListTag.size(); ++j) {
                CompoundTag stackTag = stackListTag.getCompound(j);
                stackList.add(ItemStack.of((CompoundTag)stackTag.getCompound("Item")));
                items.add(stackTag.getInt("Count"));
            }
            this.importItems.put(i, stackList);
            this.items.put(i, items);
        }
    }
}

