/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.handlers.WootItemStackHandler;

public class WootItemHandlerWrapper
implements IItemHandler {
    private final List<ItemWrapper> itemWrappers = new ArrayList<ItemWrapper>();

    public WootItemHandlerWrapper addHandler(WootItemStackHandler item, Supplier<MachineSideProperty> property) {
        this.itemWrappers.add(new ItemWrapper(item, property));
        return this;
    }

    public int getSlots() {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            size += itemWrapper.item.getSlots();
        }
        return size;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            WootItemStackHandler handler = itemWrapper.item;
            if (slot >= size + handler.getSlots()) {
                size += handler.getSlots();
                continue;
            }
            return handler.getStackInSlot(slot - size);
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            WootItemStackHandler handler = itemWrapper.item;
            if (slot >= size + handler.getSlots()) {
                size += handler.getSlots();
                continue;
            }
            MachineSideProperty property = itemWrapper.property().get();
            if (handler.isOutput || !handler.isItemValid(slot - size, stack) || property == MachineSideProperty.DISABLED || property == MachineSideProperty.PUSH) break;
            return handler.insertItem(slot - size, stack, simulate);
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            WootItemStackHandler handler = itemWrapper.item;
            if (slot >= size + handler.getSlots()) {
                size += handler.getSlots();
                continue;
            }
            MachineSideProperty property = itemWrapper.property().get();
            if (property == MachineSideProperty.DISABLED || property == MachineSideProperty.PULL) break;
            return handler.extractItem(slot - size, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            WootItemStackHandler handler = itemWrapper.item;
            if (slot >= size + handler.getSlots()) {
                size += handler.getSlots();
                continue;
            }
            return handler.getSlotLimit(slot - size);
        }
        return 0;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        int size = 0;
        for (ItemWrapper itemWrapper : this.itemWrappers) {
            WootItemStackHandler handler = itemWrapper.item;
            if (slot >= size + handler.getSlots()) {
                size += handler.getSlots();
                continue;
            }
            return handler.isItemValid(slot - size, stack);
        }
        return false;
    }

    private record ItemWrapper(WootItemStackHandler item, Supplier<MachineSideProperty> property) {
    }
}

