/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.recipes;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class WootContainer
implements Container {
    private final int size;
    private final NonNullList<Either<ItemStack, FluidStack>> ingredients;

    public WootContainer(int size) {
        this.size = size;
        this.ingredients = NonNullList.withSize((int)size, (Object)Either.left((Object)ItemStack.EMPTY));
    }

    @SafeVarargs
    public WootContainer(Either<ItemStack, FluidStack> ... ingredients) {
        this.size = ingredients.length;
        this.ingredients = NonNullList.of((Object)Either.left((Object)ItemStack.EMPTY), (Object[])ingredients);
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isItemStack(int slot) {
        return slot >= 0 && slot < this.ingredients.size() && ((Either)this.ingredients.get(slot)).left().isPresent();
    }

    public boolean isFluidStack(int slot) {
        return slot >= 0 && slot < this.ingredients.size() && ((Either)this.ingredients.get(slot)).right().isPresent();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).left().orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public FluidStack getFluid(int slot) {
        return slot >= 0 && slot < this.ingredients.size() ? ((Either)this.ingredients.get(slot)).right().orElse(FluidStack.EMPTY) : FluidStack.EMPTY;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = this.isItemStack(slot) && amount > 0 ? ((ItemStack)((Either)this.ingredients.get(slot)).left().get()).split(amount) : ItemStack.EMPTY;
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public FluidStack removeFluid(int slot, int amount) {
        FluidStack fluidStack;
        FluidStack fluidStack2 = fluidStack = this.isFluidStack(slot) && amount > 0 ? (FluidStack)((Either)this.ingredients.get(slot)).right().get() : FluidStack.EMPTY;
        if (!fluidStack.isEmpty()) {
            fluidStack.setAmount(fluidStack.getAmount() - amount);
            this.setChanged();
        }
        return fluidStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (this.isItemStack(slot)) {
            ItemStack itemstack = (ItemStack)((Either)this.ingredients.get(slot)).left().get();
            if (!itemstack.isEmpty()) {
                this.ingredients.set(0, (Object)Either.left((Object)ItemStack.EMPTY));
            }
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public FluidStack removeFluidNoUpdate(int slot) {
        if (this.isFluidStack(slot)) {
            FluidStack fluidStack = (FluidStack)((Either)this.ingredients.get(slot)).right().get();
            if (!fluidStack.isEmpty()) {
                this.ingredients.set(0, (Object)Either.right((Object)FluidStack.EMPTY));
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.ingredients.set(slot, (Object)Either.left((Object)stack));
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setFluid(int slot, FluidStack stack) {
        this.ingredients.set(slot, (Object)Either.right((Object)stack));
        this.setChanged();
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.ingredients.clear();
        this.setChanged();
    }
}

