/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import wootrevived.woot.Woot;
import wootrevived.woot.mixins.impl.GuiGraphicsMixin;
import wootrevived.woot.util.common.MachineSide;
import wootrevived.woot.util.common.MachineSideProperty;
import wootrevived.woot.util.common.RedstoneMode;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerMenu;
import wootrevived.woot.util.render.WootSlot;
import wootrevived.woot.util.render.WootStyles;
import wootrevived.woot.util.render.buttons.WootRedstoneButton;
import wootrevived.woot.util.render.buttons.WootSideButton;
import wootrevived.woot.util.render.buttons.WootSidePropertyButton;

public abstract class WootContainerScreen<T extends WootContainerMenu>
extends AbstractContainerScreen<T> {
    public static final ResourceLocation GUI = Woot.location("textures/gui/atlas.png");
    protected static final int GUI_XSIZE = 176;
    protected static final int GUI_YSIZE = 184;
    private int xSides = 8;
    private final int ySides = 84;
    private final List<WootSideButton> sideButtons = new ArrayList<WootSideButton>();
    private int activeSideButton = -1;
    private final Direction machineFacing;
    private final List<WootButton> buttons = new ArrayList<WootButton>();
    private final Map<MachineSide, WootSidePropertyButton> propertyButtons = Maps.newEnumMap(MachineSide.class);

    public void addRenderableWidget(WootButton button) {
        this.buttons.add(button);
        this.addWidget((GuiEventListener)button);
    }

    public WootContainerScreen(T container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 184;
        this.machineFacing = ((WootContainerMenu)((Object)container)).getMachineFacing();
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        this.addRenderableWidget(new WootRedstoneButton(this.leftPos + 154, this.topPos + 84, ((WootContainerMenu)this.menu).getRedstoneMode(), button -> {
            RedstoneMode mode = button.nextMode();
            ((WootContainerMenu)this.menu).setRedstoneMode(mode);
        }));
        this.xSides = 8;
        this.sideButtons.clear();
        this.initButtons();
        if (this.activeSideButton != -1) {
            this.sideButtons.get((int)this.activeSideButton).isViewActive = true;
        }
        this.createPropertyButton(81, 105, MachineSide.TOP);
        this.createPropertyButton(65, 121, MachineSide.LEFT);
        this.createPropertyButton(81, 121, MachineSide.FRONT);
        this.createPropertyButton(97, 121, MachineSide.RIGHT);
        this.createPropertyButton(81, 137, MachineSide.BOTTOM);
        this.createPropertyButton(97, 137, MachineSide.BACK);
    }

    protected void createPropertyButton(int x, int y, MachineSide side) {
        MachineSideProperty property = MachineSideProperty.ENABLED;
        if (this.activeSideButton != -1) {
            property = ((WootContainerMenu)this.menu).getMachineSideProperties(this.sideButtons.get((int)this.activeSideButton).propertiesIndex).get((Object)side);
        }
        WootSidePropertyButton button = new WootSidePropertyButton(this.leftPos + x, this.topPos + y, side, property, this.machineFacing, btn -> {
            Map<MachineSide, MachineSideProperty> properties = ((WootContainerMenu)this.menu).getMachineSideProperties(this.sideButtons.get((int)this.activeSideButton).propertiesIndex);
            properties.put(side, btn.nextProperty());
            ((WootContainerMenu)this.menu).setMachineSideProperties();
        });
        button.active = this.activeSideButton != -1;
        this.propertyButtons.put(side, button);
        this.addWidget((GuiEventListener)button);
    }

    protected abstract void initButtons();

    public void setButtonActive(WootSideButton button) {
        if (this.activeSideButton == button.index) {
            this.activeSideButton = -1;
            button.isViewActive = false;
            for (MachineSide side : MachineSide.values()) {
                this.propertyButtons.get((Object)((Object)side)).active = false;
            }
        } else {
            if (this.activeSideButton != -1) {
                this.sideButtons.get((int)this.activeSideButton).isViewActive = false;
            }
            this.activeSideButton = button.index;
            button.isViewActive = true;
            Map<MachineSide, MachineSideProperty> properties = ((WootContainerMenu)this.menu).getMachineSideProperties(button.propertiesIndex);
            for (MachineSide side : MachineSide.values()) {
                this.propertyButtons.get((Object)((Object)side)).active = true;
                this.propertyButtons.get((Object)((Object)side)).property = properties.get((Object)side);
            }
        }
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        for (Slot slot : ((WootContainerMenu)this.menu).slots) {
            if (!(slot instanceof WootSlot)) continue;
            WootSlot wootSlot = (WootSlot)slot;
            wootSlot.setActive(this.activeSideButton == -1);
        }
        super.render(gui, mouseX, mouseY, partialTicks);
        super.renderTooltip(gui, mouseX, mouseY);
        this.renderTooltip(gui, mouseX, mouseY);
        for (WootButton button : this.buttons) {
            button.render(gui, mouseX, mouseY, partialTicks);
        }
        if (this.activeSideButton != -1) {
            this.renderInventoryHoverBox(gui, 7, 101, 169, 155);
            for (MachineSide side : MachineSide.values()) {
                WootSidePropertyButton button = this.propertyButtons.get((Object)side);
                button.render(gui, mouseX, mouseY, partialTicks);
            }
        }
    }

    private void renderInventoryHoverBox(@NotNull GuiGraphics gui, int minX, int minY, int maxX, int maxY) {
        gui.fill((minX += this.leftPos) + 1, (minY += this.topPos) + 1, (maxX += this.leftPos) - 1, (maxY += this.topPos) - 1, -2368549);
        gui.fill(minX, minY, maxX - 1, minY + 1, -13224393);
        gui.fill(minX, minY, minX + 1, maxY - 1, -13224393);
        gui.fill(minX + 1, maxY - 1, maxX, maxY, -1);
        gui.fill(maxX - 1, minY + 1, maxX, maxY, -1);
    }

    protected void renderLabels(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
        int titleX = 1 + (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        gui.drawString(this.font, this.title, titleX, 6, 0x404040, false);
    }

    protected void renderBg(@NotNull GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        gui.blit(GUI, 0, 0, 0, 0, this.imageWidth, this.imageHeight);
        this.renderMenuBackground(gui);
        this.renderState(gui);
        pose.popPose();
    }

    protected abstract void renderMenuBackground(@NotNull GuiGraphics var1);

    protected abstract void renderState(@NotNull GuiGraphics var1);

    public static void renderSlot(@NotNull GuiGraphics gui, int x, int y, int color) {
        WootContainerScreen.stroke(gui, x - 1, y - 1, x + 18, y + 18, color & 0x2FFFFFFF);
        gui.blit(GUI, x, y, 228, 0, 18, 18);
        gui.fill(x + 1, y + 1, x + 17, y + 17, color & 0x4FFFFFFF);
    }

    public static void renderVanillaSlot(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 7, 101, 18, 18);
    }

    public void createSlotSideButton(int x, int y, int color, int propertiesIndex, Component name) {
        WootSideButton button = new WootSideButton(this.sideButtons.size(), this.leftPos + this.xSides, this.topPos + 84, this.leftPos + x - 2, this.topPos + y - 2, 21, 21, color, propertiesIndex, name, this::setButtonActive);
        this.sideButtons.add(button);
        this.addRenderableWidget(button);
        this.xSides += 18;
    }

    public static void renderEnergyBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 177, 0, 18, 56);
    }

    public static void renderEnergy(@NotNull GuiGraphics gui, int x, int y, int fill, int capacity) {
        int fillHeight = Mth.clamp((int)(fill * 50 / capacity), (int)0, (int)50);
        int fillY = 50 - fillHeight;
        gui.blit(GUI, x + 3, y + fillY + 3, 196, 3 + fillY, 12, fillHeight);
    }

    public void renderEnergyTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity) {
        if (this.isHovering(x, y, 18, 56, mouseX, mouseY)) {
            WootContainerScreen._renderEnergyTooltip(gui, mouseX, mouseY, x, y, fill, capacity, true, true);
        }
    }

    public static void _renderEnergyTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x, y, 18, 56, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(Component.translatable((String)"info.woot_revived.power").append((Component)Component.literal((String)":")).setStyle(WootStyles.MACHINE_STYLE), Component.literal((String)WootContainerScreen.formatInteger(fill)).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)" FE").setStyle(WootStyles.UNIT_STYLE))) : List.of(Component.translatable((String)"info.woot_revived.power").append((Component)Component.literal((String)":")).setStyle(WootStyles.MACHINE_STYLE), Component.literal((String)WootContainerScreen.formatInteger(fill)).append((Component)Component.literal((String)" FE").setStyle(WootStyles.UNIT_STYLE)));
            gui.renderTooltip(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderFluidBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 209, 0, 18, 56);
    }

    public static void renderFluid(@NotNull GuiGraphics gui, int x, int y, FluidStack fluid, int capacity) {
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        int fillHeight = Mth.clamp((int)(fluid.getAmount() * 50 / capacity), (int)0, (int)50);
        int fillY = 50 - fillHeight;
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((FluidType)fluid.getFluid().getFluidType());
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(fluidTypeExtensions.getStillTexture());
        WootContainerScreen.renderTiledFluidTextureAtlas(gui, texture, x + 3, y + fillY + 3, 12, fillHeight, fluidTypeExtensions.getTintColor(), false);
        gui.blit(GUI, x + 3, y + 3, 212, 3, 12, 50);
    }

    public void createFluidSideButton(int x, int y, int color, int propertiesIndex, Component name) {
        WootSideButton button = new WootSideButton(this.sideButtons.size(), this.leftPos + this.xSides, this.topPos + 84, this.leftPos + x - 2, this.topPos + y - 2, 21, 59, color, propertiesIndex, name, this::setButtonActive);
        this.sideButtons.add(button);
        this.addRenderableWidget(button);
        this.xSides += 18;
    }

    public void renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity) {
        if (this.isHovering(x, y, 18, 56, mouseX, mouseY)) {
            WootContainerScreen._renderFluidTooltip(gui, mouseX, mouseY, x, y, fluid, capacity, true, true);
        }
    }

    public static void _renderFluidTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, FluidStack fluid, int capacity, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x, y, 18, 56, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.translatable((String)"info.woot_revived.empty"))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE))) : List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.fluid").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append((Component)(fluid != null && !fluid.isEmpty() ? fluid.getDisplayName() : Component.translatable((String)"info.woot_revived.empty"))), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.amount").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(fluid.getAmount())).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
            gui.renderTooltip(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderTiledFluidTextureAtlas(@NotNull GuiGraphics guiGraphics, TextureAtlasSprite sprite, int x, int y, int width, int height, int color, boolean enableBlend) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        if (enableBlend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        int spriteWidth = sprite.contents().width();
        int spriteHeight = sprite.contents().height();
        for (int i = 0; i < width; i += spriteWidth) {
            for (int j = 0; j < height; j += spriteHeight) {
                int drawWidth = Math.min(width - i, spriteWidth);
                int drawHeight = Math.min(height - j, spriteHeight);
                WootContainerScreen.renderScaledTexturedModelRectFromIcon(guiGraphics, sprite, x + i, y + j, drawWidth, drawHeight, color);
            }
        }
        if (enableBlend) {
            RenderSystem.disableBlend();
        }
    }

    public static void renderScaledTexturedModelRectFromIcon(@NotNull GuiGraphics guiGraphics, TextureAtlasSprite icon, int x, int y, int width, int height, int color) {
        if (icon == null) {
            return;
        }
        float minU = icon.getU0();
        float maxU = icon.getU1();
        float minV = icon.getV0();
        float maxV = icon.getV1();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        builder.vertex(matrix, (float)x, (float)(y + height), 0.0f).uv(minU, minV + (maxV - minV) * (float)height / 16.0f).color(red, green, blue, 1.0f).endVertex();
        builder.vertex(matrix, (float)(x + width), (float)(y + height), 0.0f).uv(minU + (maxU - minU) * (float)width / 16.0f, minV + (maxV - minV) * (float)height / 16.0f).color(red, green, blue, 1.0f).endVertex();
        builder.vertex(matrix, (float)(x + width), (float)y, 0.0f).uv(minU + (maxU - minU) * (float)width / 16.0f, minV).color(red, green, blue, 1.0f).endVertex();
        builder.vertex(matrix, (float)x, (float)y, 0.0f).uv(minU, minV).color(red, green, blue, 1.0f).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
    }

    public static void renderProgressArrowBg(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 228, 19, 22, 15);
    }

    public static void renderProgressArrow(@NotNull GuiGraphics gui, int x, int y, int progress) {
        int fillWidth = Mth.clamp((int)(progress * 22 / 100), (int)0, (int)22);
        gui.blit(GUI, x, y, 228, 35, fillWidth, 16);
    }

    public void renderProgressArrowTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage) {
        this.renderProgressTooltip(gui, mouseX, mouseY, x, y, 22, 16, progress, eta, usage);
    }

    public static void _renderProgressArrowTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int progress, float eta, int usage, boolean skipHover) {
        WootContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, 22, 16, progress, eta, usage, skipHover);
    }

    public void renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, int progress, float eta, int usage) {
        if (this.isHovering(x, y, width, height, mouseX, mouseY)) {
            WootContainerScreen._renderProgressTooltip(gui, mouseX, mouseY, x, y, width, height, progress, eta, usage, true);
        }
    }

    public static void _renderProgressTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int width, int height, int progress, float eta, int usage, boolean skipHover) {
        if (skipHover || WootContainerScreen._isHovering(x, y, width, height, mouseX, mouseY)) {
            List<MutableComponent> tooltip = List.of(Component.empty().append((Component)Component.translatable((String)"info.woot_revived.progress").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(progress)).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.literal((String)"100")), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.eta").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(String.format("%.1f", Float.valueOf(eta))).append((Component)Component.literal((String)"s").setStyle(WootStyles.UNIT_STYLE)), Component.empty().append((Component)Component.translatable((String)"info.woot_revived.usage").append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(usage)).append((Component)Component.literal((String)" FE").setStyle(WootStyles.UNIT_STYLE)).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append((Component)Component.literal((String)"t").setStyle(WootStyles.UNIT_STYLE)));
            gui.renderTooltip(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void renderColorBarBg(@NotNull GuiGraphics gui, int x, int y, float[] color) {
        gui.blit(GUI, x, y, 177, 57, 56, 11);
        ((GuiGraphicsMixin)gui).woot$innerBlit(GUI, x + 3, x + 53, y + 3, y + 8, 0, 0.703125f, 0.8984375f, 0.26953125f, 0.2890625f, color[0], color[1], color[2], 1.0f);
    }

    public static void renderColorBar(@NotNull GuiGraphics gui, int x, int y, int fill, int capacity, float[] color) {
        int fillWidth = Mth.clamp((int)(fill * 50 / capacity), (int)0, (int)50);
        ((GuiGraphicsMixin)gui).woot$innerBlit(GUI, x + 3, x + 3 + fillWidth, y + 3, y + 8, 0, 0.703125f, (180.0f + (float)fillWidth) / 256.0f, 0.29296875f, 0.3125f, color[0], color[1], color[2], 1.0f);
    }

    public void renderColorBarTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, MutableComponent colorName) {
        if (this.isHovering(x + 1, y + 1, 54, 9, mouseX, mouseY)) {
            WootContainerScreen._renderColorBarTooltip(gui, mouseX, mouseY, x, y, fill, capacity, colorName, true, true);
        }
    }

    public static void _renderColorBarTooltip(@NotNull GuiGraphics gui, int mouseX, int mouseY, int x, int y, int fill, int capacity, MutableComponent colorName, boolean skipHover, boolean showCapacity) {
        if (skipHover || WootContainerScreen._isHovering(x + 1, y + 1, 54, 9, mouseX, mouseY)) {
            List<MutableComponent> tooltip = showCapacity ? List.of(colorName.append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE), Component.literal((String)WootContainerScreen.formatInteger(fill)).append((Component)Component.literal((String)"/").setStyle(WootStyles.MACHINE_STYLE)).append(WootContainerScreen.formatInteger(capacity)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE))) : List.of(colorName.append((Component)Component.literal((String)": ")).setStyle(WootStyles.MACHINE_STYLE), Component.literal((String)WootContainerScreen.formatInteger(fill)).append((Component)Component.literal((String)"mB").setStyle(WootStyles.UNIT_STYLE)));
            gui.renderTooltip(WootContainerScreen.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public static void stroke(@NotNull GuiGraphics gui, int minX, int minY, int maxX, int maxY, int color) {
        gui.hLine(minX, maxX, minY, color);
        gui.vLine(maxX, minY, maxY, color);
        gui.hLine(maxX, minX, maxY, color);
        gui.vLine(minX, maxY, minY, color);
    }

    public static String formatInteger(int val) {
        return String.format(Locale.US, "%,d", val).replace(",", " ");
    }

    public static String formatFloat(float val) {
        return String.format(Locale.US, "%,.1f", Float.valueOf(val)).replace(",", " ");
    }

    public static Font getFont() {
        return Minecraft.getInstance().font;
    }

    public static boolean _isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static void renderPlus(@NotNull GuiGraphics gui, int x, int y) {
        gui.blit(GUI, x, y, 234, 57, 13, 14);
    }
}

