/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import wootrevived.woot.events.client.GlobalClientTicker;

public class WootEntityRenderer {
    public static void render(@NotNull GuiGraphics gui, int x, int y, @NotNull LivingEntity entity, double size, double padding, float max_entity_size) {
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (renderer == null) {
            return;
        }
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 0.0f);
        Matrix4f matrix = pose.last().pose();
        Vector3f poseScale = new Vector3f();
        Vector3f pos = new Vector3f();
        matrix.getScale(poseScale);
        matrix.transformPosition(pos);
        float width = max_entity_size / entity.getBbWidth();
        float height = max_entity_size / entity.getBbHeight();
        float scale = Math.min(width, height);
        scale = Math.min(scale, max_entity_size);
        pose.translate(size / 2.0 + padding, size / 2.0 - padding * 2.0 + (double)(entity.getBbHeight() * scale), 64.0);
        WootEntityRenderer.patchedScale(pose, 1.0f, 1.0f, -1.0f);
        pose.mulPose(Axis.YP.rotationDegrees((float)(GlobalClientTicker.tickCounter * 4 % 360)));
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        pose.scale(scale, scale, scale);
        Window window = Minecraft.getInstance().getWindow();
        double windowScale = (double)window.getWidth() / (double)window.getGuiScaledWidth();
        RenderSystem.enableScissor((int)((int)(((double)pos.x + padding * (double)poseScale.x) * windowScale)), (int)((int)((double)window.getHeight() - ((double)pos.y + (size + padding) * (double)poseScale.y) * windowScale)), (int)((int)Math.ceil(size * windowScale * (double)poseScale.x)), (int)((int)Math.ceil(size * windowScale * (double)poseScale.y)));
        Tesselator tesselator = Tesselator.getInstance();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediate((BufferBuilder)tesselator.getBuilder());
        Lighting.setupForFlatItems();
        renderer.render((Entity)entity, 0.0f, 0.0f, pose, (MultiBufferSource)bufferSource, LightTexture.pack((int)15, (int)15));
        bufferSource.endLastBatch();
        RenderSystem.disableScissor();
        Lighting.setupFor3DItems();
        pose.popPose();
    }

    public static void patchedScale(PoseStack poseStack, float x, float y, float z) {
        PoseStack.Pose pose = poseStack.last();
        pose.pose().scale(x, y, z);
        float fx = 1.0f / x;
        float fy = 1.0f / y;
        float fz = 1.0f / z;
        float fw = Mth.fastInvCubeRoot((float)Math.abs(fx * fy * fz));
        pose.normal().scale(fw * fx, fw * fy, fw * fz);
    }
}

