/*
 * Decompiled with CFR 0.152.
 */
package wootrevived.woot.util.render.buttons;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import wootrevived.woot.util.render.WootButton;
import wootrevived.woot.util.render.WootContainerScreen;

public class WootSideButton
extends WootButton {
    protected final OnPress onPress;
    protected final int elemX;
    protected final int elemY;
    protected final int elemWidth;
    protected final int elemHeight;
    protected final int color;
    protected final Component name;
    public final int index;
    public final int propertiesIndex;
    public boolean isViewActive = false;

    public WootSideButton(int index, int x, int y, int elemX, int elemY, int elemWidth, int elemHeight, int color, int propertiesIndex, Component name, OnPress onPress) {
        super(x, y, 14, 14);
        this.onPress = onPress;
        this.index = index;
        this.elemX = elemX;
        this.elemY = elemY;
        this.elemWidth = elemWidth;
        this.elemHeight = elemHeight;
        this.color = color;
        this.name = name;
        this.propertiesIndex = propertiesIndex;
    }

    @Override
    protected void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.blit(WootContainerScreen.GUI, this.getX(), this.getY(), 200, 177, this.getWidth(), this.getHeight());
        gui.fill(this.getX() + 2, this.getY() + 2, this.getX() + this.getWidth() - 2, this.getY() + this.getHeight() - 2, this.color);
        if (this.isHovered()) {
            gui.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1, -2130706433);
            gui.renderTooltip(WootContainerScreen.getFont(), this.name, mouseX, mouseY);
        }
        if (this.isHovered() || this.isViewActive) {
            WootContainerScreen.stroke(gui, this.elemX, this.elemY, this.elemX + this.elemWidth, this.elemY + this.elemHeight, this.color);
        }
    }

    @Override
    public void onPress() {
        this.onPress.onPress(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(WootSideButton var1);
    }
}

