/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1802;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ConfigData.class, (Object)new ConfigDataAdapter()).setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/autoeat.json");
    private static final Map<String, Boolean> DEFAULT_BLACKLIST = new HashMap<String, Boolean>();
    public static final Map<String, Boolean> blacklist;
    private static final int MAX_BARS = 10;
    private static final int MAX_HEARTS = 10;
    private static final int MAX_FORCE_PLACE_COOLDOWN = 5;
    private static final int MAX_ON_HIT_COOLDOWN = 10;
    private static final int MAX_ON_CLICK_COOLDOWN = 10;
    private static boolean detectModFoods;
    private static boolean preferBestFood;
    private static boolean eatUntilFull;
    private static int eatThresholdShanks;
    private static boolean offhandFirst;
    private static boolean showToggleToast;
    private static boolean smartModeEnabled;
    private static int emergencyHearts;
    private static boolean allowForcePlaceWhileEating;
    private static int forcePlaceCooldownSec;
    private static boolean pauseOnHit;
    private static int onHitCooldownSec;
    private static boolean pauseOnClickEnabled;
    private static int onClickCooldownSec;
    private static boolean pauseWhileSprinting;
    private static boolean pauseWhileAiming;
    private static boolean autoBlockNegativeEffects;

    public static void load() {
        block11: {
            try {
                if (CONFIG_FILE.exists()) {
                    try (FileReader reader = new FileReader(CONFIG_FILE);){
                        ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                        blacklist.clear();
                        blacklist.putAll(DEFAULT_BLACKLIST);
                        if (data != null) {
                            if (data.blacklist != null) {
                                for (Map.Entry<String, Boolean> e : data.blacklist.entrySet()) {
                                    blacklist.put(e.getKey(), e.getValue() != null && e.getValue() != false);
                                }
                            }
                            detectModFoods = data.detectModFoods;
                            preferBestFood = data.preferBestFood;
                            eatUntilFull = data.eatUntilFull;
                            eatThresholdShanks = ConfigManager.clampBars(data.eatThresholdShanks);
                            offhandFirst = data.offhandFirst;
                            showToggleToast = data.showToggleToast;
                            smartModeEnabled = data.smartModeEnabled;
                            emergencyHearts = ConfigManager.clampHearts(data.emergencyHearts);
                            allowForcePlaceWhileEating = data.allowForcePlaceWhileEating;
                            forcePlaceCooldownSec = ConfigManager.clampForcePlaceCooldown(data.forcePlaceCooldownSec);
                            pauseOnHit = data.migrationPauseOnHitDefined ? data.pauseOnHit : data.cancelOnMobHit || data.cancelOnPlayerHit;
                            onHitCooldownSec = ConfigManager.clampOnHitCooldown(data.onHitCooldownSec);
                            pauseOnClickEnabled = data.pauseOnClickEnabled;
                            onClickCooldownSec = ConfigManager.clampOnClickCooldown(data.onClickCooldownSec);
                            pauseWhileSprinting = data.pauseWhileSprinting;
                            pauseWhileAiming = data.pauseWhileAiming;
                            autoBlockNegativeEffects = data.autoBlockNegativeEffects;
                        }
                        break block11;
                    }
                }
                blacklist.clear();
                blacklist.putAll(DEFAULT_BLACKLIST);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void save() {
        try {
            boolean ok;
            File dir = CONFIG_FILE.getParentFile();
            if (!(dir == null || dir.exists() || (ok = dir.mkdirs()) || dir.exists())) {
                throw new RuntimeException("Cannot create config dir: " + String.valueOf(dir));
            }
            ConfigData out = new ConfigData();
            out.blacklist = new HashMap<String, Boolean>(blacklist);
            out.detectModFoods = detectModFoods;
            out.preferBestFood = preferBestFood;
            out.eatUntilFull = eatUntilFull;
            out.eatThresholdShanks = eatThresholdShanks;
            out.offhandFirst = offhandFirst;
            out.showToggleToast = showToggleToast;
            out.smartModeEnabled = smartModeEnabled;
            out.emergencyHearts = emergencyHearts;
            out.allowForcePlaceWhileEating = allowForcePlaceWhileEating;
            out.forcePlaceCooldownSec = forcePlaceCooldownSec;
            out.pauseOnHit = pauseOnHit;
            out.onHitCooldownSec = onHitCooldownSec;
            out.pauseOnClickEnabled = pauseOnClickEnabled;
            out.onClickCooldownSec = onClickCooldownSec;
            out.pauseWhileSprinting = pauseWhileSprinting;
            out.pauseWhileAiming = pauseWhileAiming;
            out.autoBlockNegativeEffects = autoBlockNegativeEffects;
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)out, (Appendable)writer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBlacklisted(String key) {
        return blacklist.getOrDefault(key, false);
    }

    public static void set(String key, boolean value) {
        blacklist.put(key, value);
    }

    public static boolean isDetectModFoods() {
        return detectModFoods;
    }

    public static void setDetectModFoods(boolean v) {
        detectModFoods = v;
        ConfigManager.save();
    }

    public static boolean isPreferBestFood() {
        return preferBestFood;
    }

    public static void setPreferBestFood(boolean v) {
        preferBestFood = v;
        ConfigManager.save();
    }

    public static boolean isEatUntilFull() {
        return eatUntilFull;
    }

    public static void setEatUntilFull(boolean v) {
        eatUntilFull = v;
        ConfigManager.save();
    }

    public static boolean isOffhandFirst() {
        return offhandFirst;
    }

    public static void setOffhandFirst(boolean v) {
        offhandFirst = v;
        ConfigManager.save();
    }

    public static boolean isShowToggleToast() {
        return showToggleToast;
    }

    public static void setShowToggleToast(boolean v) {
        showToggleToast = v;
        ConfigManager.save();
    }

    public static boolean isSmartModeEnabled() {
        return smartModeEnabled;
    }

    public static void setSmartModeEnabled(boolean v) {
        smartModeEnabled = v;
        ConfigManager.save();
    }

    public static int getEmergencyHearts() {
        return ConfigManager.clampHearts(emergencyHearts);
    }

    public static void setEmergencyHearts(int v) {
        emergencyHearts = ConfigManager.clampHearts(v);
        ConfigManager.save();
    }

    public static int getEatThresholdShanks() {
        return ConfigManager.clampBars(eatThresholdShanks);
    }

    public static void setEatThresholdShanks(int v) {
        eatThresholdShanks = ConfigManager.clampBars(v);
        ConfigManager.save();
    }

    public static int getEatThresholdBars() {
        return ConfigManager.getEatThresholdShanks();
    }

    public static boolean isAllowForcePlaceWhileEating() {
        return allowForcePlaceWhileEating;
    }

    public static void setAllowForcePlaceWhileEating(boolean v) {
        allowForcePlaceWhileEating = v;
        ConfigManager.save();
    }

    public static int getForcePlaceCooldownSec() {
        return ConfigManager.clampForcePlaceCooldown(forcePlaceCooldownSec);
    }

    public static void setForcePlaceCooldownSec(int v) {
        forcePlaceCooldownSec = ConfigManager.clampForcePlaceCooldown(v);
        ConfigManager.save();
    }

    public static boolean isPauseOnHit() {
        return pauseOnHit;
    }

    public static void setPauseOnHit(boolean v) {
        pauseOnHit = v;
        ConfigManager.save();
    }

    public static int getOnHitCooldownSec() {
        return ConfigManager.clampOnHitCooldown(onHitCooldownSec);
    }

    public static void setOnHitCooldownSec(int v) {
        onHitCooldownSec = ConfigManager.clampOnHitCooldown(v);
        ConfigManager.save();
    }

    public static boolean isPauseOnClickEnabled() {
        return pauseOnClickEnabled;
    }

    public static void setPauseOnClickEnabled(boolean v) {
        pauseOnClickEnabled = v;
        ConfigManager.save();
    }

    public static int getOnClickCooldownSec() {
        return ConfigManager.clampOnClickCooldown(onClickCooldownSec);
    }

    public static void setOnClickCooldownSec(int v) {
        onClickCooldownSec = ConfigManager.clampOnClickCooldown(v);
        ConfigManager.save();
    }

    public static boolean isPauseWhileSprinting() {
        return pauseWhileSprinting;
    }

    public static void setPauseWhileSprinting(boolean v) {
        pauseWhileSprinting = v;
        ConfigManager.save();
    }

    public static boolean isPauseWhileAiming() {
        return pauseWhileAiming;
    }

    public static void setPauseWhileAiming(boolean v) {
        pauseWhileAiming = v;
        ConfigManager.save();
    }

    public static boolean isAutoBlockNegativeEffects() {
        return autoBlockNegativeEffects;
    }

    public static void setAutoBlockNegativeEffects(boolean v) {
        autoBlockNegativeEffects = v;
        ConfigManager.save();
    }

    private static int clampBars(int v) {
        return Math.max(0, Math.min(10, v));
    }

    private static int clampHearts(int v) {
        return Math.max(0, Math.min(10, v));
    }

    private static int clampForcePlaceCooldown(int v) {
        return Math.max(0, Math.min(5, v));
    }

    private static int clampOnHitCooldown(int v) {
        return Math.max(0, Math.min(10, v));
    }

    private static int clampOnClickCooldown(int v) {
        return Math.max(0, Math.min(10, v));
    }

    static {
        DEFAULT_BLACKLIST.put(class_1802.field_8511.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8680.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8635.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8323.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8766.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8726.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8233.method_7876(), true);
        DEFAULT_BLACKLIST.put(class_1802.field_8463.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8367.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8071.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8308.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_20417.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8046.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8389.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8748.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8504.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8429.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8209.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8846.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8176.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8261.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8347.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8752.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8544.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8373.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8509.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8279.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8179.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8567.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8186.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8497.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_16998.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_28659.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8229.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8512.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8741.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8423.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8551.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8208.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_8515.method_7876(), false);
        DEFAULT_BLACKLIST.put(class_1802.field_17534.method_7876(), false);
        blacklist = new HashMap<String, Boolean>(DEFAULT_BLACKLIST);
        detectModFoods = true;
        preferBestFood = true;
        eatUntilFull = true;
        eatThresholdShanks = 1;
        offhandFirst = true;
        showToggleToast = true;
        smartModeEnabled = true;
        emergencyHearts = 4;
        allowForcePlaceWhileEating = true;
        forcePlaceCooldownSec = 2;
        pauseOnHit = true;
        onHitCooldownSec = 5;
        pauseOnClickEnabled = true;
        onClickCooldownSec = 2;
        pauseWhileSprinting = false;
        pauseWhileAiming = false;
        autoBlockNegativeEffects = true;
    }

    private static class ConfigData {
        @SerializedName(value="blacklist")
        Map<String, Boolean> blacklist = new HashMap<String, Boolean>();
        @SerializedName(value="detectModFoods")
        boolean detectModFoods = true;
        @SerializedName(value="preferBestFood")
        boolean preferBestFood = true;
        @SerializedName(value="eatUntilFull")
        boolean eatUntilFull = true;
        @SerializedName(value="eatThresholdShanks")
        int eatThresholdShanks = 1;
        @SerializedName(value="offhandFirst")
        boolean offhandFirst = true;
        @SerializedName(value="showToggleToast")
        boolean showToggleToast = true;
        @SerializedName(value="smartModeEnabled")
        boolean smartModeEnabled = true;
        @SerializedName(value="emergencyHearts")
        int emergencyHearts = 4;
        @SerializedName(value="allowForcePlaceWhileEating")
        boolean allowForcePlaceWhileEating = true;
        @SerializedName(value="forcePlaceCooldownSec")
        int forcePlaceCooldownSec = 2;
        @SerializedName(value="pauseOnHit")
        boolean pauseOnHit = true;
        @SerializedName(value="onHitCooldownSec")
        int onHitCooldownSec = 5;
        @SerializedName(value="pauseOnClickEnabled")
        boolean pauseOnClickEnabled = true;
        @SerializedName(value="onClickCooldownSec")
        int onClickCooldownSec = 2;
        @SerializedName(value="pauseWhileSprinting")
        boolean pauseWhileSprinting = false;
        @SerializedName(value="pauseWhileAiming")
        boolean pauseWhileAiming = false;
        @SerializedName(value="autoBlockNegativeEffects")
        boolean autoBlockNegativeEffects = true;
        boolean migrationPauseOnHitDefined = false;
        boolean cancelOnMobHit = true;
        boolean cancelOnPlayerHit = true;

        private ConfigData() {
        }
    }

    private static class ConfigDataAdapter
    implements JsonDeserializer<ConfigData>,
    JsonSerializer<ConfigData> {
        private ConfigDataAdapter() {
        }

        public ConfigData deserialize(JsonElement json, Type t, JsonDeserializationContext c) throws JsonParseException {
            ConfigData out = new ConfigData();
            if (json == null || json.isJsonNull()) {
                return out;
            }
            if (!json.isJsonObject()) {
                return out;
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("blacklist") && obj.get("blacklist").isJsonObject()) {
                for (Map.Entry e : obj.getAsJsonObject("blacklist").entrySet()) {
                    out.blacklist.put((String)e.getKey(), ConfigDataAdapter.asBool((JsonElement)e.getValue()));
                }
            } else {
                for (Map.Entry e : obj.entrySet()) {
                    if (!((JsonElement)e.getValue()).isJsonPrimitive() || !((JsonElement)e.getValue()).getAsJsonPrimitive().isBoolean()) continue;
                    out.blacklist.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsBoolean());
                }
            }
            out.detectModFoods = ConfigDataAdapter.getBool(obj, "detectModFoods", out.detectModFoods);
            out.preferBestFood = ConfigDataAdapter.getBool(obj, "preferBestFood", out.preferBestFood);
            out.eatUntilFull = ConfigDataAdapter.getBool(obj, "eatUntilFull", out.eatUntilFull);
            out.eatThresholdShanks = ConfigDataAdapter.getInt(obj, "eatThresholdShanks", out.eatThresholdShanks);
            out.offhandFirst = ConfigDataAdapter.getBool(obj, "offhandFirst", out.offhandFirst);
            out.showToggleToast = ConfigDataAdapter.getBool(obj, "showToggleToast", out.showToggleToast);
            out.smartModeEnabled = ConfigDataAdapter.getBool(obj, "smartModeEnabled", out.smartModeEnabled);
            out.emergencyHearts = ConfigDataAdapter.getInt(obj, "emergencyHearts", out.emergencyHearts);
            out.allowForcePlaceWhileEating = ConfigDataAdapter.getBool(obj, "allowForcePlaceWhileEating", out.allowForcePlaceWhileEating);
            out.forcePlaceCooldownSec = ConfigDataAdapter.getInt(obj, "forcePlaceCooldownSec", out.forcePlaceCooldownSec);
            if (obj.has("pauseOnHit")) {
                out.pauseOnHit = ConfigDataAdapter.getBool(obj, "pauseOnHit", out.pauseOnHit);
                out.migrationPauseOnHitDefined = true;
            }
            out.cancelOnMobHit = ConfigDataAdapter.getBool(obj, "cancelOnMobHit", out.cancelOnMobHit);
            out.cancelOnPlayerHit = ConfigDataAdapter.getBool(obj, "cancelOnPlayerHit", out.cancelOnPlayerHit);
            out.onHitCooldownSec = ConfigDataAdapter.getInt(obj, "onHitCooldownSec", out.onHitCooldownSec);
            out.pauseOnClickEnabled = ConfigDataAdapter.getBool(obj, "pauseOnClickEnabled", out.pauseOnClickEnabled);
            out.onClickCooldownSec = ConfigDataAdapter.getInt(obj, "onClickCooldownSec", out.onClickCooldownSec);
            out.pauseWhileSprinting = ConfigDataAdapter.getBool(obj, "pauseWhileSprinting", out.pauseWhileSprinting);
            out.pauseWhileAiming = ConfigDataAdapter.getBool(obj, "pauseWhileAiming", out.pauseWhileAiming);
            out.autoBlockNegativeEffects = ConfigDataAdapter.getBool(obj, "autoBlockNegativeEffects", out.autoBlockNegativeEffects);
            return out;
        }

        public JsonElement serialize(ConfigData src, Type t, JsonSerializationContext c) {
            JsonObject o = new JsonObject();
            JsonObject bl = new JsonObject();
            for (Map.Entry<String, Boolean> e : src.blacklist.entrySet()) {
                bl.addProperty(e.getKey(), e.getValue());
            }
            o.add("blacklist", (JsonElement)bl);
            o.addProperty("detectModFoods", Boolean.valueOf(src.detectModFoods));
            o.addProperty("preferBestFood", Boolean.valueOf(src.preferBestFood));
            o.addProperty("eatUntilFull", Boolean.valueOf(src.eatUntilFull));
            o.addProperty("eatThresholdShanks", (Number)src.eatThresholdShanks);
            o.addProperty("offhandFirst", Boolean.valueOf(src.offhandFirst));
            o.addProperty("showToggleToast", Boolean.valueOf(src.showToggleToast));
            o.addProperty("smartModeEnabled", Boolean.valueOf(src.smartModeEnabled));
            o.addProperty("emergencyHearts", (Number)src.emergencyHearts);
            o.addProperty("allowForcePlaceWhileEating", Boolean.valueOf(src.allowForcePlaceWhileEating));
            o.addProperty("forcePlaceCooldownSec", (Number)src.forcePlaceCooldownSec);
            o.addProperty("pauseOnHit", Boolean.valueOf(src.pauseOnHit));
            o.addProperty("onHitCooldownSec", (Number)src.onHitCooldownSec);
            o.addProperty("pauseOnClickEnabled", Boolean.valueOf(src.pauseOnClickEnabled));
            o.addProperty("onClickCooldownSec", (Number)src.onClickCooldownSec);
            o.addProperty("pauseWhileSprinting", Boolean.valueOf(src.pauseWhileSprinting));
            o.addProperty("pauseWhileAiming", Boolean.valueOf(src.pauseWhileAiming));
            o.addProperty("autoBlockNegativeEffects", Boolean.valueOf(src.autoBlockNegativeEffects));
            return o;
        }

        private static boolean getBool(JsonObject o, String k, boolean def) {
            return o.has(k) && o.get(k).isJsonPrimitive() && o.get(k).getAsJsonPrimitive().isBoolean() ? o.get(k).getAsBoolean() : def;
        }

        private static int getInt(JsonObject o, String k, int def) {
            return o.has(k) && o.get(k).isJsonPrimitive() && o.get(k).getAsJsonPrimitive().isNumber() ? o.get(k).getAsInt() : def;
        }

        private static boolean asBool(JsonElement e) {
            return e != null && e.isJsonPrimitive() && e.getAsJsonPrimitive().isBoolean() && e.getAsBoolean();
        }
    }
}

