/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;
import net.zynwro.autoeat.AutoEat;
import net.zynwro.autoeat.AutoEatConfigScreen;
import net.zynwro.autoeat.ConfigManager;

public class AutoEatAdvancedScreen
extends class_437 {
    private final class_437 parent;
    private static final int PADDING = 12;
    private static final int GAP = 6;
    private static final int BTN_H = 16;
    private static final int COL_GAP = 12;
    private static final int ADV_BTN_W = 140;
    private static final int ADV_BTN_H = 16;
    private static final int MAX_BARS = 10;
    private static final int MAX_HEARTS = 10;
    private static final int MAX_FP_SEC = 5;
    private static final int MAX_HIT_SEC = 10;
    private static final int MAX_CLICK_SEC = 10;
    private static final int MAX_SPRINT_GRACE_SEC = 10;
    private static final int MAX_AIM_GRACE_SEC = 10;
    private static final class_2960 MENU_BG = class_2960.method_60655((String)"minecraft", (String)"textures/gui/menu_background.png");
    private static final int TOOLTIP_DELAY_TICKS = 8;
    private static final int TOOLTIP_MAX_WIDTH = 220;
    private static final int TOOLTIP_PAD = 5;
    private static final int TOOLTIP_LINE_GAP = 2;
    private static final int TOAST_MAX_TICKS = 70;
    private final List<ToggleCtl> toggles = new ArrayList<ToggleCtl>();
    private final List<SliderCtl> sliders = new ArrayList<SliderCtl>();
    private int contentLeft;
    private int contentTop;
    private int contentRight;
    private int contentBottom;
    private int contentHeight;
    private double scrollY;
    private String hoveredId = "";
    private String statusMsg = "";
    private int hoverTicks;
    private int statusTicks;

    public AutoEatAdvancedScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Advanced Settings"));
        this.parent = parent;
    }

    protected void method_25426() {
        int btnW = 66;
        int gap = 6;
        int bottomY = this.field_22790 - 12 - 16;
        int footerW = btnW * 3 + gap * 2;
        int bottomX = Math.floorDiv(this.field_22789 - footerW, 2);
        this.method_37063((class_364)new AutoEatConfigScreen.ShaderStyleButton(bottomX, bottomY, btnW, 16, (class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            this.click();
            this.closeParent();
        }, true));
        this.method_37063((class_364)new AutoEatConfigScreen.ShaderStyleButton(bottomX + btnW + gap, bottomY, btnW, 16, (class_2561)class_2561.method_43470((String)"Reset"), b -> {
            this.click();
            this.resetAll();
        }, true));
        this.method_37063((class_364)new AutoEatConfigScreen.ShaderStyleButton(bottomX + (btnW + gap) * 2, bottomY, btnW, 16, (class_2561)class_2561.method_43470((String)"Save"), b -> {
            this.click();
            this.saveAll();
        }, true));
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        int headerH = 12 + 9 + 2 + 9 + 6;
        this.contentLeft = 12;
        this.contentRight = this.field_22789 - 12;
        this.contentTop = headerH + 6;
        this.contentBottom = bottomY - 6;
        this.toggles.clear();
        this.sliders.clear();
        this.toggles.add(this.tg(0, "offhand", "Offhand First", ConfigManager::isOffhandFirst, ConfigManager::setOffhandFirst, "Prioritize offhand food before main hand/hotbar."));
        this.toggles.add(this.tg(0, "detect", "Detect Mod Foods", ConfigManager::isDetectModFoods, ConfigManager::setDetectModFoods, "Include modded foods automatically."));
        this.toggles.add(this.tg(0, "best", "Always Use Best", ConfigManager::isPreferBestFood, ConfigManager::setPreferBestFood, "Always pick the highest-value food even when safe."));
        this.toggles.add(this.tg(0, "full", "Eat Until Full", ConfigManager::isEatUntilFull, ConfigManager::setEatUntilFull, "Keep eating until hunger is completely full."));
        this.toggles.add(this.tg(0, "toast", "Show Toggle Toast", ConfigManager::isShowToggleToast, ConfigManager::setShowToggleToast, "Show a short message when AutoEat is enabled/disabled."));
        this.toggles.add(this.tg(0, "smart", "Smart Panic Mode", ConfigManager::isSmartModeEnabled, ConfigManager::setSmartModeEnabled, "Use premium food when your health is below the panic limit."));
        this.toggles.add(this.tg(0, "autobad", "Auto-Block Bad Effects", ConfigManager::isAutoBlockNegativeEffects, ConfigManager::setAutoBlockNegativeEffects, "Automatically block foods with harmful status effects, including mod foods."));
        this.sliders.add(this.sl(0, "hunger", "Hunger Trigger", 10, 1, ConfigManager::getEatThresholdShanks, ConfigManager::setEatThresholdShanks, "Start auto-eating when hunger falls to this level."));
        this.toggles.add(this.tg(0, "pauseair", "Pause in Air", ConfigManager::isPauseInAir, ConfigManager::setPauseInAir, "Pause AutoEat while you are in the air (not on ground)."));
        this.toggles.add(this.tg(0, "pausehostile", "Pause Near Hostiles", ConfigManager::isPauseNearHostile, ConfigManager::setPauseNearHostile, "Pause AutoEat if a hostile mob is within 5 blocks and close in height."));
        this.sliders.add(this.sl(1, "panic", "Panic Health", 10, 4, ConfigManager::getEmergencyHearts, ConfigManager::setEmergencyHearts, "Switch to premium food at or below this health."));
        this.toggles.add(this.tg(1, "allowforce", "Allow Force Place", ConfigManager::isAllowForcePlaceWhileEating, ConfigManager::setAllowForcePlaceWhileEating, "Let you place a block while eating. AutoEat pauses right after."));
        this.sliders.add(this.sl(1, "fpsec", "On-Place Cooldown", 5, 2, ConfigManager::getForcePlaceCooldownSec, ConfigManager::setForcePlaceCooldownSec, "How long AutoEat waits after a forced place while eating."));
        this.toggles.add(this.tg(1, "pausehit", "Hit Pause", ConfigManager::isPauseOnHit, ConfigManager::setPauseOnHit, "Stop eating immediately if anything hits you, then start a cooldown."));
        this.sliders.add(this.sl(1, "hitsec", "On-Hit Cooldown", 10, 5, ConfigManager::getOnHitCooldownSec, ConfigManager::setOnHitCooldownSec, "How long AutoEat waits after getting hit."));
        this.toggles.add(this.tg(1, "pauseclick", "Click Pause", ConfigManager::isPauseOnClickEnabled, ConfigManager::setPauseOnClickEnabled, "Pause when you left or right click while auto-eating."));
        this.sliders.add(this.sl(1, "clicksec", "On-Click Cooldown", 10, 2, ConfigManager::getOnClickCooldownSec, ConfigManager::setOnClickCooldownSec, "How long AutoEat waits after a left/right click."));
        this.toggles.add(this.tg(1, "pausesprint", "Sprint Pause", ConfigManager::isPauseWhileSprinting, ConfigManager::setPauseWhileSprinting, "Pause AutoEat while you are sprinting."));
        this.sliders.add(this.sl(1, "sprintgrace", "Sprint Grace", 10, 3, ConfigManager::getSprintGraceSec, ConfigManager::setSprintGraceSec, "Keep AutoEat paused a bit after you stop sprinting."));
        this.toggles.add(this.tg(1, "pauseaim", "Aim Pause", ConfigManager::isPauseWhileAiming, ConfigManager::setPauseWhileAiming, "Pause AutoEat while you are aiming with bows, crossbows, shields, tridents, or spyglasses."));
        this.sliders.add(this.sl(1, "aimgrace", "Aim Grace", 10, 3, ConfigManager::getAimGraceSec, ConfigManager::setAimGraceSec, "Keep AutoEat paused a bit after you stop aiming."));
        for (ToggleCtl t2 : this.toggles) {
            t2.btn = new AutoEatConfigScreen.ShaderStyleButton(0, 0, 140, 16, t2.label(), b -> {
                t.value = !t.value;
                b.method_25355(t2.label());
                this.click();
            }, true);
        }
        int rowsL = (int)this.toggles.stream().filter(t -> t.col == 0).count() + (int)this.sliders.stream().filter(s -> s.col == 0).count();
        int rowsR = (int)this.toggles.stream().filter(t -> t.col == 1).count() + (int)this.sliders.stream().filter(s -> s.col == 1).count();
        this.contentHeight = Math.max(rowsL, rowsR) * 22 + 6;
        this.layout();
    }

    private ToggleCtl tg(int col, String id, String title, BooleanSupplier g, Consumer<Boolean> s, String tip) {
        return new ToggleCtl(new ToggleSpec(id, title, g, s, tip), col);
    }

    private SliderCtl sl(int col, String id, String title, int max, int def, IntSupplier g, IntConsumer set, String tip) {
        return new SliderCtl(new SliderSpec(id, title, max, def, g, set, tip), col);
    }

    public void method_25393() {
        if (this.statusTicks > 0) {
            --this.statusTicks;
        }
        if (this.hoverTicks > 0) {
            --this.hoverTicks;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        String hid;
        class_437.method_57737((class_332)ctx, (class_2960)MENU_BG, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_22789, (int)this.field_22790);
        int cx = this.field_22789 / 2;
        ctx.method_27534(this.field_22793, this.field_22785, cx, 12, -1);
        class_5250 class_52502 = class_2561.method_43470((String)"Pro Controls");
        Objects.requireNonNull(this.field_22793);
        ctx.method_27534(this.field_22793, (class_2561)class_52502, cx, 12 + 9 + 2, -4144960);
        this.layout();
        ctx.method_44379(this.contentLeft, this.contentTop, this.contentRight, this.contentBottom);
        for (ToggleCtl t : this.toggles) {
            if (!this.insideContent(t.btn.method_46426(), t.btn.method_46427(), t.btn.method_25368(), t.btn.method_25364())) continue;
            t.btn.method_48579(ctx, mouseX, mouseY, delta);
        }
        for (SliderCtl s : this.sliders) {
            this.drawSlider(ctx, s);
        }
        ctx.method_44380();
        super.method_25394(ctx, mouseX, mouseY, delta);
        if (this.statusTicks > 0 && !this.statusMsg.isEmpty()) {
            float f = 1.0f - (float)Math.pow(1.0f - (float)this.statusTicks / 70.0f, 3.0);
            int aBg = (int)(204.0f * f);
            int aTx = (int)(255.0f * f);
            int pad = 6;
            int w = this.field_22793.method_1727(this.statusMsg) + pad * 2;
            int h = 14;
            int x0 = this.field_22789 - w - 12;
            int y0 = 12;
            ctx.method_25294(x0, y0, x0 + w, y0 + h, aBg << 24);
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.statusMsg), x0 + w / 2, y0 + 3, aTx << 24 | 0xFFFFFF);
        }
        if (!(hid = this.hoverId(mouseX, mouseY)).equals(this.hoveredId)) {
            this.hoveredId = hid;
            this.hoverTicks = 0;
        }
        if (!this.hoveredId.isEmpty()) {
            ++this.hoverTicks;
            if (this.hoverTicks >= 8) {
                this.drawTooltip(ctx, mouseX, mouseY, this.tooltip(this.hoveredId));
            }
        }
    }

    private void layout() {
        int totalW = 292;
        int leftX = (this.contentLeft + this.contentRight - totalW) / 2;
        int rightX = leftX + 140 + 12;
        int yL = this.contentTop + 2 - (int)this.scrollY;
        int yR = this.contentTop + 2 - (int)this.scrollY;
        for (ToggleCtl t : this.toggles) {
            if (t.col != 0) continue;
            AutoEatAdvancedScreen.posBtn(t.btn, leftX, yL);
            yL += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 0) continue;
            AutoEatAdvancedScreen.posSl(s, leftX, yL);
            yL += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 1 || !s.spec.id.equals("panic")) continue;
            AutoEatAdvancedScreen.posSl(s, rightX, yR);
            yR += 22;
        }
        for (ToggleCtl t : this.toggles) {
            if (t.col != 1) continue;
            AutoEatAdvancedScreen.posBtn(t.btn, rightX, yR);
            yR += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 1 || s.spec.id.equals("panic")) continue;
            AutoEatAdvancedScreen.posSl(s, rightX, yR);
            yR += 22;
        }
        this.contentHeight = Math.max(yL, yR) + (int)this.scrollY - this.contentTop + 6;
    }

    private void drawSlider(class_332 ctx, SliderCtl s) {
        int x = s.x;
        int y = s.y;
        int w = s.w;
        int h = s.h;
        if (!this.insideContent(x, y, w, h)) {
            return;
        }
        ctx.method_25294(x, y, x + w, y + h, 0x22000000);
        AutoEatAdvancedScreen.drawOutline(ctx, x, y, w, h, -1);
        int pad = 2;
        int knobW = 4;
        int knobH = Math.max(6, h - 4);
        int kx = x + pad + (int)Math.round((double)s.value / (double)Math.max(1, s.spec.max) * (double)(w - knobW - pad * 2));
        int ky = y + pad;
        ctx.method_25294(kx, ky, kx + knobW, ky + knobH, -1052689);
        AutoEatAdvancedScreen.drawOutline(ctx, kx, ky, knobW, knobH, -1);
        String label = s.label();
        int tw = this.field_22793.method_1727(label);
        Objects.requireNonNull(this.field_22793);
        int ty = y + (h - 9) / 2 + 1;
        ctx.method_25303(this.field_22793, label, x + (w - tw) / 2, ty, -1);
    }

    public boolean method_25401(double mx, double my, double hx, double vy) {
        if (mx >= (double)this.contentLeft && mx <= (double)this.contentRight && my >= (double)this.contentTop && my <= (double)this.contentBottom) {
            int viewH = Math.max(0, this.contentBottom - this.contentTop);
            int maxScroll = Math.max(0, this.contentHeight - viewH);
            this.scrollY = Math.max(0.0, Math.min((double)maxScroll, this.scrollY - vy * 12.0));
            return true;
        }
        return super.method_25401(mx, my, hx, vy);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled)) {
            return true;
        }
        if (click.method_74245() != 0) {
            return false;
        }
        double mx = click.comp_4798();
        double my = click.comp_4799();
        if (!(mx >= (double)this.contentLeft && mx <= (double)this.contentRight && my >= (double)this.contentTop && my <= (double)this.contentBottom)) {
            return false;
        }
        for (ToggleCtl t : this.toggles) {
            if (!this.hit(t.btn, mx, my)) continue;
            t.btn.method_25348(click, doubled);
            return true;
        }
        for (SliderCtl s : this.sliders) {
            if (!this.inside(mx, my, s.x, s.y, s.w, s.h)) continue;
            s.dragging = true;
            s.value = AutoEatAdvancedScreen.slFromMouse(mx, s.x, s.w, s.spec.max);
            this.show(s.label());
            this.click();
            return true;
        }
        return false;
    }

    public boolean method_25403(class_11909 click, double dx, double dy) {
        if (super.method_25403(click, dx, dy)) {
            return true;
        }
        if (click.method_74245() != 0) {
            return false;
        }
        double mx = click.comp_4798();
        for (SliderCtl s : this.sliders) {
            if (!s.dragging) continue;
            s.value = AutoEatAdvancedScreen.slFromMouse(mx, s.x, s.w, s.spec.max);
            this.show(s.label());
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0) {
            for (SliderCtl s : this.sliders) {
                s.dragging = false;
            }
        }
        return super.method_25406(click);
    }

    public boolean method_25404(class_11908 input) {
        if (AutoEat.matchesOpenSettingsKey(input.comp_4795(), input.comp_4796(), input.comp_4797())) {
            class_310 mc = class_310.method_1551();
            if (mc != null) {
                mc.method_1507(null);
            }
            return true;
        }
        return super.method_25404(input);
    }

    private void resetAll() {
        for (ToggleCtl t : this.toggles) {
            t.value = true;
            t.btn.method_25355(t.label());
        }
        for (SliderCtl s : this.sliders) {
            s.value = s.spec.def;
        }
        this.show("Advanced reset");
    }

    private void saveAll() {
        for (ToggleCtl t : this.toggles) {
            t.spec.set.accept(t.value);
        }
        for (SliderCtl s : this.sliders) {
            s.spec.set.accept(s.value);
        }
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            class_437 class_4372;
            mc.method_1507(this.parent);
            if (this.parent != null) {
                this.parent.method_25423(mc, mc.method_22683().method_4486(), mc.method_22683().method_4502());
            }
            if ((class_4372 = this.parent) instanceof AutoEatConfigScreen) {
                AutoEatConfigScreen cfg = (AutoEatConfigScreen)class_4372;
                cfg.showTopRightStatus("Advanced saved");
            }
        }
    }

    private void closeParent() {
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            mc.method_1507(this.parent);
        }
    }

    private void drawTooltip(class_332 ctx, int mouseX, int mouseY, String desc) {
        if (desc == null || desc.isEmpty()) {
            return;
        }
        ctx.method_73199();
        ctx.method_71048();
        List wrapped = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)desc), Math.min(220, Math.max(160, this.field_22789 / 4)));
        int textW = 0;
        for (class_5481 ot : wrapped) {
            textW = Math.max(textW, this.field_22793.method_30880(ot));
        }
        Objects.requireNonNull(this.field_22793);
        int lineH = 9;
        int bodyH = wrapped.size() * lineH + Math.max(0, wrapped.size() - 1) * 2;
        int boxW = textW + 10;
        int boxH = 5 + bodyH + 5;
        int m = 10;
        int x = Math.min(Math.max(4, mouseX + m), this.field_22789 - 4 - boxW);
        int y = Math.min(Math.max(4, mouseY + m), this.field_22790 - 4 - boxH);
        int bg = -534895830;
        int border = -1;
        int textCol = -1;
        ctx.method_25294(x, y, x + boxW, y + boxH, bg);
        AutoEatAdvancedScreen.drawOutline(ctx, x, y, boxW, boxH, border);
        int dy = y + 5;
        for (class_5481 ot : wrapped) {
            ctx.method_51430(this.field_22793, ot, x + 5, dy, textCol, false);
            dy += lineH + 2;
        }
    }

    private String hoverId(int mx, int my) {
        for (ToggleCtl t : this.toggles) {
            if (!this.hit(t.btn, mx, my)) continue;
            return t.spec.id;
        }
        for (SliderCtl s : this.sliders) {
            if (!this.inside(mx, my, s.x, s.y, s.w, s.h)) continue;
            return s.spec.id;
        }
        return "";
    }

    private String tooltip(String id) {
        for (ToggleCtl t : this.toggles) {
            if (!t.spec.id.equals(id)) continue;
            return t.spec.tip;
        }
        for (SliderCtl s : this.sliders) {
            if (!s.spec.id.equals(id)) continue;
            return s.spec.tip;
        }
        return "";
    }

    private void show(String msg) {
        this.statusMsg = msg;
        this.statusTicks = 70;
    }

    private void click() {
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    private static void posBtn(AutoEatConfigScreen.ShaderStyleButton b, int x, int y) {
        b.method_46421(x);
        b.method_46419(y);
        b.method_25358(140);
        b.method_53533(16);
    }

    private static void posSl(SliderCtl s, int x, int y) {
        s.x = x;
        s.y = y;
        s.w = 140;
        s.h = 16;
    }

    private static int slFromMouse(double mx, int x, int w, int max) {
        int pad = 2;
        int knobW = 4;
        double tx = (double)(x + pad) + (double)knobW / 2.0;
        double tw = (double)(w - knobW) - (double)pad * 2.0;
        double t = (mx - tx) / Math.max(1.0, tw);
        return (int)Math.round(Math.max(0.0, Math.min(1.0, t)) * (double)max);
    }

    private static int clamp0(int max, int v) {
        return Math.max(0, Math.min(max, v));
    }

    private boolean hit(class_4185 b, double mx, double my) {
        return this.inside(mx, my, b.method_46426(), b.method_46427(), b.method_25368(), b.method_25364()) && this.insideContent(b.method_46426(), b.method_46427(), b.method_25368(), b.method_25364());
    }

    private boolean inside(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private boolean insideContent(int x, int y, int w, int h) {
        int ix1 = Math.max(x, this.contentLeft);
        int iy1 = Math.max(y, this.contentTop);
        int ix2 = Math.min(x + w, this.contentRight);
        int iy2 = Math.min(y + h, this.contentBottom);
        return ix2 > ix1 && iy2 > iy1;
    }

    private static void drawOutline(class_332 ctx, int x, int y, int w, int h, int color) {
        int x2 = x + w;
        int y2 = y + h;
        ctx.method_25294(x, y, x2, y + 1, color);
        ctx.method_25294(x, y2 - 1, x2, y2, color);
        ctx.method_25294(x, y, x + 1, y2, color);
        ctx.method_25294(x2 - 1, y, x2, y2, color);
    }

    private static class ToggleCtl {
        final ToggleSpec spec;
        final int col;
        boolean value;
        AutoEatConfigScreen.ShaderStyleButton btn;

        ToggleCtl(ToggleSpec s, int col) {
            this.spec = s;
            this.col = col;
            this.value = s.get.getAsBoolean();
        }

        class_2561 label() {
            return class_2561.method_43470((String)(this.spec.title() + ": " + (this.value ? "ON" : "OFF")));
        }
    }

    private static class SliderCtl {
        final SliderSpec spec;
        final int col;
        int x;
        int y;
        int w;
        int h;
        int value;
        boolean dragging;

        SliderCtl(SliderSpec s, int col) {
            this.spec = s;
            this.col = col;
            this.value = AutoEatAdvancedScreen.clamp0(s.max, s.get.getAsInt());
        }

        String label() {
            return this.spec.title() + (this.spec.id.endsWith("sec") ? ": " + this.value + "s" : ": " + this.value);
        }
    }

    private record ToggleSpec(String id, String title, BooleanSupplier get, Consumer<Boolean> set, String tip) {
    }

    private record SliderSpec(String id, String title, int max, int def, IntSupplier get, IntConsumer set, String tip) {
    }
}

