/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4174;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.zynwro.autoeat.AutoEat;
import net.zynwro.autoeat.AutoEatAdvancedScreen;
import net.zynwro.autoeat.ConfigManager;

public class AutoEatConfigScreen
extends class_437 {
    private static final int PADDING = 12;
    private static final int ROW_H = 18;
    private static final String SUBTITLE = "Food List \u2014 \"Yes\" means Block";
    private static final int SEARCH_NUDGE_X = 2;
    private static final int SEARCH_NUDGE_Y = 1;
    private static final int SEARCH_TEXT_NUDGE_DOWN = 4;
    private static final String SEARCH_ICON = "\ud83d\udd0d";
    private static final int SEARCH_ICON_LEFT_PAD = 6;
    private static final int SEARCH_ICON_GAP = 4;
    private static final int FILTER_SHIFT_LEFT = 2;
    private static final int FILTER_SPACING = 4;
    private static final int FILTER_SIDE_PAD = 6;
    private static final int FILTER_GROUP_NUDGE_X = 4;
    private static final int RIGHT_TEXT_SAFE_PAD = 1;
    private static final int CARET_HARD_STOP_MARGIN = 0;
    private static final int FOOTER_BTN_H = 16;
    private static final class_2960 MENU_BG = class_2960.method_60655((String)"minecraft", (String)"textures/gui/menu_background.png");
    private static final int COLOR_DANGER = -42438;
    private static final int COLOR_SEARCH_TEXT = -1052689;
    private ShaderStyleButton btnAll;
    private ShaderStyleButton btnDanger;
    private ShaderStyleButton btnSuper;
    private ShaderStyleButton btnNormal;
    private ShaderStyleButton btnMassToggle;
    private ShaderStyleButton btnDonate;
    private ShaderStyleButton btnDonateClose;
    private ShaderStyleButton btnHelp;
    private boolean helpOpen = false;
    private boolean prevSearchFocused = false;
    private boolean prevSearchFocusedReset = false;
    private int helpX;
    private int helpY;
    private int helpW;
    private int helpH;
    private ShaderStyleButton btnHelpClose;
    private double helpScrollY = 0.0;
    private int helpTextH = 0;
    private List<class_5481> helpLines = Collections.emptyList();
    private boolean helpDraggingScrollbar = false;
    private int helpDragBarOffsetY = 0;
    private class_342 searchField;
    private Filter filter = Filter.ALL;
    private double scrollY = 0.0;
    private int contentHeight;
    private boolean draggingScrollbar = false;
    private int dragBarOffsetY = 0;
    private int filterFadeTicks = 0;
    private static final int FILTER_FADE_MAX = 12;
    private int pressedFlashTicks = 0;
    private static final int PRESSED_FLASH_MAX = 8;
    private Filter lastPressedFilter = Filter.ALL;
    private String statusMsg = "";
    private int statusTicks = 0;
    private static final int TOAST_MAX_TICKS = 70;
    private boolean confirmResetOpen = false;
    private int modalX;
    private int modalY;
    private int modalW;
    private int modalH;
    private ShaderStyleButton btnConfirmYes;
    private ShaderStyleButton btnConfirmNo;
    private final List<Entry> allEntries = new ArrayList<Entry>();
    private List<Entry> visibleEntries = new ArrayList<Entry>();
    private boolean showDonate = true;
    private static final Set<class_1792> DANGER = Set.of(class_1802.field_8511, class_1802.field_8680, class_1802.field_8635, class_1802.field_8323, class_1802.field_8766, class_1802.field_8726, class_1802.field_8233);
    private static final Set<class_1792> SUPER = Set.of(class_1802.field_8463, class_1802.field_8367, class_1802.field_8071, class_1802.field_8308);
    private int searchInnerPadLeft;
    private int searchTextYOffset;

    public AutoEatConfigScreen() {
        super((class_2561)class_2561.method_43470((String)"AutoEat Settings"));
    }

    private boolean uiLocked() {
        return this.confirmResetOpen || this.helpOpen;
    }

    protected void method_25426() {
        int spacing = 4;
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        int rowY = 12 + 9 + 2 + 9 + 6;
        int rightEdge = this.field_22789 - 12;
        int searchX = 12;
        int computed = rightEdge - searchX - 300;
        int searchW = Math.max(60, computed);
        int iconW = this.field_22793.method_1727(SEARCH_ICON);
        this.searchInnerPadLeft = 6 + iconW + 4;
        this.searchTextYOffset = 4;
        this.searchField = new class_342(this.field_22793, searchX + 2 + this.searchInnerPadLeft, rowY + 1 + this.searchTextYOffset, Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0), 16, (class_2561)class_2561.method_43470((String)"Search\u2026"));
        this.searchField.method_47404((class_2561)class_2561.method_43473());
        this.searchField.method_1858(false);
        this.searchField.method_1868(-1052689);
        this.searchField.method_1860(-1052689);
        this.searchField.method_1880(Integer.MAX_VALUE);
        this.searchField.method_1863(s -> this.refreshVisible());
        this.method_37063((class_364)this.searchField);
        int lblAll = this.field_22793.method_1727("All");
        int lblDanger = this.field_22793.method_1727("Danger");
        int lblSuper = this.field_22793.method_1727("Super");
        int lblNormal = this.field_22793.method_1727("Normal");
        int lblBlock = this.field_22793.method_1727("Block All");
        int lblAllow = this.field_22793.method_1727("Allow All");
        int wBtn = Math.max(Math.max(Math.max(lblAll, lblDanger), Math.max(lblSuper, lblNormal)), Math.max(lblBlock, lblAllow)) + 12;
        int groupW = wBtn * 5 + 16;
        int minSearchW = 60;
        int maxSearchW = Math.max(minSearchW, rightEdge - searchX - groupW - 4 - 2);
        if (searchW > maxSearchW) {
            searchW = maxSearchW;
            this.searchField.method_25358(Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0));
            this.searchField.method_46421(searchX + 2 + this.searchInnerPadLeft);
        }
        int xStart = searchX + searchW + 4 - 2 + 6 + 4;
        int step = wBtn + 4;
        int filterY = rowY + 1;
        this.btnAll = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xStart, filterY, wBtn, 16, (class_2561)class_2561.method_43470((String)"All"), b -> this.onFilterPressed(Filter.ALL), true));
        this.btnDanger = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xStart + step, filterY, wBtn, 16, (class_2561)class_2561.method_43470((String)"Danger"), b -> this.onFilterPressed(Filter.DANGER), true));
        this.btnSuper = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xStart + step * 2, filterY, wBtn, 16, (class_2561)class_2561.method_43470((String)"Super"), b -> this.onFilterPressed(Filter.SUPER), true));
        this.btnNormal = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xStart + step * 3, filterY, wBtn, 16, (class_2561)class_2561.method_43470((String)"Normal"), b -> this.onFilterPressed(Filter.NORMAL), true));
        this.btnMassToggle = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xStart + step * 4, filterY, wBtn, 16, (class_2561)class_2561.method_43470((String)"Block All"), b -> this.toggleMass(), true));
        int desiredGap = 6;
        int newSearchW = Math.max(minSearchW, this.btnAll.method_46426() - desiredGap - searchX);
        if (newSearchW != searchW) {
            searchW = newSearchW;
            this.searchField.method_25358(Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0));
            this.searchField.method_46421(searchX + 2 + this.searchInnerPadLeft);
        }
        int fullW = this.field_22789;
        int bottomY = this.field_22790 - 12 - 16;
        int fullWButtons = 66;
        int bottomGap = 6;
        int footerW = fullWButtons * 3 + bottomGap * 2;
        int bottomX = Math.floorDiv(fullW - footerW, 2);
        this.method_37063((class_364)new ShaderStyleButton(bottomX, bottomY, fullWButtons, 16, (class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            this.onCancel();
            this.playClickSound();
        }, true));
        this.method_37063((class_364)new ShaderStyleButton(bottomX + fullWButtons + bottomGap, bottomY, fullWButtons, 16, (class_2561)class_2561.method_43470((String)"Reset"), b -> this.openResetConfirm(), true));
        this.method_37063((class_364)new ShaderStyleButton(bottomX + (fullWButtons + bottomGap) * 2, bottomY, fullWButtons, 16, (class_2561)class_2561.method_43470((String)"Done"), b -> this.onDone(), true));
        int helpXRight = this.field_22789 - 12 - 16;
        this.btnHelp = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(helpXRight, bottomY, 16, 16, (class_2561)class_2561.method_43470((String)"\ud83d\udcd8"), b -> this.openHelp(), true));
        int advW = 68;
        int advX = this.btnHelp.method_46426() - 1 - advW;
        this.method_37063((class_364)new ShaderStyleButton(advX, bottomY, advW, 16, (class_2561)class_2561.method_43470((String)"Advanced"), b -> this.openAdvanced(), true));
        if (this.showDonate) {
            int donateW = 64;
            int xDonate = 12;
            this.btnDonate = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xDonate, bottomY, donateW, 16, (class_2561)class_2561.method_43470((String)"Donate"), b -> this.openDonate(), 0x22000000, 0x33000000, 0x55000000, -1711276033, -570425345, false, false));
            this.btnDonateClose = (ShaderStyleButton)this.method_37063((class_364)new ShaderStyleButton(xDonate + donateW + 1, bottomY, 16, 16, (class_2561)class_2561.method_43470((String)"X"), b -> this.closeDonate(), 0x22000000, 0x33000000, 0x55000000, -1711276033, -570425345, false, false));
        }
        this.buildEntriesFromRegistryAndConfig();
        this.setFilter(Filter.ALL);
    }

    private void openDonate() {
        try {
            class_156.method_668().method_673(new URI("https://linktr.ee/zynwrodonate"));
            this.showTopRightStatus("Opening browser\u2026");
        }
        catch (Exception ignored) {
            this.showTopRightStatus("Failed to open browser");
        }
    }

    private void closeDonate() {
        this.showDonate = false;
        if (this.btnDonate != null) {
            this.btnDonate.field_22764 = false;
        }
        if (this.btnDonateClose != null) {
            this.btnDonateClose.field_22764 = false;
        }
    }

    private void openAdvanced() {
        class_310 mc = class_310.method_1551();
        if (this.searchField != null) {
            this.searchField.method_25365(false);
        }
        if (mc != null) {
            mc.method_1507((class_437)new AutoEatAdvancedScreen(this));
        }
    }

    private void openHelp() {
        this.helpOpen = true;
        boolean bl = this.prevSearchFocused = this.searchField != null && this.searchField.method_25370();
        if (this.searchField != null) {
            this.searchField.method_25365(false);
        }
        int innerPad = 14;
        int maxW = Math.max(320, this.field_22789 - 24);
        int maxH = Math.max(180, this.field_22790 - 24);
        this.helpW = Math.min(maxW, Math.max(320, (int)((double)this.field_22789 * 0.78)));
        this.helpH = Math.min(maxH, Math.max(200, (int)((double)this.field_22790 * 0.72)));
        String body = AutoEatConfigScreen.readGuideText();
        int scrollbarReserve = 10;
        int wrapMax = Math.max(220, this.helpW - innerPad * 2 - scrollbarReserve);
        ArrayList<class_5481> lines = new ArrayList<class_5481>();
        for (String line : body.split("\n", -1)) {
            if (line.isEmpty()) {
                lines.add(class_5481.field_26385);
                continue;
            }
            lines.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43470((String)line), wrapMax));
        }
        this.helpLines = lines;
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        this.helpX = cx - this.helpW / 2;
        this.helpY = cy - this.helpH / 2;
        int btnW = Math.min(120, Math.max(90, this.helpW / 4));
        int yBtn = this.helpY + this.helpH - innerPad - 16;
        this.btnHelpClose = new ShaderStyleButton(this.helpX + (this.helpW - btnW) / 2, yBtn, btnW, 16, (class_2561)class_2561.method_43470((String)"Close"), b -> this.closeHelp(), -2143270313, -1605675418, -1070976452, -1, -1, true, true);
        Objects.requireNonNull(this.field_22793);
        int lineH = 9 + 4;
        this.helpTextH = this.helpLines.size() * lineH;
        this.helpScrollY = 0.0;
    }

    private void closeHelp() {
        this.helpOpen = false;
        if (this.searchField != null) {
            if (this.prevSearchFocused) {
                this.method_25395((class_364)this.searchField);
                this.searchField.method_25365(true);
            } else {
                this.searchField.method_25365(false);
            }
        }
        this.btnHelpClose = null;
        this.helpLines = Collections.emptyList();
        this.helpScrollY = 0.0;
        this.helpTextH = 0;
        this.helpDraggingScrollbar = false;
        this.helpDragBarOffsetY = 0;
    }

    public void showTopRightStatus(String msg) {
        this.statusMsg = msg;
        this.statusTicks = 70;
    }

    private void toggleMass() {
        boolean block = !this.areAllBlacklisted(this.visibleEntries);
        int affected = 0;
        for (Entry e : this.visibleEntries) {
            if (e.blacklisted == block) continue;
            e.blacklisted = block;
            ++affected;
        }
        this.btnMassToggle.method_25355((class_2561)class_2561.method_43470((String)(block ? "Allow All" : "Block All")));
        this.showTopRightStatus((block ? "Blocked " : "Allowed ") + affected + " items");
        this.playClickSound();
    }

    private void onFilterPressed(Filter target) {
        if (this.filter == target) {
            this.setFilter(Filter.ALL);
        } else {
            this.lastPressedFilter = target;
            this.setFilter(target);
            this.pressedFlashTicks = 8;
        }
        this.playClickSound();
    }

    private void setFilter(Filter f) {
        this.filter = f;
        this.refreshVisible();
        this.filterFadeTicks = 12;
    }

    private boolean isDrink(class_1792 it) {
        return it == class_1802.field_20417;
    }

    private void buildEntriesFromRegistryAndConfig() {
        this.allEntries.clear();
        for (class_1792 it : class_7923.field_41178) {
            class_4174 fc = (class_4174)it.method_57347().method_58694(class_9334.field_50075);
            if (fc == null || this.isDrink(it)) continue;
            String key = it.method_7876();
            boolean blacklisted = ConfigManager.isBlacklisted(key);
            class_1799 stack = new class_1799((class_1935)it);
            String display = class_2561.method_43471((String)it.method_7876()).getString();
            class_2960 id = class_7923.field_41178.method_10221((Object)it);
            this.allEntries.add(new Entry(stack, key, blacklisted, display, id.method_12836(), id.method_12832()));
        }
        block1: for (Map.Entry<String, Boolean> e : ConfigManager.blacklist.entrySet()) {
            String key = e.getKey();
            for (class_1792 it : class_7923.field_41178) {
                if (!key.equals(it.method_7876())) continue;
                class_4174 fc = (class_4174)it.method_57347().method_58694(class_9334.field_50075);
                if (fc == null || this.isDrink(it) || !this.allEntries.stream().noneMatch(en -> en.key.equals(key))) continue block1;
                class_1799 stack = new class_1799((class_1935)it);
                String display = class_2561.method_43471((String)it.method_7876()).getString();
                class_2960 id = class_7923.field_41178.method_10221((Object)it);
                this.allEntries.add(new Entry(stack, key, e.getValue(), display, id.method_12836(), id.method_12832()));
                continue block1;
            }
        }
        this.allEntries.sort((a, b) -> {
            int cb;
            int ca = this.categoryOrder((Entry)a);
            if (ca != (cb = this.categoryOrder((Entry)b))) {
                return Integer.compare(ca, cb);
            }
            return a.displayName.compareToIgnoreCase(b.displayName);
        });
        this.refreshVisible();
    }

    private int categoryOrder(Entry e) {
        class_1792 i;
        class_1792 class_17922 = i = e.stack.method_7960() ? null : e.stack.method_7909();
        if (i != null) {
            if (DANGER.contains(i)) {
                return 0;
            }
            if (SUPER.contains(i)) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    private boolean passFilter(Entry e) {
        if (this.filter == Filter.ALL) {
            return true;
        }
        class_1792 i = e.stack.method_7960() ? null : e.stack.method_7909();
        return switch (this.filter.ordinal()) {
            case 1 -> {
                if (i != null && DANGER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (i != null && SUPER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (i != null && !DANGER.contains(i) && !SUPER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private void refreshVisible() {
        String q = this.searchField != null ? this.searchField.method_1882().toLowerCase(Locale.ROOT) : "";
        this.visibleEntries = this.allEntries.stream().filter(this::passFilter).filter(e -> q.isEmpty() || this.matchesQuery((Entry)e, q)).collect(Collectors.toList());
        int rows = (this.visibleEntries.size() + 1) / 2;
        this.contentHeight = rows * 18;
        this.clampScroll();
        if (this.btnMassToggle != null) {
            this.btnMassToggle.method_25355((class_2561)class_2561.method_43470((String)(this.areAllBlacklisted(this.visibleEntries) ? "Allow All" : "Block All")));
        }
    }

    private static boolean entryMissing(Entry e, String term) {
        return !e.displayLower.contains(term) && !e.keyLower.contains(term) && !e.namespace.contains(term) && !e.idPath.contains(term);
    }

    private boolean matchesQuery(Entry e, String q) {
        if (q.isEmpty()) {
            return true;
        }
        block24: for (String raw : q.split("\\s+")) {
            if (raw.isEmpty()) continue;
            String t = raw.toLowerCase(Locale.ROOT);
            int i = t.indexOf(58);
            if (i > 0) {
                String key = t.substring(0, i);
                String val = t.substring(i + 1);
                switch (key) {
                    case "is": {
                        switch (val) {
                            case "blocked": 
                            case "block": 
                            case "b": {
                                if (e.blacklisted) continue block24;
                                return false;
                            }
                            case "allowed": 
                            case "allow": 
                            case "a": {
                                if (!e.blacklisted) continue block24;
                                return false;
                            }
                            default: {
                                if (!AutoEatConfigScreen.entryMissing(e, t)) continue block24;
                                return false;
                            }
                        }
                    }
                    case "mod": {
                        if (!val.isEmpty() && e.namespace.equals(val)) continue block24;
                        return false;
                    }
                    case "id": {
                        if (!val.isEmpty() && e.idPath.contains(val)) continue block24;
                        return false;
                    }
                    case "key": {
                        if (!val.isEmpty() && e.keyLower.contains(val)) continue block24;
                        return false;
                    }
                    default: {
                        if (!AutoEatConfigScreen.entryMissing(e, t)) continue block24;
                        return false;
                    }
                }
            }
            if (!AutoEatConfigScreen.entryMissing(e, t)) continue;
            return false;
        }
        return true;
    }

    private boolean areAllBlacklisted(List<Entry> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (Entry e : list) {
            if (e.blacklisted) continue;
            return false;
        }
        return true;
    }

    public void method_25393() {
        if (this.confirmResetOpen || this.helpOpen) {
            return;
        }
        if (this.statusTicks > 0) {
            --this.statusTicks;
        }
        if (this.filterFadeTicks > 0) {
            --this.filterFadeTicks;
        }
        if (this.pressedFlashTicks > 0) {
            --this.pressedFlashTicks;
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        class_437.method_57737((class_332)ctx, (class_2960)MENU_BG, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_22789, (int)this.field_22790);
        boolean prevVis = false;
        if (this.searchField != null) {
            prevVis = this.searchField.field_22764;
            this.searchField.field_22764 = false;
        }
        int mx = this.uiLocked() ? Integer.MIN_VALUE : mouseX;
        int my = this.uiLocked() ? Integer.MIN_VALUE : mouseY;
        super.method_25394(ctx, mx, my, delta);
        this.drawFilterActiveDark(ctx);
        this.drawFilterPressedFlash(ctx);
        this.drawFilterFadeHighlight(ctx);
        int[] b = this.getListBounds();
        ctx.method_44379(b[0], b[1], b[2], b[3]);
        this.drawEntries(ctx, b[0], b[1], b[2], b[3], mx, my);
        ctx.method_44380();
        this.drawScrollbar(ctx, b[1], b[2], b[3]);
        if (this.visibleEntries.isEmpty()) {
            String l1 = "No matching foods found.";
            String l2 = "Using food mods? Enable \"Detect mod food\" in Advanced Settings.";
            int midX = (b[0] + b[2]) / 2;
            int n = (b[1] + b[3]) / 2;
            Objects.requireNonNull(this.field_22793);
            int midY = n - 9;
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)l1), midX, midY, -1);
            class_5250 class_52502 = class_2561.method_43470((String)l2);
            Objects.requireNonNull(this.field_22793);
            ctx.method_27534(this.field_22793, (class_2561)class_52502, midX, midY + 9 + 4, -5592406);
        }
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 12, -1);
        Objects.requireNonNull(this.field_22793);
        int subtitleY = 12 + 9 + 2;
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)SUBTITLE), this.field_22789 / 2, subtitleY, -4144960);
        if (this.searchField != null) {
            this.searchField.field_22764 = prevVis;
            this.renderSearchBar(ctx, mx, my, delta);
        }
        if (this.statusTicks > 0 && this.statusMsg != null && !this.statusMsg.isEmpty()) {
            float t = (float)this.statusTicks / 70.0f;
            float ease = 1.0f - (float)Math.pow(1.0f - t, 3.0);
            int alphaBg = (int)(204.0f * ease);
            int alphaText = (int)(255.0f * ease);
            int pad = 6;
            int textW = this.field_22793.method_1727(this.statusMsg);
            int w = textW + pad * 2;
            int h = 14;
            int x0 = this.field_22789 - w - 12;
            int y0 = 12;
            int bg = alphaBg << 24;
            ctx.method_25294(x0, y0, x0 + w, y0 + h, bg);
            int col = alphaText << 24 | 0xFFFFFF;
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.statusMsg), x0 + w / 2, y0 + 3, col);
        }
        if (this.confirmResetOpen) {
            this.renderResetModal(ctx, mouseX, mouseY, delta);
        }
        if (this.helpOpen) {
            this.renderHelpModal(ctx, mouseX, mouseY, delta);
        }
    }

    private void renderSearchBar(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.searchField == null) {
            return;
        }
        int x = this.searchField.method_46426() - this.searchInnerPadLeft;
        int y = this.searchField.method_46427() - 4;
        int w = this.searchField.method_25368() + this.searchInnerPadLeft + 2 + 1 + 0;
        int h = this.searchField.method_25364();
        int bg = -2144191674;
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, bg);
        AutoEatConfigScreen.drawBorderInside(ctx, x, y, w, h, -1);
        Objects.requireNonNull(this.field_22793);
        int offsetY = (h - 9) / 2 + 2;
        int iconX = x + 6;
        int iconY = y + offsetY - 1;
        ctx.method_51433(this.field_22793, SEARCH_ICON, iconX, iconY, -1325400065, false);
        this.clipToWidgetRightSlack(ctx, this.searchField);
        this.searchField.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_44380();
        if (this.searchField.method_1882().isEmpty() && !this.searchField.method_25370()) {
            int phX = this.searchField.method_46426();
            Objects.requireNonNull(this.field_22793);
            int phY = y + (h - 9) / 2 + 1;
            ctx.method_25303(this.field_22793, "Search\u2026", phX, phY, -1052689);
        }
    }

    private void drawFilterActiveDark(class_332 ctx) {
        ShaderStyleButton targetBtn;
        switch (this.filter.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case 1: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case 2: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case 3: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        int x = targetBtn.method_46426();
        int y = targetBtn.method_46427();
        int w = targetBtn.method_25368();
        int h = targetBtn.method_25364();
        ctx.method_25294(x + 2, y + 2, x + w - 2, y + h - 2, 0x77000000);
    }

    private void drawFilterPressedFlash(class_332 ctx) {
        ShaderStyleButton targetBtn;
        if (this.pressedFlashTicks <= 0) {
            return;
        }
        switch (this.lastPressedFilter.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case 1: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case 2: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case 3: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        float t = (float)this.pressedFlashTicks / 8.0f;
        int alpha = (int)(102.0f * t);
        int rgb = switch (this.lastPressedFilter.ordinal()) {
            case 1 -> 16734778;
            case 2 -> 3842559;
            case 3 -> 5163391;
            default -> 0xAAAAAA;
        };
        int color = alpha << 24 | rgb;
        int x = targetBtn.method_46426();
        int y = targetBtn.method_46427();
        int w = targetBtn.method_25368();
        int h = targetBtn.method_25364();
        ctx.method_25294(x + 2, y + 2, x + w - 2, y + h - 2, color);
    }

    private void drawFilterFadeHighlight(class_332 ctx) {
        ShaderStyleButton targetBtn;
        if (this.filterFadeTicks <= 0) {
            return;
        }
        switch (this.filter.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case 1: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case 2: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case 3: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        float t = (float)this.filterFadeTicks / 12.0f;
        int alpha = (int)(85.0f * t);
        int color = alpha << 24 | 0xFFFFFF;
        int x = targetBtn.method_46426();
        int y = targetBtn.method_46427();
        int w = targetBtn.method_25368();
        int h = targetBtn.method_25364();
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + h - 1, color);
    }

    private void renderHelpModal(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, -1342177280);
        int innerPad = 14;
        ctx.method_25294(this.helpX + 3, this.helpY + 4, this.helpX + this.helpW + 3, this.helpY + this.helpH + 4, 0x22000000);
        ctx.method_25294(this.helpX, this.helpY, this.helpX + this.helpW, this.helpY + this.helpH, -300014806);
        AutoEatConfigScreen.drawBorderInside(ctx, this.helpX, this.helpY, this.helpW, this.helpH, -1);
        Objects.requireNonNull(this.field_22793);
        int titleBarH = 9 + 10;
        ctx.method_25294(this.helpX + 1, this.helpY + 1, this.helpX + this.helpW - 1, this.helpY + titleBarH, 858666818);
        ctx.method_25294(this.helpX + 1, this.helpY + titleBarH, this.helpX + this.helpW - 1, this.helpY + titleBarH + 1, 0x44FFFFFF);
        String title = "\ud83d\udcd8 AutoEat Guide";
        int titleW = this.field_22793.method_1727(title);
        int titleX = this.helpX + (this.helpW - titleW) / 2;
        Objects.requireNonNull(this.field_22793);
        int yTop = this.helpY + (titleBarH - 9) / 2 + 1;
        ctx.method_25303(this.field_22793, title, titleX, yTop, -1);
        int vpX1 = this.helpX + innerPad;
        int vpY1 = this.helpY + titleBarH + 8;
        int vpX2 = this.helpX + this.helpW - innerPad;
        int vpY2 = this.btnHelpClose != null ? this.btnHelpClose.method_46427() - 10 : this.helpY + this.helpH - innerPad - 20;
        ctx.method_25294(vpX1 - 1, vpY1 - 1, vpX2 + 1, vpY2 + 1, 0x22000000);
        AutoEatConfigScreen.drawBorderInside(ctx, vpX1 - 1, vpY1 - 1, vpX2 - vpX1 + 2, vpY2 - vpY1 + 2, 0x55FFFFFF);
        ctx.method_44379(vpX1, vpY1, vpX2, vpY2);
        Objects.requireNonNull(this.field_22793);
        int lineH = 9 + 4;
        int y = vpY1 - (int)this.helpScrollY;
        for (class_5481 ot : this.helpLines) {
            ctx.method_51430(this.field_22793, ot, vpX1, y, -520093697, false);
            y += lineH;
        }
        ctx.method_44380();
        if (this.btnHelpClose != null) {
            this.btnHelpClose.method_48579(ctx, mouseX, mouseY, delta);
        }
        int vpH = Math.max(0, vpY2 - vpY1);
        int maxScroll = Math.max(0, this.helpTextH - vpH);
        if (this.helpScrollY < 0.0) {
            this.helpScrollY = 0.0;
        }
        if (this.helpScrollY > (double)maxScroll) {
            this.helpScrollY = maxScroll;
        }
        int trackX = vpX2 - 6;
        ctx.method_25294(trackX, vpY1, trackX + 3, vpY2, 0x33000000);
        if (this.helpTextH > vpH) {
            float pct = (float)(this.helpScrollY / (double)(this.helpTextH - vpH));
            int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
            int barY = vpY1 + (int)((float)(vpH - barH) * pct);
            ctx.method_25294(trackX, barY, trackX + 3, barY + barH, 0x66FFFFFF);
        }
    }

    private void openResetConfirm() {
        this.confirmResetOpen = true;
        boolean bl = this.prevSearchFocusedReset = this.searchField != null && this.searchField.method_25370();
        if (this.searchField != null) {
            this.searchField.method_25365(false);
        }
        int maxW = Math.min(300, this.field_22789 - 24);
        int innerPad = 14;
        String title = "Reset to defaults?";
        String msg = "Restore defaults. Dangerous items will be blocked.";
        List wrapped = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)msg), Math.max(220, maxW - innerPad * 4));
        int longest = Math.max(this.field_22793.method_1727(title), wrapped.stream().mapToInt(arg_0 -> ((class_327)this.field_22793).method_30880(arg_0)).max().orElse(0));
        this.modalW = Math.max(260, Math.min(maxW, longest + innerPad * 3));
        Objects.requireNonNull(this.field_22793);
        int titleH = 9;
        Objects.requireNonNull(this.field_22793);
        int lineH = 9 + 3;
        int linesH = Math.max(lineH, wrapped.size() * lineH);
        int buttonsBlock = 26;
        this.modalH = innerPad + titleH + 8 + linesH + 10 + buttonsBlock + innerPad;
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        this.modalX = cx - this.modalW / 2;
        this.modalY = cy - this.modalH / 2;
        int btnW = 110;
        int gap = 12;
        int yBtn = this.modalY + this.modalH - innerPad - 16;
        this.btnConfirmYes = new ShaderStyleButton(cx - btnW - gap / 2, yBtn, btnW, 16, (class_2561)class_2561.method_43470((String)"Reset"), b -> {
            this.doReset();
            this.closeResetConfirm();
            this.playClickSound();
        }, -864408018, -527812809, -262394322, -1, -1, true, true);
        this.btnConfirmNo = new ShaderStyleButton(cx + gap / 2, yBtn, btnW, 16, (class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            this.closeResetConfirm();
            this.playClickSound();
        }, -2143270313, -1605675418, -1070976452, -1, -1, true, true);
    }

    private void closeResetConfirm() {
        this.confirmResetOpen = false;
        if (this.searchField != null) {
            if (this.prevSearchFocusedReset) {
                this.method_25395((class_364)this.searchField);
                this.searchField.method_25365(true);
            } else {
                this.searchField.method_25365(false);
            }
        }
        this.btnConfirmYes = null;
        this.btnConfirmNo = null;
    }

    private void doReset() {
        for (Entry e : this.allEntries) {
            class_1792 it = e.stack.method_7960() ? null : e.stack.method_7909();
            e.blacklisted = it != null && DANGER.contains(it);
        }
        this.refreshVisible();
        this.showTopRightStatus("Defaults restored");
    }

    private void renderResetModal(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, -1342177280);
        ctx.method_25294(this.modalX + 2, this.modalY + 3, this.modalX + this.modalW + 2, this.modalY + this.modalH + 3, 0x33000000);
        ctx.method_25294(this.modalX, this.modalY, this.modalX + this.modalW, this.modalY + this.modalH, -300014806);
        AutoEatConfigScreen.drawBorderInside(ctx, this.modalX, this.modalY, this.modalW, this.modalH, -1);
        String title = "Reset to defaults?";
        int titleW = this.field_22793.method_1727(title);
        int innerPad = 16;
        int cx = this.modalX + this.modalW / 2;
        int y = this.modalY + innerPad;
        ctx.method_25303(this.field_22793, title, cx - titleW / 2, y, -1);
        String msg = "Restore defaults. Dangerous items will be blocked.";
        List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)msg), this.modalW - innerPad * 2);
        Objects.requireNonNull(this.field_22793);
        y += 9 + 8;
        for (class_5481 ot : lines) {
            int lw = this.field_22793.method_30880(ot);
            ctx.method_35720(this.field_22793, ot, cx - lw / 2, y, -520093697);
            Objects.requireNonNull(this.field_22793);
            y += 9 + 3;
        }
        if (this.btnConfirmYes != null) {
            this.btnConfirmYes.method_48579(ctx, mouseX, mouseY, delta);
        }
        if (this.btnConfirmNo != null) {
            this.btnConfirmNo.method_48579(ctx, mouseX, mouseY, delta);
        }
    }

    public boolean method_25401(double mx, double my, double hx, double vy) {
        if (this.helpOpen) {
            int vpY2;
            int innerPad = 14;
            Objects.requireNonNull(this.field_22793);
            int titleBarH = 9 + 10;
            int vpX1 = this.helpX + innerPad;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpX2 = this.helpX + this.helpW - innerPad;
            int n = vpY2 = this.btnHelpClose != null ? this.btnHelpClose.method_46427() - 10 : this.helpY + this.helpH - innerPad - 20;
            if (mx >= (double)vpX1 && mx <= (double)vpX2 && my >= (double)vpY1 && my <= (double)vpY2) {
                int vpH = Math.max(0, vpY2 - vpY1);
                int maxScroll = Math.max(0, this.helpTextH - vpH);
                this.helpScrollY -= vy * 12.0;
                if (this.helpScrollY < 0.0) {
                    this.helpScrollY = 0.0;
                }
                if (this.helpScrollY > (double)maxScroll) {
                    this.helpScrollY = maxScroll;
                }
                return true;
            }
            return true;
        }
        if (this.confirmResetOpen) {
            return true;
        }
        int[] b = this.getListBounds();
        if (mx >= (double)b[0] && mx <= (double)b[2] && my >= (double)b[1] && my <= (double)b[3]) {
            this.scrollY -= vy * 12.0;
            this.clampScroll();
            return true;
        }
        return super.method_25401(mx, my, hx, vy);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        int[] bounds;
        boolean inList;
        double mx = click.comp_4798();
        double my = click.comp_4799();
        int button = click.method_74245();
        if (this.helpOpen) {
            int vpY2;
            int innerPad = 14;
            Objects.requireNonNull(this.field_22793);
            int titleBarH = 9 + 10;
            int vpX1 = this.helpX + innerPad;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpX2 = this.helpX + this.helpW - innerPad;
            int n = vpY2 = this.btnHelpClose != null ? this.btnHelpClose.method_46427() - 10 : this.helpY + this.helpH - innerPad - 20;
            if (this.btnHelpClose != null && AutoEatConfigScreen.hit(this.btnHelpClose, mx, my) && button == 0) {
                this.closeHelp();
                return true;
            }
            int vpH = Math.max(0, vpY2 - vpY1);
            if (this.helpTextH > vpH) {
                int trackX = vpX2 - 6;
                int sbX2 = trackX + 3;
                float pct = (float)(this.helpScrollY / (double)(this.helpTextH - vpH));
                int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
                int barY = vpY1 + (int)((float)(vpH - barH) * pct);
                if (mx >= (double)trackX && mx < (double)sbX2) {
                    if (my >= (double)barY && my < (double)(barY + barH)) {
                        this.helpDraggingScrollbar = true;
                        this.helpDragBarOffsetY = (int)(my - (double)barY);
                        return true;
                    }
                    if (my >= (double)vpY1 && my < (double)vpY2) {
                        int newBarTop = (int)my - barH / 2;
                        if (newBarTop < vpY1) {
                            newBarTop = vpY1;
                        }
                        if (newBarTop > vpY2 - barH) {
                            newBarTop = vpY2 - barH;
                        }
                        float t = (float)(newBarTop - vpY1) / (float)(vpH - barH);
                        this.helpScrollY = t * (float)(this.helpTextH - vpH);
                        return true;
                    }
                }
            }
            return true;
        }
        if (this.confirmResetOpen) {
            if (this.btnConfirmYes != null && AutoEatConfigScreen.hit(this.btnConfirmYes, mx, my) && button == 0) {
                this.doReset();
                this.closeResetConfirm();
                this.playClickSound();
                return true;
            }
            if (this.btnConfirmNo != null && AutoEatConfigScreen.hit(this.btnConfirmNo, mx, my) && button == 0) {
                this.closeResetConfirm();
                this.playClickSound();
                return true;
            }
            return true;
        }
        if (this.searchField != null) {
            boolean insideText;
            int textLeft = this.searchField.method_46426();
            int textRight = textLeft + this.searchField.method_25368();
            int textTop = this.searchField.method_46427();
            int textBottom = textTop + this.searchField.method_25364();
            boolean bl = insideText = mx >= (double)textLeft && mx < (double)textRight && my >= (double)textTop && my < (double)textBottom;
            if (insideText) {
                this.searchField.method_25365(true);
                return super.method_25402(click, doubled);
            }
        }
        int[] b = this.getListBounds();
        Scrollbar sb = this.getScrollbar(b[1], b[2], b[3]);
        if (this.contentHeight > b[3] - b[1] && mx >= (double)sb.x && mx < (double)(sb.x + sb.w)) {
            if (my >= (double)sb.y && my < (double)(sb.h + sb.y)) {
                this.draggingScrollbar = true;
                this.dragBarOffsetY = (int)(my - (double)sb.y);
                return true;
            }
            if (my >= (double)b[1] && my < (double)b[3]) {
                this.jumpScrollbar(my, b, sb);
                return true;
            }
        }
        if (super.method_25402(click, doubled)) {
            return true;
        }
        if (this.searchField != null) {
            boolean insideText;
            int textLeft = this.searchField.method_46426();
            int textRight = textLeft + this.searchField.method_25368();
            int textTop = this.searchField.method_46427();
            int textBottom = textTop + this.searchField.method_25364();
            boolean bl = insideText = mx >= (double)textLeft && mx < (double)textRight && my >= (double)textTop && my < (double)textBottom;
            if (!insideText && this.searchField.method_25370()) {
                this.searchField.method_25365(false);
            }
        }
        boolean bl = inList = mx >= (double)(bounds = this.getListBounds())[0] && mx < (double)bounds[2] && my >= (double)bounds[1] && my < (double)bounds[3];
        if (!inList) {
            return false;
        }
        int left = bounds[0];
        int top = bounds[1];
        int right = bounds[2];
        int bottom = bounds[3];
        int colGap = 8;
        int colW = (right - left - colGap) / 2;
        int startY = top - (int)this.scrollY;
        int rows = (this.visibleEntries.size() + 1) / 2;
        for (int row = 0; row < rows; ++row) {
            int y = startY + row * 18;
            if (y + 18 <= top || y >= bottom) continue;
            int idxL = row * 2;
            if (idxL < this.visibleEntries.size() && this.handleCellClick(this.visibleEntries.get(idxL), left, y, colW, mx, my, button)) {
                return true;
            }
            int idxR = row * 2 + 1;
            if (idxR >= this.visibleEntries.size() || !this.handleCellClick(this.visibleEntries.get(idxR), left + colW + colGap, y, colW, mx, my, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 click) {
        if (this.confirmResetOpen) {
            return true;
        }
        if (this.helpOpen) {
            this.helpDraggingScrollbar = false;
            return true;
        }
        this.draggingScrollbar = false;
        return super.method_25406(click);
    }

    public boolean method_25403(class_11909 click, double dx, double dy) {
        if (this.confirmResetOpen) {
            return true;
        }
        double my = click.comp_4799();
        if (this.helpOpen) {
            int innerPad = 14;
            Objects.requireNonNull(this.field_22793);
            int titleBarH = 9 + 10;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpY2 = this.btnHelpClose != null ? this.btnHelpClose.method_46427() - 10 : this.helpY + this.helpH - innerPad - 20;
            int vpH = Math.max(0, vpY2 - vpY1);
            if (this.helpDraggingScrollbar && this.helpTextH > vpH) {
                int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
                int newBarTop = (int)my - this.helpDragBarOffsetY;
                if (newBarTop < vpY1) {
                    newBarTop = vpY1;
                }
                if (newBarTop > vpY2 - barH) {
                    newBarTop = vpY2 - barH;
                }
                float t = (float)(newBarTop - vpY1) / (float)(vpH - barH);
                this.helpScrollY = t * (float)(this.helpTextH - vpH);
                return true;
            }
            return true;
        }
        if (this.draggingScrollbar) {
            int newBarTop;
            int[] b = this.getListBounds();
            Scrollbar sb = this.getScrollbar(b[1], b[2], b[3]);
            int viewH = b[3] - b[1];
            int maxScroll = Math.max(0, this.contentHeight - viewH);
            int barTrackH = viewH - sb.h;
            if (barTrackH < 1) {
                barTrackH = 1;
            }
            if ((newBarTop = (int)my - this.dragBarOffsetY) < b[1]) {
                newBarTop = b[1];
            }
            if (newBarTop > b[1] + barTrackH) {
                newBarTop = b[1] + barTrackH;
            }
            float t = (float)(newBarTop - b[1]) / (float)barTrackH;
            this.scrollY = t * (float)maxScroll;
            this.clampScroll();
            return true;
        }
        return super.method_25403(click, dx, dy);
    }

    public boolean method_25404(class_11908 input) {
        if (AutoEat.matchesOpenSettingsKey(input.comp_4795(), input.comp_4796(), input.comp_4797())) {
            if (this.searchField != null && this.searchField.method_25370()) {
                return super.method_25404(input);
            }
            class_310 mc = class_310.method_1551();
            if (mc != null) {
                mc.method_1507(null);
            }
            return true;
        }
        if (this.helpOpen) {
            switch (input.comp_4795()) {
                case 256: 
                case 257: 
                case 335: {
                    this.closeHelp();
                    return true;
                }
            }
            return true;
        }
        if (this.confirmResetOpen) {
            switch (input.comp_4795()) {
                case 257: 
                case 335: {
                    if (this.btnConfirmYes != null) {
                        this.doReset();
                        this.closeResetConfirm();
                    }
                    return true;
                }
                case 256: {
                    if (this.btnConfirmNo != null) {
                        this.closeResetConfirm();
                    }
                    return true;
                }
            }
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25400(class_11905 input) {
        if (this.confirmResetOpen || this.helpOpen) {
            return true;
        }
        return super.method_25400(input);
    }

    private static boolean hit(class_4185 b, double mx, double my) {
        return mx >= (double)b.method_46426() && mx < (double)(b.method_46426() + b.method_25368()) && my >= (double)b.method_46427() && my < (double)(b.method_46427() + b.method_25364());
    }

    private boolean handleCellClick(Entry e, int x, int y, int w, double mx, double my, int button) {
        if (this.confirmResetOpen || this.helpOpen) {
            return false;
        }
        if (button != 0) {
            return false;
        }
        if (!(mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + 18))) {
            return false;
        }
        if (e.lastBounds.contains((int)mx, (int)my)) {
            boolean bl = e.blacklisted = !e.blacklisted;
            if (this.btnMassToggle != null) {
                this.btnMassToggle.method_25355((class_2561)class_2561.method_43470((String)(this.areAllBlacklisted(this.visibleEntries) ? "Allow All" : "Block All")));
            }
            this.showTopRightStatus(e.blacklisted ? "Blocked 1 item" : "Allowed 1 item");
            this.playClickSound();
            return true;
        }
        return false;
    }

    private void onCancel() {
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            mc.method_1507(null);
        }
    }

    private void onDone() {
        for (Entry e : this.allEntries) {
            ConfigManager.set(e.key, e.blacklisted);
        }
        ConfigManager.save();
        class_310 mc = class_310.method_1551();
        if (mc != null) {
            mc.method_1507(null);
        }
        this.playClickSound();
    }

    private void clipToWidgetRightSlack(class_332 ctx, class_342 tf) {
        int lx = tf.method_46426() - 1;
        int ty = tf.method_46427() - 1;
        int rx = tf.method_46426() + tf.method_25368() + 2;
        int by = tf.method_46427() + tf.method_25364() + 1;
        ctx.method_44379(lx, ty, rx, by);
    }

    private int[] getListBounds() {
        int left = 12;
        int right = this.field_22789 - 12;
        int top = this.searchField.method_46427() + this.searchField.method_25364() - 4 + 4;
        int bottom = this.field_22790 - 12 - 16 - 4;
        return new int[]{left, top, right, bottom};
    }

    private void clampScroll() {
        int viewH = this.getListViewHeight();
        int maxScroll = Math.max(0, this.contentHeight - viewH);
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        if (this.scrollY > (double)maxScroll) {
            this.scrollY = maxScroll;
        }
    }

    private int getListViewHeight() {
        int[] b = this.getListBounds();
        return Math.max(0, b[3] - b[1]);
    }

    private void drawEntries(class_332 ctx, int left, int top, int right, int bottom, int mouseX, int mouseY) {
        int colGap = 8;
        int colW = (right - left - colGap) / 2;
        int startY = top - (int)this.scrollY;
        int rows = (this.visibleEntries.size() + 1) / 2;
        for (int row = 0; row < rows; ++row) {
            int idxR;
            int y = startY + row * 18;
            if (y + 18 <= top || y >= bottom) continue;
            int idxL = row * 2;
            if (idxL < this.visibleEntries.size()) {
                this.drawCell(ctx, this.visibleEntries.get(idxL), left, y, colW, mouseX, mouseY, top, bottom);
            }
            if ((idxR = row * 2 + 1) >= this.visibleEntries.size()) continue;
            this.drawCell(ctx, this.visibleEntries.get(idxR), left + colW + colGap, y, colW, mouseX, mouseY, top, bottom);
        }
    }

    private void drawCell(class_332 ctx, Entry e, int x, int y, int w, int mouseX, int mouseY, int listTop, int listBottom) {
        int cx = x + 6;
        int cy = y + 1;
        boolean hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + 18 && mouseY >= listTop && mouseY < listBottom;
        int bg = hovered ? 0x22FFFFFF : 0x11FFFFFF;
        int fy1 = Math.max(y, listTop);
        int fy2 = Math.min(y + 18, listBottom);
        if (fy2 > fy1) {
            ctx.method_25294(x, fy1, x + w, fy2, bg);
        }
        if (!e.stack.method_7960() && fy2 > fy1) {
            ctx.method_51427(e.stack, cx, cy);
        }
        int textX = cx + (e.stack.method_7960() ? 0 : 22);
        int toggleW = 36;
        if (fy2 > fy1) {
            String string = e.displayName;
            Objects.requireNonNull(this.field_22793);
            ctx.method_25303(this.field_22793, string, textX, y + (18 - 9) / 2, -1);
            int toggleX = x + w - toggleW - 8;
            int toggleY = y + 2;
            boolean blk = e.blacklisted;
            int border = blk ? -5223862 : -11882389;
            int fill = blk ? 860487680 : 855656960;
            int ty1 = Math.max(toggleY, listTop);
            int ty2 = Math.min(toggleY + 14, listBottom);
            if (ty2 > ty1) {
                ctx.method_25294(toggleX, ty1, toggleX + toggleW, ty2, fill);
                AutoEatConfigScreen.drawBorderInside(ctx, toggleX, toggleY, toggleW, 14, border);
                String state = blk ? "Yes" : "No";
                int tw = this.field_22793.method_1727(state);
                ctx.method_51433(this.field_22793, state, toggleX + (toggleW - tw) / 2, toggleY + 3, -1, false);
            }
        }
        e.lastBounds.setToggleRect(x + w - toggleW - 8, y + 2, toggleW);
    }

    private Scrollbar getScrollbar(int top, int right, int bottom) {
        Scrollbar sb = new Scrollbar();
        int viewH = bottom - top;
        if (this.contentHeight <= viewH) {
            sb.x = right - 5;
            sb.y = top;
            sb.w = 3;
            sb.h = viewH;
            return sb;
        }
        float pct = (float)(this.scrollY / (double)(this.contentHeight - viewH));
        int barH = Math.max(22, (int)((float)viewH * ((float)viewH / (float)this.contentHeight)));
        int barY = top + (int)((float)(viewH - barH) * pct);
        sb.x = right - 5;
        sb.y = barY;
        sb.w = 3;
        sb.h = barH;
        return sb;
    }

    private void jumpScrollbar(double my, int[] b, Scrollbar sb) {
        int newBarTop;
        int viewH = b[3] - b[1];
        int maxScroll = Math.max(0, this.contentHeight - viewH);
        int barH = sb.h;
        int barTrackH = viewH - barH;
        if (barTrackH < 1) {
            barTrackH = 1;
        }
        if ((newBarTop = (int)my - barH / 2) < b[1]) {
            newBarTop = b[1];
        }
        if (newBarTop > b[1] + barTrackH) {
            newBarTop = b[1] + barTrackH;
        }
        float t = (float)(newBarTop - b[1]) / (float)barTrackH;
        this.scrollY = t * (float)maxScroll;
        this.clampScroll();
    }

    private void drawScrollbar(class_332 ctx, int top, int right, int bottom) {
        int viewH = bottom - top;
        if (this.contentHeight <= viewH) {
            return;
        }
        Scrollbar sb = this.getScrollbar(top, right, bottom);
        ctx.method_25294(sb.x, sb.y, sb.x + sb.w, sb.y + sb.h, 0x66FFFFFF);
    }

    private static String readGuideText() {
        String text;
        block13: {
            text = null;
            try {
                Path p = Path.of("config", "autoeat_guide.txt");
                if (Files.isRegularFile(p, new LinkOption[0])) {
                    text = Files.readString(p, StandardCharsets.UTF_8);
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (text == null) {
                try {
                    class_3300 rm = class_310.method_1551().method_1478();
                    Optional res = rm.method_14486(class_2960.method_60655((String)"autoeat", (String)"guide.txt"));
                    if (!res.isPresent()) break block13;
                    try (InputStream is = ((class_3298)res.get()).method_14482();){
                        text = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (text == null) {
            return "";
        }
        return text.replace("\ufeff", "").replace("\r\n", "\n").replace("\r", "\n");
    }

    private void playClickSound() {
        class_310 mc = class_310.method_1551();
        if (mc != null && mc.method_1483() != null) {
            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f));
        }
    }

    private static void drawBorderInside(class_332 ctx, int x, int y, int w, int h, int color) {
        int x2 = x + w;
        int y2 = y + h;
        ctx.method_25294(x, y, x2, y + 1, color);
        ctx.method_25294(x, y2 - 1, x2, y2, color);
        ctx.method_25294(x, y + 1, x + 1, y2 - 1, color);
        ctx.method_25294(x2 - 1, y + 1, x2, y2 - 1, color);
    }

    private static enum Filter {
        ALL,
        DANGER,
        SUPER,
        NORMAL;

    }

    public static class ShaderStyleButton
    extends class_4185 {
        private int pressedAnimTicks = 0;
        private static final int PRESSED_ANIM_MAX = 6;
        private final boolean drawBorder;
        private final boolean innerShadow;
        private final int baseColor;
        private final int hoverColor;
        private final int pressedColor;
        private final int textColorNormal;
        private final int textColorHover;

        public ShaderStyleButton(int x, int y, int w, int h, class_2561 msg, class_4185.class_4241 onPress, boolean drawBorder) {
            this(x, y, w, h, msg, onPress, -2144191674, -1606793644, -1071503568, -1052689, -1, drawBorder, false);
        }

        public ShaderStyleButton(int x, int y, int w, int h, class_2561 msg, class_4185.class_4241 onPress, int base, int hover, int press, int textNormal, int textHover, boolean drawBorder, boolean innerShadow) {
            super(x, y, w, h, msg, onPress, class_4185.field_40754);
            this.baseColor = base;
            this.hoverColor = hover;
            this.pressedColor = press;
            this.textColorNormal = textNormal;
            this.textColorHover = textHover;
            this.drawBorder = drawBorder;
            this.innerShadow = innerShadow;
        }

        public void method_25348(class_11909 click, boolean doubled) {
            this.pressedAnimTicks = 6;
            super.method_25348(click, doubled);
        }

        protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
            boolean hovered;
            if (this.pressedAnimTicks > 0) {
                --this.pressedAnimTicks;
            }
            int x = this.method_46426();
            int y = this.method_46427();
            int w = this.method_25368();
            int h = this.method_25364();
            boolean bl = hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
            int bg = this.pressedAnimTicks > 0 ? this.pressedColor : (hovered ? this.hoverColor : this.baseColor);
            ctx.method_25294(x, y, x + w, y + h, bg);
            if (this.innerShadow) {
                ctx.method_25294(x + 1, y + 1, x + w - 1, y + 2, 0x22000000);
                ctx.method_25294(x + 1, y + h - 2, x + w - 1, y + h - 1, 0x22000000);
            }
            if (this.drawBorder) {
                AutoEatConfigScreen.drawBorderInside(ctx, x, y, w, h, -1);
            }
            class_327 tr = class_310.method_1551().field_1772;
            int color = hovered ? this.textColorHover : this.textColorNormal;
            int tw = tr.method_27525((class_5348)this.method_25369());
            int textX = x + (w - tw) / 2;
            Objects.requireNonNull(tr);
            int textY = y + (h - 9) / 2 + 1;
            if (tw > 0) {
                ctx.method_27535(tr, this.method_25369(), textX, textY, color);
            }
        }
    }

    private static class Entry {
        final class_1799 stack;
        final String key;
        boolean blacklisted;
        final String displayName;
        final String displayLower;
        final String keyLower;
        final String namespace;
        final String idPath;
        final Bounds lastBounds = new Bounds();

        Entry(class_1799 s, String k, boolean b, String display, String ns, String path) {
            this.stack = s;
            this.key = k;
            this.blacklisted = b;
            this.displayName = display != null ? display : (k != null ? k : "");
            this.displayLower = this.displayName.toLowerCase(Locale.ROOT);
            this.keyLower = (k != null ? k : "").toLowerCase(Locale.ROOT);
            this.namespace = ns != null ? ns.toLowerCase(Locale.ROOT) : "custom";
            this.idPath = path != null ? path.toLowerCase(Locale.ROOT) : this.keyLower;
        }
    }

    private static class Scrollbar {
        int x;
        int y;
        int w;
        int h;

        private Scrollbar() {
        }
    }

    private static class Bounds {
        int x;
        int y;
        int w;
        int h;

        private Bounds() {
        }

        void setToggleRect(int X, int Y, int W) {
            this.x = X;
            this.y = Y;
            this.w = W;
            this.h = 14;
        }

        boolean contains(int mx, int my) {
            return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
        }
    }
}

