/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_11908;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import net.zynwro.autoeat.AutoEatConfigScreen;
import net.zynwro.autoeat.ConfigManager;
import org.lwjgl.glfw.GLFW;

public class AutoEat
implements ClientModInitializer {
    public static final String MOD_ID = "autoeat";
    private static class_304 toggleKey;
    private static class_304 openSettingsKey;
    private static boolean enabled;
    private static boolean chaining;
    private static boolean useKeyHeld;
    private static int prevSelectedSlot;
    private static boolean wasScreenOpen;
    private static boolean pausedByScreen;
    private static boolean userUsePrev;
    private static boolean rmbPrev;
    private static boolean pausedByUserRMB;
    private static int forcePlaceCooldownTicks;
    private static int onHitCooldownTicks;
    private static int lastHurtTime;
    private static int antiPlaceSuppressTicks;
    private static final class_304.class_11900 KEY_CATEGORY;

    public void onInitializeClient() {
        ConfigManager.load();
        toggleKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.autoeat.toggle", class_3675.class_307.field_1668, 72, KEY_CATEGORY));
        openSettingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.autoeat.open_settings", class_3675.class_307.field_1668, 74, KEY_CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            boolean userUseNow;
            boolean screenOpen;
            while (toggleKey.method_1436()) {
                boolean bl = enabled = !enabled;
                if (!enabled) {
                    this.stopAndRestore(client);
                }
                this.notifyToggle(client, enabled);
            }
            while (openSettingsKey.method_1436()) {
                if (client == null) continue;
                client.method_1507((class_437)new AutoEatConfigScreen());
            }
            if (!enabled) {
                return;
            }
            if (client == null || client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            if (!this.isSurvival(client)) {
                this.stopAndRestore(client);
                return;
            }
            if (forcePlaceCooldownTicks > 0) {
                --forcePlaceCooldownTicks;
            }
            if (onHitCooldownTicks > 0) {
                --onHitCooldownTicks;
            }
            if (antiPlaceSuppressTicks > 0) {
                this.releaseUse(client);
                --antiPlaceSuppressTicks;
                return;
            }
            class_746 p = client.field_1724;
            if (ConfigManager.isPauseOnHit()) {
                boolean justHurt;
                boolean bl = justHurt = p.field_6235 > 0 && lastHurtTime <= 0;
                if (justHurt) {
                    boolean starving;
                    boolean bl2 = starving = p.method_7344().method_7586() == 0;
                    if (!starving) {
                        if (useKeyHeld) {
                            this.releaseUse(client);
                        }
                        chaining = false;
                        pausedByUserRMB = false;
                        onHitCooldownTicks = Math.max(onHitCooldownTicks, ConfigManager.getOnHitCooldownSec() * 20);
                        antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                    }
                }
            }
            lastHurtTime = p.field_6235;
            boolean rmbNow = this.isRightMouseDown(client);
            boolean rmbPressedEdge = rmbNow && !rmbPrev;
            boolean rmbReleasedEdge = !rmbNow && rmbPrev;
            rmbPrev = rmbNow;
            boolean bl = screenOpen = client.field_1755 != null;
            if (screenOpen) {
                if (!wasScreenOpen) {
                    if (useKeyHeld) {
                        this.releaseUse(client);
                    }
                    pausedByScreen = chaining;
                    chaining = false;
                    antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 6);
                }
                wasScreenOpen = true;
                return;
            }
            if (wasScreenOpen) {
                wasScreenOpen = false;
                if (pausedByScreen && this.canStartConsume((class_1657)p)) {
                    this.startOrResumeChain(client);
                }
                pausedByScreen = false;
            }
            boolean userPressedEdge = (userUseNow = this.isUserHoldingUse(client)) && !userUsePrev;
            boolean userReleasedEdge = !userUseNow && userUsePrev;
            userUsePrev = userUseNow;
            if (chaining && rmbPressedEdge) {
                if (ConfigManager.isAllowForcePlaceWhileEating()) {
                    if (useKeyHeld) {
                        this.releaseUse(client);
                    }
                    pausedByUserRMB = true;
                    chaining = false;
                    forcePlaceCooldownTicks = Math.max(forcePlaceCooldownTicks, ConfigManager.getForcePlaceCooldownSec() * 20);
                    antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                    return;
                }
                this.holdUse(client);
            }
            if (!chaining && pausedByUserRMB && rmbReleasedEdge) {
                pausedByUserRMB = false;
                if (this.canStartConsume((class_1657)p)) {
                    this.startOrResumeChain(client);
                }
            }
            if (chaining && userPressedEdge) {
                if (useKeyHeld) {
                    this.releaseUse(client);
                }
                chaining = false;
                antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                return;
            }
            if (!chaining && userReleasedEdge && this.canStartConsume((class_1657)p)) {
                this.startOrResumeChain(client);
            }
            this.tickAutoEat(client, userUseNow || rmbNow);
        });
    }

    public static boolean matchesOpenSettingsKey(int keyCode, int scanCode, int modifiers) {
        return openSettingsKey != null && openSettingsKey.method_1417(new class_11908(keyCode, scanCode, modifiers));
    }

    private void tickAutoEat(class_310 client, boolean userHoldingUse) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        class_746 p = client.field_1724;
        boolean blocked = forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0;
        boolean wantStart = !blocked && this.canStartConsume((class_1657)p);
        boolean shouldContinue = !blocked && this.canContinueConsume((class_1657)p);
        boolean using = p.method_6115();
        if (userHoldingUse) {
            if (useKeyHeld) {
                this.releaseUse(client);
            }
            chaining = false;
            antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
            return;
        }
        if (!chaining) {
            if (!wantStart || using) {
                return;
            }
            this.startOrResumeChain(client);
            return;
        }
        if (!shouldContinue) {
            this.stopAndRestore(client);
            return;
        }
        class_1268 intended = this.preferredEdibleHand((class_1657)p);
        if (intended == null) {
            this.stopAndRestore(client);
            return;
        }
        this.holdUse(client);
        if (using) {
            return;
        }
        if (!p.method_6115()) {
            AutoEat.safeInteract(client, (class_1657)p, intended);
        }
    }

    private boolean canStartConsume(class_1657 p) {
        if (p == null) {
            return false;
        }
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return false;
        }
        if (!p.method_7332(false)) {
            return false;
        }
        int missingBars = (20 - p.method_7344().method_7586()) / 2;
        return missingBars >= ConfigManager.getEatThresholdBars();
    }

    private boolean canContinueConsume(class_1657 p) {
        if (p == null) {
            return false;
        }
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return false;
        }
        if (ConfigManager.isEatUntilFull()) {
            return p.method_7332(false);
        }
        return this.canStartConsume(p);
    }

    private void startOrResumeChain(class_310 client) {
        if (client == null || client.field_1724 == null) {
            return;
        }
        class_746 p = client.field_1724;
        if (p.method_6115()) {
            return;
        }
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return;
        }
        class_1268 hand = this.pickStartHand(client);
        if (hand == null) {
            return;
        }
        AutoEat.safeInteract(client, (class_1657)p, hand);
        this.holdUse(client);
        chaining = true;
    }

    private class_1268 pickStartHand(class_310 client) {
        if (client == null || client.field_1724 == null) {
            return null;
        }
        class_746 p = client.field_1724;
        boolean emergency = this.isEmergency((class_1657)p);
        if (emergency) {
            int bestSlot = this.findBestEdibleHotbarSlot((class_1657)p, true);
            if (bestSlot != -1) {
                if (prevSelectedSlot == -1) {
                    prevSelectedSlot = AutoEat.getHotbarSlot((class_1657)p);
                }
                AutoEat.setHotbarSlot((class_1657)p, bestSlot);
                return class_1268.field_5808;
            }
            if (this.isEdibleAllowed(p.method_6047())) {
                return class_1268.field_5808;
            }
            if (this.isEdibleAllowed(p.method_6079())) {
                return class_1268.field_5810;
            }
            return null;
        }
        if (ConfigManager.isOffhandFirst() && this.isEdibleAllowed(p.method_6079())) {
            return class_1268.field_5810;
        }
        if (this.isEdibleAllowed(p.method_6047())) {
            return class_1268.field_5808;
        }
        if (!ConfigManager.isOffhandFirst() && this.isEdibleAllowed(p.method_6079())) {
            return class_1268.field_5810;
        }
        int bestSlot = this.findBestEdibleHotbarSlot((class_1657)p, false);
        if (bestSlot != -1) {
            if (prevSelectedSlot == -1) {
                prevSelectedSlot = AutoEat.getHotbarSlot((class_1657)p);
            }
            AutoEat.setHotbarSlot((class_1657)p, bestSlot);
            return class_1268.field_5808;
        }
        return null;
    }

    private class_1268 preferredEdibleHand(class_1657 p) {
        if (p == null) {
            return null;
        }
        if (ConfigManager.isOffhandFirst() && this.isEdibleAllowed(p.method_6079())) {
            return class_1268.field_5810;
        }
        if (this.isEdibleAllowed(p.method_6047())) {
            return class_1268.field_5808;
        }
        if (!ConfigManager.isOffhandFirst() && this.isEdibleAllowed(p.method_6079())) {
            return class_1268.field_5810;
        }
        return null;
    }

    private boolean isEdibleAllowed(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_4174 fc = (class_4174)stack.method_58694(class_9334.field_50075);
        if (fc == null || stack.method_7947() <= 0) {
            return false;
        }
        return !ConfigManager.isBlacklisted(stack.method_7909().method_7876());
    }

    private int findBestEdibleHotbarSlot(class_1657 p, boolean emergency) {
        int bestSlot = -1;
        double bestScore = -1.0;
        boolean preferBest = ConfigManager.isPreferBestFood() || emergency;
        for (int slot = 0; slot < 9; ++slot) {
            class_1799 s = p.method_31548().method_5438(slot);
            if (!this.isEdibleAllowed(s)) continue;
            double score = 1.0;
            if (preferBest) {
                double d = score = emergency ? this.computeFoodScoreEmergency(s) : this.computeFoodScore(s);
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestSlot = slot;
        }
        return bestSlot;
    }

    private double computeFoodScore(class_1799 s) {
        if (s.method_7909() == class_1802.field_8367) {
            return 1000.0;
        }
        if (s.method_7909() == class_1802.field_8463) {
            return 900.0;
        }
        if (s.method_7909() == class_1802.field_8071) {
            return 850.0;
        }
        class_4174 fc = (class_4174)s.method_58694(class_9334.field_50075);
        if (fc == null) {
            return 0.0;
        }
        double hunger = fc.comp_2491();
        double saturation = fc.comp_2492();
        return hunger * 10.0 + saturation * 6.0;
    }

    private double computeFoodScoreEmergency(class_1799 s) {
        if (s.method_7909() == class_1802.field_8367) {
            return 10000.0;
        }
        if (s.method_7909() == class_1802.field_8463) {
            return 9000.0;
        }
        if (s.method_7909() == class_1802.field_8071) {
            return 8500.0;
        }
        return this.computeFoodScore(s);
    }

    private boolean isEmergency(class_1657 p) {
        if (!ConfigManager.isSmartModeEnabled()) {
            return false;
        }
        if (p == null) {
            return false;
        }
        int thrHearts = ConfigManager.getEmergencyHearts();
        return p.method_6032() < (float)thrHearts * 2.0f;
    }

    private boolean isUserHoldingUse(class_310 client) {
        return client != null && client.field_1690 != null && client.field_1690.field_1904 != null && client.field_1690.field_1904.method_1434() && !useKeyHeld;
    }

    private boolean isRightMouseDown(class_310 client) {
        if (client == null || client.method_22683() == null) {
            return false;
        }
        long win = client.method_22683().method_4490();
        return GLFW.glfwGetMouseButton((long)win, (int)1) == 1;
    }

    private void holdUse(class_310 client) {
        if (!useKeyHeld && client != null && client.field_1690 != null && client.field_1690.field_1904 != null && !client.field_1690.field_1904.method_1434()) {
            client.field_1690.field_1904.method_23481(true);
            useKeyHeld = true;
        }
    }

    private void releaseUse(class_310 client) {
        if (useKeyHeld && client != null && client.field_1690 != null && client.field_1690.field_1904 != null) {
            client.field_1690.field_1904.method_23481(false);
            useKeyHeld = false;
        }
    }

    private void stopAndRestore(class_310 client) {
        this.releaseUse(client);
        if (client != null && client.field_1724 != null && prevSelectedSlot != -1 && AutoEat.getHotbarSlot((class_1657)client.field_1724) != prevSelectedSlot) {
            AutoEat.setHotbarSlot((class_1657)client.field_1724, prevSelectedSlot);
        }
        prevSelectedSlot = -1;
        chaining = false;
        pausedByUserRMB = false;
        antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 10);
    }

    private boolean isSurvival(class_310 client) {
        return client != null && client.field_1761 != null && client.field_1761.method_2920() == class_1934.field_9215;
    }

    private void notifyToggle(class_310 client, boolean state) {
        if (!ConfigManager.isShowToggleToast()) {
            return;
        }
        if (client == null || client.field_1724 == null) {
            return;
        }
        client.field_1724.method_7353(class_2561.method_30163((String)(state ? "[AutoEat] Enabled" : "[AutoEat] Disabled")), true);
    }

    private static int getHotbarSlot(class_1657 p) {
        return p.method_31548().method_67532();
    }

    private static void setHotbarSlot(class_1657 p, int slot) {
        if (slot >= 0 && slot < 9) {
            p.method_31548().method_61496(slot);
        }
    }

    private static void safeInteract(class_310 client, class_1657 player, class_1268 hand) {
        if (client == null || client.field_1761 == null || player == null || hand == null) {
            return;
        }
        client.field_1761.method_2919(player, hand);
    }

    static {
        enabled = true;
        chaining = false;
        useKeyHeld = false;
        prevSelectedSlot = -1;
        wasScreenOpen = false;
        pausedByScreen = false;
        userUsePrev = false;
        rmbPrev = false;
        pausedByUserRMB = false;
        forcePlaceCooldownTicks = 0;
        onHitCooldownTicks = 0;
        lastHurtTime = 0;
        antiPlaceSuppressTicks = 0;
        KEY_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)MOD_ID, (String)"main"));
    }
}

