/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.zynwro.autoeat.AutoEatConfigScreen;
import net.zynwro.autoeat.ConfigManager;
import org.lwjgl.glfw.GLFW;

@Mod(value="autoeat")
public class AutoEat {
    public static final String MOD_ID = "autoeat";
    private static KeyMapping toggleKey;
    private static KeyMapping openSettingsKey;
    private static boolean enabled;
    private static boolean chaining;
    private static boolean useKeyHeld;
    private static int prevSelectedSlot;
    private static boolean wasScreenOpen;
    private static boolean pausedByScreen;
    private static boolean userUsePrev;
    private static boolean rmbPrev;
    private static boolean pausedByUserRMB;
    private static int forcePlaceCooldownTicks;
    private static int onHitCooldownTicks;
    private static int lastHurtTime;
    private static int antiPlaceSuppressTicks;

    public AutoEat() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ConfigManager.load();
        }
    }

    public static int getOpenSettingsKeyCode() {
        return openSettingsKey != null ? openSettingsKey.getKey().m_84873_() : 74;
    }

    private static void tickAutoEat(Minecraft client, boolean userHoldingUse) {
        LocalPlayer p = client.f_91074_;
        if (p == null) {
            return;
        }
        boolean blocked = forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0;
        boolean wantStart = !blocked && AutoEat.canStartConsume((Player)p);
        boolean shouldContinue = !blocked && AutoEat.canContinueConsume((Player)p);
        boolean using = p.m_6117_();
        if (userHoldingUse) {
            if (useKeyHeld) {
                AutoEat.releaseUse(client);
            }
            chaining = false;
            antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
            return;
        }
        if (!chaining) {
            if (!wantStart || using) {
                return;
            }
            AutoEat.startOrResumeChain(client);
            return;
        }
        if (!shouldContinue) {
            AutoEat.stopAndRestore(client);
            return;
        }
        InteractionHand intended = AutoEat.preferredEdibleHand((Player)p);
        if (intended == null) {
            AutoEat.stopAndRestore(client);
            return;
        }
        AutoEat.holdUse(client);
        if (using) {
            return;
        }
        if (!p.m_6117_()) {
            AutoEat.safeInteract(client, (Player)p, intended);
        }
    }

    private static boolean canStartConsume(Player p) {
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return false;
        }
        if (!p.m_36391_(false)) {
            return false;
        }
        int missingBars = (20 - p.m_36324_().m_38702_()) / 2;
        return missingBars >= ConfigManager.getEatThresholdBars();
    }

    private static boolean canContinueConsume(Player p) {
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return false;
        }
        if (ConfigManager.isEatUntilFull()) {
            return p.m_36391_(false);
        }
        return AutoEat.canStartConsume(p);
    }

    private static void startOrResumeChain(Minecraft client) {
        LocalPlayer p = client.f_91074_;
        if (p == null || p.m_6117_()) {
            return;
        }
        if (forcePlaceCooldownTicks > 0 || onHitCooldownTicks > 0) {
            return;
        }
        InteractionHand hand = AutoEat.pickStartHand(client);
        if (hand == null) {
            return;
        }
        AutoEat.safeInteract(client, (Player)p, hand);
        AutoEat.holdUse(client);
        chaining = true;
    }

    private static InteractionHand pickStartHand(Minecraft client) {
        LocalPlayer p = client.f_91074_;
        if (p == null) {
            return null;
        }
        boolean emergency = AutoEat.isEmergency((Player)p);
        if (emergency) {
            int bestSlot = AutoEat.findBestEdibleHotbarSlot((Player)p, true);
            if (bestSlot != -1) {
                if (prevSelectedSlot == -1) {
                    prevSelectedSlot = AutoEat.getHotbarSlot((Player)p);
                }
                AutoEat.setHotbarSlot((Player)p, bestSlot);
                return InteractionHand.MAIN_HAND;
            }
            if (AutoEat.isEdibleAllowed(p.m_21205_(), (Player)p)) {
                return InteractionHand.MAIN_HAND;
            }
            if (AutoEat.isEdibleAllowed(p.m_21206_(), (Player)p)) {
                return InteractionHand.OFF_HAND;
            }
            return null;
        }
        if (ConfigManager.isOffhandFirst() && AutoEat.isEdibleAllowed(p.m_21206_(), (Player)p)) {
            return InteractionHand.OFF_HAND;
        }
        if (AutoEat.isEdibleAllowed(p.m_21205_(), (Player)p)) {
            return InteractionHand.MAIN_HAND;
        }
        if (!ConfigManager.isOffhandFirst() && AutoEat.isEdibleAllowed(p.m_21206_(), (Player)p)) {
            return InteractionHand.OFF_HAND;
        }
        int bestSlot = AutoEat.findBestEdibleHotbarSlot((Player)p, false);
        if (bestSlot != -1) {
            if (prevSelectedSlot == -1) {
                prevSelectedSlot = AutoEat.getHotbarSlot((Player)p);
            }
            AutoEat.setHotbarSlot((Player)p, bestSlot);
            return InteractionHand.MAIN_HAND;
        }
        return null;
    }

    private static InteractionHand preferredEdibleHand(Player p) {
        if (ConfigManager.isOffhandFirst() && AutoEat.isEdibleAllowed(p.m_21206_(), p)) {
            return InteractionHand.OFF_HAND;
        }
        if (AutoEat.isEdibleAllowed(p.m_21205_(), p)) {
            return InteractionHand.MAIN_HAND;
        }
        if (!ConfigManager.isOffhandFirst() && AutoEat.isEdibleAllowed(p.m_21206_(), p)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isEdibleAllowed(ItemStack stack, Player p) {
        if (stack.m_41619_()) {
            return false;
        }
        FoodProperties fp = stack.getFoodProperties((LivingEntity)p);
        if (fp == null || stack.m_41613_() <= 0) {
            return false;
        }
        return !ConfigManager.isBlacklisted(stack.m_41720_().m_5524_());
    }

    private static int findBestEdibleHotbarSlot(Player p, boolean emergency) {
        int bestSlot = -1;
        double bestScore = -1.0;
        boolean preferBest = ConfigManager.isPreferBestFood() || emergency;
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack s = p.m_150109_().m_8020_(slot);
            if (!AutoEat.isEdibleAllowed(s, p)) continue;
            double score = 1.0;
            if (preferBest) {
                double d = score = emergency ? AutoEat.computeFoodScoreEmergency(s, p) : AutoEat.computeFoodScore(s, p);
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestSlot = slot;
        }
        return bestSlot;
    }

    private static double computeFoodScore(ItemStack s, Player p) {
        if (s.m_150930_(Items.f_42437_)) {
            return 1000.0;
        }
        if (s.m_150930_(Items.f_42436_)) {
            return 900.0;
        }
        if (s.m_150930_(Items.f_42677_)) {
            return 850.0;
        }
        FoodProperties fp = s.getFoodProperties((LivingEntity)p);
        if (fp == null) {
            return 0.0;
        }
        double hunger = fp.m_38744_();
        double saturation = fp.m_38745_();
        return hunger * 10.0 + saturation * 6.0;
    }

    private static double computeFoodScoreEmergency(ItemStack s, Player p) {
        if (s.m_150930_(Items.f_42437_)) {
            return 10000.0;
        }
        if (s.m_150930_(Items.f_42436_)) {
            return 9000.0;
        }
        if (s.m_150930_(Items.f_42677_)) {
            return 8500.0;
        }
        return AutoEat.computeFoodScore(s, p);
    }

    private static boolean isEmergency(Player p) {
        if (!ConfigManager.isSmartModeEnabled()) {
            return false;
        }
        int thrHearts = ConfigManager.getEmergencyHearts();
        return p.m_21223_() < (float)thrHearts * 2.0f;
    }

    private static boolean isUserHoldingUse(Minecraft client) {
        return client.f_91066_.f_92095_.m_90857_() && !useKeyHeld;
    }

    private static boolean isRightMouseDown(Minecraft client) {
        long win = client.m_91268_().m_85439_();
        return GLFW.glfwGetMouseButton((long)win, (int)1) == 1;
    }

    private static void holdUse(Minecraft client) {
        if (!useKeyHeld && !client.f_91066_.f_92095_.m_90857_()) {
            client.f_91066_.f_92095_.m_7249_(true);
            useKeyHeld = true;
        }
    }

    private static void releaseUse(Minecraft client) {
        if (useKeyHeld) {
            client.f_91066_.f_92095_.m_7249_(false);
            useKeyHeld = false;
        }
    }

    private static void stopAndRestore(Minecraft client) {
        AutoEat.releaseUse(client);
        LocalPlayer p = client.f_91074_;
        if (p != null && prevSelectedSlot != -1 && AutoEat.getHotbarSlot((Player)p) != prevSelectedSlot) {
            AutoEat.setHotbarSlot((Player)p, prevSelectedSlot);
        }
        prevSelectedSlot = -1;
        chaining = false;
        pausedByUserRMB = false;
        antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 10);
    }

    private static boolean isSurvival(Minecraft client) {
        return client.f_91072_ != null && client.f_91072_.m_105295_() == GameType.SURVIVAL;
    }

    private static void notifyToggle(Minecraft client, boolean state) {
        LocalPlayer p = client.f_91074_;
        if (!ConfigManager.isShowToggleToast() || p == null) {
            return;
        }
        p.m_5661_((Component)Component.m_237113_((String)(state ? "[AutoEat] Enabled" : "[AutoEat] Disabled")), true);
    }

    private static int getHotbarSlot(Player p) {
        return p.m_150109_().f_35977_;
    }

    private static void setHotbarSlot(Player p, int slot) {
        if (slot >= 0 && slot < 9) {
            p.m_150109_().f_35977_ = slot;
        }
    }

    private static void safeInteract(Minecraft client, Player player, InteractionHand hand) {
        if (client.f_91072_ != null) {
            client.f_91072_.m_233721_(player, hand);
        }
    }

    static {
        enabled = true;
        chaining = false;
        useKeyHeld = false;
        prevSelectedSlot = -1;
        wasScreenOpen = false;
        pausedByScreen = false;
        userUsePrev = false;
        rmbPrev = false;
        pausedByUserRMB = false;
        forcePlaceCooldownTicks = 0;
        onHitCooldownTicks = 0;
        lastHurtTime = 0;
        antiPlaceSuppressTicks = 0;
    }

    @Mod.EventBusSubscriber(modid="autoeat", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusClient {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            boolean userUseNow;
            boolean screenOpen;
            Minecraft client = Minecraft.m_91087_();
            if (toggleKey != null) {
                while (toggleKey.m_90859_()) {
                    boolean bl = enabled = !enabled;
                    if (!enabled) {
                        AutoEat.stopAndRestore(client);
                    }
                    AutoEat.notifyToggle(client, enabled);
                }
            }
            if (openSettingsKey != null) {
                while (openSettingsKey.m_90859_()) {
                    client.m_91152_((Screen)new AutoEatConfigScreen());
                }
            }
            if (!enabled) {
                return;
            }
            if (client.f_91073_ == null || client.f_91074_ == null) {
                return;
            }
            if (!AutoEat.isSurvival(client)) {
                AutoEat.stopAndRestore(client);
                return;
            }
            if (forcePlaceCooldownTicks > 0) {
                --forcePlaceCooldownTicks;
            }
            if (onHitCooldownTicks > 0) {
                --onHitCooldownTicks;
            }
            if (antiPlaceSuppressTicks > 0) {
                AutoEat.releaseUse(client);
                --antiPlaceSuppressTicks;
                return;
            }
            LocalPlayer p = client.f_91074_;
            if (ConfigManager.isPauseOnHit()) {
                boolean justHurt;
                boolean bl = justHurt = p.f_20916_ > 0 && lastHurtTime <= 0;
                if (justHurt) {
                    boolean starving;
                    boolean bl2 = starving = p.m_36324_().m_38702_() == 0;
                    if (!starving) {
                        if (useKeyHeld) {
                            AutoEat.releaseUse(client);
                        }
                        chaining = false;
                        pausedByUserRMB = false;
                        onHitCooldownTicks = Math.max(onHitCooldownTicks, ConfigManager.getOnHitCooldownSec() * 20);
                        antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                    }
                }
            }
            lastHurtTime = p.f_20916_;
            boolean rmbNow = AutoEat.isRightMouseDown(client);
            boolean rmbPressedEdge = rmbNow && !rmbPrev;
            boolean rmbReleasedEdge = !rmbNow && rmbPrev;
            rmbPrev = rmbNow;
            boolean bl = screenOpen = client.f_91080_ != null;
            if (screenOpen) {
                if (!wasScreenOpen) {
                    if (useKeyHeld) {
                        AutoEat.releaseUse(client);
                    }
                    pausedByScreen = chaining;
                    chaining = false;
                    antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 6);
                }
                wasScreenOpen = true;
                return;
            }
            if (wasScreenOpen) {
                wasScreenOpen = false;
                if (pausedByScreen && AutoEat.canStartConsume((Player)p)) {
                    AutoEat.startOrResumeChain(client);
                }
                pausedByScreen = false;
            }
            boolean userPressedEdge = (userUseNow = AutoEat.isUserHoldingUse(client)) && !userUsePrev;
            boolean userReleasedEdge = !userUseNow && userUsePrev;
            userUsePrev = userUseNow;
            if (chaining && rmbPressedEdge) {
                if (ConfigManager.isAllowForcePlaceWhileEating()) {
                    if (useKeyHeld) {
                        AutoEat.releaseUse(client);
                    }
                    pausedByUserRMB = true;
                    chaining = false;
                    forcePlaceCooldownTicks = Math.max(forcePlaceCooldownTicks, ConfigManager.getForcePlaceCooldownSec() * 20);
                    antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                    return;
                }
                AutoEat.holdUse(client);
            }
            if (!chaining && pausedByUserRMB && rmbReleasedEdge) {
                pausedByUserRMB = false;
                if (AutoEat.canStartConsume((Player)p)) {
                    AutoEat.startOrResumeChain(client);
                }
            }
            if (chaining && userPressedEdge) {
                if (useKeyHeld) {
                    AutoEat.releaseUse(client);
                }
                chaining = false;
                antiPlaceSuppressTicks = Math.max(antiPlaceSuppressTicks, 8);
                return;
            }
            if (!chaining && userReleasedEdge && AutoEat.canStartConsume((Player)p)) {
                AutoEat.startOrResumeChain(client);
            }
            AutoEat.tickAutoEat(client, userUseNow || rmbNow);
        }
    }

    @Mod.EventBusSubscriber(modid="autoeat", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusClient {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent e) {
            toggleKey = new KeyMapping("key.autoeat.toggle", InputConstants.Type.KEYSYM, 72, "key.categories.autoeat");
            openSettingsKey = new KeyMapping("key.autoeat.open_settings", InputConstants.Type.KEYSYM, 74, "key.categories.autoeat");
            e.register(toggleKey);
            e.register(openSettingsKey);
        }
    }
}

