/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.zynwro.autoeat.AutoEat;
import net.zynwro.autoeat.AutoEatConfigScreen;
import net.zynwro.autoeat.ConfigManager;

@ParametersAreNonnullByDefault
public class AutoEatAdvancedScreen
extends Screen {
    private final Screen parent;
    private static final int PADDING = 12;
    private static final int GAP = 6;
    private static final int BTN_H = 16;
    private static final int COL_GAP = 12;
    private static final int ADV_BTN_W = 140;
    private static final int ADV_BTN_H = 16;
    private static final int MAX_BARS = 10;
    private static final int MAX_HEARTS = 10;
    private static final int MAX_FP_SEC = 5;
    private static final int MAX_HIT_SEC = 10;
    private static final int TOOLTIP_DELAY_TICKS = 8;
    private static final int TOOLTIP_MAX_WIDTH = 220;
    private static final int TOOLTIP_PAD = 5;
    private static final int TOOLTIP_LINE_GAP = 2;
    private static final int TOAST_MAX_TICKS = 70;
    private final List<ToggleCtl> toggles = new ArrayList<ToggleCtl>();
    private final List<SliderCtl> sliders = new ArrayList<SliderCtl>();
    private int contentLeft;
    private int contentTop;
    private int contentRight;
    private int contentBottom;
    private int contentHeight;
    private double scrollY;
    private String hoveredId = "";
    private String statusMsg = "";
    private int hoverTicks;
    private int statusTicks;

    public AutoEatAdvancedScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Advanced Settings"));
        this.parent = parent;
    }

    protected void m_7856_() {
        int btnW = 66;
        int gap = 6;
        int bottomY = this.f_96544_ - 12 - 16;
        int footerW = btnW * 3 + gap * 2;
        int bottomX = Math.floorDiv(this.f_96543_ - footerW, 2);
        this.m_142416_((GuiEventListener)new AutoEatConfigScreen.ShaderStyleButton(bottomX, bottomY, btnW, 16, (Component)Component.m_237113_((String)"Cancel"), b -> {
            this.click();
            this.closeParent();
        }, true));
        this.m_142416_((GuiEventListener)new AutoEatConfigScreen.ShaderStyleButton(bottomX + btnW + gap, bottomY, btnW, 16, (Component)Component.m_237113_((String)"Reset"), b -> {
            this.click();
            this.resetAll();
        }, true));
        this.m_142416_((GuiEventListener)new AutoEatConfigScreen.ShaderStyleButton(bottomX + (btnW + gap) * 2, bottomY, btnW, 16, (Component)Component.m_237113_((String)"Save"), b -> {
            this.click();
            this.saveAll();
        }, true));
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        int headerH = 12 + 9 + 2 + 9 + 6;
        this.contentLeft = 12;
        this.contentRight = this.f_96543_ - 12;
        this.contentTop = headerH + 6;
        this.contentBottom = bottomY - 6;
        this.toggles.clear();
        this.sliders.clear();
        this.toggles.add(this.tg(0, "offhand", "Offhand First", ConfigManager::isOffhandFirst, ConfigManager::setOffhandFirst, "Prioritize offhand food before main hand/hotbar."));
        this.toggles.add(this.tg(0, "detect", "Detect Mod Foods", ConfigManager::isDetectModFoods, ConfigManager::setDetectModFoods, "Include modded foods automatically."));
        this.toggles.add(this.tg(0, "best", "Always Use Best", ConfigManager::isPreferBestFood, ConfigManager::setPreferBestFood, "Always pick the highest-value food even when safe."));
        this.toggles.add(this.tg(0, "full", "Eat Until Full", ConfigManager::isEatUntilFull, ConfigManager::setEatUntilFull, "Keep eating until hunger is completely full."));
        this.toggles.add(this.tg(0, "toast", "Show Toggle Toast", ConfigManager::isShowToggleToast, ConfigManager::setShowToggleToast, "Show a short message when AutoEat is enabled/disabled."));
        this.toggles.add(this.tg(0, "smart", "Smart Panic Mode", ConfigManager::isSmartModeEnabled, ConfigManager::setSmartModeEnabled, "Use premium food when your health is below the panic limit."));
        this.sliders.add(this.sl(0, "hunger", "Hunger Trigger", 10, 1, ConfigManager::getEatThresholdShanks, ConfigManager::setEatThresholdShanks, "Start auto-eating when hunger falls to this level."));
        this.sliders.add(this.sl(1, "panic", "Panic Health", 10, 4, ConfigManager::getEmergencyHearts, ConfigManager::setEmergencyHearts, "Switch to premium food at or below this health."));
        this.toggles.add(this.tg(1, "allow_force", "Allow Force Place", ConfigManager::isAllowForcePlaceWhileEating, ConfigManager::setAllowForcePlaceWhileEating, "Let you place a block while eating. AutoEat pauses right after."));
        this.sliders.add(this.sl(1, "fp_sec", "On-Place Cooldown", 5, 2, ConfigManager::getForcePlaceCooldownSec, ConfigManager::setForcePlaceCooldownSec, "How long AutoEat waits after a forced place while eating."));
        this.toggles.add(this.tg(1, "pause_hit", "Hit Pause", ConfigManager::isPauseOnHit, ConfigManager::setPauseOnHit, "Stop eating immediately if anything hits you, then start a cooldown."));
        this.sliders.add(this.sl(1, "hit_sec", "On-Hit Cooldown", 10, 5, ConfigManager::getOnHitCooldownSec, ConfigManager::setOnHitCooldownSec, "How long AutoEat waits after getting hit."));
        for (ToggleCtl t : this.toggles) {
            t.btn = new AutoEatConfigScreen.ShaderStyleButton(0, 0, 140, 16, t.label(), b -> {
                t.value = !t.value;
                b.m_93666_(t.label());
                this.click();
            }, true);
        }
        this.layout();
    }

    private ToggleCtl tg(int col, String id, String title, BooleanSupplier g, Consumer<Boolean> s, String tip) {
        return new ToggleCtl(new ToggleSpec(id, title, g, s, tip), col);
    }

    private SliderCtl sl(int col, String id, String title, int max, int def, IntSupplier g, IntConsumer set, String tip) {
        return new SliderCtl(new SliderSpec(id, title, max, def, g, set, tip), col);
    }

    public void m_86600_() {
        if (this.statusTicks > 0) {
            --this.statusTicks;
        }
        if (this.hoverTicks > 0) {
            --this.hoverTicks;
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        String hid;
        this.m_280273_(g);
        int cx = this.f_96543_ / 2;
        g.m_280653_(this.f_96547_, this.f_96539_, cx, 12, -1);
        MutableComponent mutableComponent = Component.m_237113_((String)"Pro Controls");
        Objects.requireNonNull(this.f_96547_);
        g.m_280653_(this.f_96547_, (Component)mutableComponent, cx, 12 + 9 + 2, -4144960);
        this.layout();
        g.m_280588_(this.contentLeft, this.contentTop, this.contentRight, this.contentBottom);
        for (ToggleCtl t : this.toggles) {
            if (!this.insideContent(t.btn.m_252754_(), t.btn.m_252907_(), t.btn.m_5711_(), t.btn.m_93694_())) continue;
            t.btn.m_88315_(g, mouseX, mouseY, delta);
        }
        for (SliderCtl s : this.sliders) {
            this.drawSlider(g, s);
        }
        g.m_280618_();
        super.m_88315_(g, mouseX, mouseY, delta);
        if (this.statusTicks > 0 && !this.statusMsg.isEmpty()) {
            float f = 1.0f - (float)Math.pow(1.0f - (float)this.statusTicks / 70.0f, 3.0);
            int aBg = (int)(204.0f * f);
            int aTx = (int)(255.0f * f);
            int pad = 6;
            int w = this.f_96547_.m_92895_(this.statusMsg) + pad * 2;
            int h = 14;
            int x0 = this.f_96543_ - w - 12;
            int y0 = 12;
            g.m_280509_(x0, y0, x0 + w, y0 + h, aBg << 24);
            g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.statusMsg), x0 + w / 2, y0 + 3, aTx << 24 | 0xFFFFFF);
        }
        if (!(hid = this.hoverId(mouseX, mouseY)).equals(this.hoveredId)) {
            this.hoveredId = hid;
            this.hoverTicks = 0;
        }
        if (!this.hoveredId.isEmpty()) {
            ++this.hoverTicks;
            if (this.hoverTicks >= 8) {
                this.drawTooltip(g, mouseX, mouseY, this.tooltip(this.hoveredId));
            }
        }
    }

    private void layout() {
        int totalW = 292;
        int leftX = (this.contentLeft + this.contentRight - totalW) / 2;
        int rightX = leftX + 140 + 12;
        int yL = this.contentTop + 2 - (int)this.scrollY;
        int yR = this.contentTop + 2 - (int)this.scrollY;
        for (ToggleCtl t : this.toggles) {
            if (t.col != 0) continue;
            AutoEatAdvancedScreen.posBtn(t.btn, leftX, yL);
            yL += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 0) continue;
            AutoEatAdvancedScreen.posSl(s, leftX, yL);
            yL += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 1 || !s.spec.id().equals("panic")) continue;
            AutoEatAdvancedScreen.posSl(s, rightX, yR);
            yR += 22;
        }
        for (ToggleCtl t : this.toggles) {
            if (t.col != 1) continue;
            AutoEatAdvancedScreen.posBtn(t.btn, rightX, yR);
            yR += 22;
        }
        for (SliderCtl s : this.sliders) {
            if (s.col != 1 || s.spec.id().equals("panic")) continue;
            AutoEatAdvancedScreen.posSl(s, rightX, yR);
            yR += 22;
        }
        this.contentHeight = Math.max(yL, yR) + (int)this.scrollY - this.contentTop + 6;
    }

    private void drawSlider(GuiGraphics g, SliderCtl s) {
        int x = s.x;
        int y = s.y;
        int w = s.w;
        int h = s.h;
        if (!this.insideContent(x, y, w, h)) {
            return;
        }
        g.m_280509_(x, y, x + w, y + h, 0x66000000);
        g.m_280637_(x, y, w, h, -1);
        int pad = 2;
        int knobW = 4;
        int knobH = Math.max(6, h - 4);
        int kx = x + pad + (int)Math.round((double)s.value / (double)Math.max(1, s.spec.max()) * (double)(w - knobW - pad * 2));
        int ky = y + pad;
        g.m_280509_(kx, ky, kx + knobW, ky + knobH, -1052689);
        g.m_280637_(kx, ky, knobW, knobH, -1);
        String label = s.label();
        int tw = this.f_96547_.m_92895_(label);
        Objects.requireNonNull(this.f_96547_);
        int ty = y + (h - 9) / 2 + 1;
        g.m_280056_(this.f_96547_, label, x + (w - tw) / 2, ty, -1, true);
    }

    public boolean m_6050_(double mx, double my, double delta) {
        if (mx >= (double)this.contentLeft && mx <= (double)this.contentRight && my >= (double)this.contentTop && my <= (double)this.contentBottom) {
            int viewH = Math.max(0, this.contentBottom - this.contentTop);
            int maxScroll = Math.max(0, this.contentHeight - viewH);
            this.scrollY = Math.max(0.0, Math.min((double)maxScroll, this.scrollY - delta * 12.0));
            return true;
        }
        return super.m_6050_(mx, my, delta);
    }

    public boolean m_6375_(double mx, double my, int button) {
        if (super.m_6375_(mx, my, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        if (!(mx >= (double)this.contentLeft && mx <= (double)this.contentRight && my >= (double)this.contentTop && my <= (double)this.contentBottom)) {
            return false;
        }
        for (ToggleCtl t : this.toggles) {
            if (!this.hit(t.btn, mx, my)) continue;
            t.btn.m_5716_(mx, my);
            return true;
        }
        for (SliderCtl s : this.sliders) {
            if (!AutoEatAdvancedScreen.inside(mx, my, s.x, s.y, s.w, s.h)) continue;
            s.dragging = true;
            s.value = AutoEatAdvancedScreen.slFromMouse(mx, s.x, s.w, s.spec.max());
            this.show(s.label());
            this.click();
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (button != 0) {
            return false;
        }
        for (SliderCtl s : this.sliders) {
            if (!s.dragging) continue;
            s.value = AutoEatAdvancedScreen.slFromMouse(mx, s.x, s.w, s.spec.max());
            this.show(s.label());
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (button == 0) {
            for (SliderCtl s : this.sliders) {
                s.dragging = false;
            }
        }
        return super.m_6348_(mx, my, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == AutoEat.getOpenSettingsKeyCode()) {
            Minecraft.m_91087_().m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void resetAll() {
        for (ToggleCtl t : this.toggles) {
            t.value = true;
            t.btn.m_93666_(t.label());
        }
        for (SliderCtl s : this.sliders) {
            s.value = s.spec.def();
        }
        this.show("Advanced reset");
    }

    private void saveAll() {
        Screen screen;
        for (ToggleCtl t : this.toggles) {
            t.spec.set().accept(t.value);
        }
        for (SliderCtl s : this.sliders) {
            s.spec.set().accept(s.value);
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_(this.parent);
        if (this.parent != null) {
            this.parent.m_6575_(mc, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
        }
        if ((screen = this.parent) instanceof AutoEatConfigScreen) {
            AutoEatConfigScreen cfg = (AutoEatConfigScreen)screen;
            cfg.showTopRightStatus("Advanced saved");
        }
    }

    private void closeParent() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_(this.parent);
    }

    private void drawTooltip(GuiGraphics g, int mouseX, int mouseY, String desc) {
        if (desc.isEmpty()) {
            return;
        }
        List wrapped = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)desc), Math.min(220, Math.max(160, this.f_96543_ / 2)));
        int textW = 0;
        for (FormattedCharSequence ot : wrapped) {
            textW = Math.max(textW, this.f_96547_.m_92724_(ot));
        }
        Objects.requireNonNull(this.f_96547_);
        int lineH = 9;
        int bodyH = wrapped.size() * lineH + Math.max(0, wrapped.size() - 1) * 2;
        int boxW = textW + 10;
        int boxH = 5 + bodyH + 5;
        int x = Math.min(Math.max(4, mouseX + 10), this.f_96543_ - 4 - boxW);
        int y = Math.min(Math.max(4, mouseY + 10), this.f_96544_ - 4 - boxH);
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        g.m_280509_(x, y, x + boxW, y + boxH, -266198230);
        g.m_280637_(x, y, boxW, boxH, -1);
        int dy = y + 5;
        for (FormattedCharSequence ot : wrapped) {
            g.m_280649_(this.f_96547_, ot, x + 5, dy, -1, false);
            dy += lineH + 2;
        }
        g.m_280168_().m_85849_();
    }

    private String hoverId(int mx, int my) {
        for (ToggleCtl t : this.toggles) {
            if (!this.hit(t.btn, mx, my)) continue;
            return t.spec.id();
        }
        for (SliderCtl s : this.sliders) {
            if (!AutoEatAdvancedScreen.inside(mx, my, s.x, s.y, s.w, s.h)) continue;
            return s.spec.id();
        }
        return "";
    }

    private String tooltip(String id) {
        for (ToggleCtl t : this.toggles) {
            if (!t.spec.id().equals(id)) continue;
            return t.spec.tip();
        }
        for (SliderCtl s : this.sliders) {
            if (!s.spec.id().equals(id)) continue;
            return s.spec.tip();
        }
        return "";
    }

    private void show(String msg) {
        this.statusMsg = msg;
        this.statusTicks = 70;
    }

    private void click() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private static void posBtn(AutoEatConfigScreen.ShaderStyleButton b, int x, int y) {
        b.m_252865_(x);
        b.m_253211_(y);
        b.m_93674_(140);
        b.setHeight(16);
    }

    private static void posSl(SliderCtl s, int x, int y) {
        s.x = x;
        s.y = y;
        s.w = 140;
        s.h = 16;
    }

    private static int slFromMouse(double mx, int x, int w, int max) {
        int pad = 2;
        int knobW = 4;
        double tx = (double)(x + pad) + (double)knobW / 2.0;
        double tw = (double)(w - knobW) - (double)pad * 2.0;
        double t = (mx - tx) / Math.max(1.0, tw);
        return (int)Math.round(Math.max(0.0, Math.min(1.0, t)) * (double)max);
    }

    private static int clamp0(int max, int v) {
        return Math.max(0, Math.min(max, v));
    }

    private static boolean inside(double mx, double my, int x, int y, int w, int h) {
        return mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + h);
    }

    private boolean hit(Button b, double mx, double my) {
        return AutoEatAdvancedScreen.inside(mx, my, b.m_252754_(), b.m_252907_(), b.m_5711_(), b.m_93694_()) && this.insideContent(b.m_252754_(), b.m_252907_(), b.m_5711_(), b.m_93694_());
    }

    private boolean insideContent(int x, int y, int w, int h) {
        int ix1 = Math.max(x, this.contentLeft);
        int iy1 = Math.max(y, this.contentTop);
        int iy2 = Math.min(y + h, this.contentBottom);
        int ix2 = Math.min(x + w, this.contentRight);
        return ix2 > ix1 && iy2 > iy1;
    }

    private static class ToggleCtl {
        final ToggleSpec spec;
        final int col;
        boolean value;
        AutoEatConfigScreen.ShaderStyleButton btn;

        ToggleCtl(ToggleSpec s, int col) {
            this.spec = s;
            this.col = col;
            this.value = s.get.getAsBoolean();
        }

        Component label() {
            return Component.m_237113_((String)(this.spec.title() + ": " + (this.value ? "ON" : "OFF")));
        }
    }

    private static class SliderCtl {
        final SliderSpec spec;
        final int col;
        int x;
        int y;
        int w;
        int h;
        int value;
        boolean dragging;

        SliderCtl(SliderSpec s, int col) {
            this.spec = s;
            this.col = col;
            this.value = AutoEatAdvancedScreen.clamp0(s.max, s.get.getAsInt());
        }

        String label() {
            return this.spec.title() + (this.spec.id.endsWith("sec") ? ": " + this.value + "s" : ": " + this.value);
        }
    }

    private record ToggleSpec(String id, String title, BooleanSupplier get, Consumer<Boolean> set, String tip) {
    }

    private record SliderSpec(String id, String title, int max, int def, IntSupplier get, IntConsumer set, String tip) {
    }
}

