/*
 * Decompiled with CFR 0.152.
 */
package net.zynwro.autoeat;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.zynwro.autoeat.AutoEat;
import net.zynwro.autoeat.AutoEatAdvancedScreen;
import net.zynwro.autoeat.ConfigManager;

@ParametersAreNonnullByDefault
public class AutoEatConfigScreen
extends Screen {
    private static final int PADDING = 12;
    private static final int ROW_H = 18;
    private static final String SUBTITLE = "Food List \u2014 \"Yes\" means Block";
    private static final int SEARCH_NUDGE_X = 2;
    private static final int SEARCH_NUDGE_Y = 1;
    private static final int SEARCH_TEXT_NUDGE_DOWN = 4;
    private static final String SEARCH_ICON = "\ud83d\udd0d";
    private static final int SEARCH_ICON_LEFT_PAD = 6;
    private static final int SEARCH_ICON_GAP = 4;
    private static final int FILTER_SHIFT_LEFT = 2;
    private static final int FILTER_SPACING = 4;
    private static final int FILTER_SIDE_PAD = 6;
    private static final int FILTER_GROUP_NUDGE_X = 4;
    private static final int RIGHT_TEXT_SAFE_PAD = 1;
    private static final int CARET_HARD_STOP_MARGIN = 0;
    private static final int FOOTER_BTN_H = 16;
    private ShaderStyleButton btnAll;
    private ShaderStyleButton btnDanger;
    private ShaderStyleButton btnSuper;
    private ShaderStyleButton btnNormal;
    private ShaderStyleButton btnMassToggle;
    private ShaderStyleButton btnDonate;
    private ShaderStyleButton btnDonateClose;
    private ShaderStyleButton btnHelp;
    private boolean helpOpen = false;
    private boolean prevSearchFocused = false;
    private boolean prevSearchFocusedReset = false;
    private int helpX;
    private int helpY;
    private int helpW;
    private int helpH;
    private ShaderStyleButton btnHelpClose;
    private double helpScrollY = 0.0;
    private int helpTextH = 0;
    private List<FormattedCharSequence> helpLines = Collections.emptyList();
    private boolean helpDraggingScrollbar = false;
    private int helpDragBarOffsetY = 0;
    private EditBox searchField;
    private Filter filter = Filter.ALL;
    private double scrollY = 0.0;
    private int contentHeight;
    private boolean draggingScrollbar = false;
    private int dragBarOffsetY = 0;
    private int filterFadeTicks = 0;
    private static final int FILTER_FADE_MAX = 12;
    private int pressedFlashTicks = 0;
    private static final int PRESSED_FLASH_MAX = 8;
    private Filter lastPressedFilter = Filter.ALL;
    private String statusMsg = "";
    private int statusTicks = 0;
    private static final int TOAST_MAX_TICKS = 70;
    private boolean confirmResetOpen = false;
    private int modalX;
    private int modalY;
    private int modalW;
    private int modalH;
    private ShaderStyleButton btnConfirmYes;
    private ShaderStyleButton btnConfirmNo;
    private final List<Entry> allEntries = new ArrayList<Entry>();
    private List<Entry> visibleEntries = new ArrayList<Entry>();
    private boolean showDonate = true;
    private static final Set<Item> DANGER = Set.of(Items.f_42583_, Items.f_42591_, Items.f_42675_, Items.f_42529_, Items.f_42718_, Items.f_42581_, Items.f_42730_);
    private static final Set<Item> SUPER = Set.of(Items.f_42436_, Items.f_42437_, Items.f_42677_, Items.f_42699_);
    private int searchInnerPadLeft;
    private int searchTextYOffset;

    public AutoEatConfigScreen() {
        super((Component)Component.m_237113_((String)"AutoEat Settings"));
    }

    protected void m_7856_() {
        int btnH = 16;
        int spacing = 4;
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        int rowY = 12 + 9 + 2 + 9 + 6;
        int rightEdge = this.f_96543_ - 12;
        int searchX = 12;
        int computed = rightEdge - searchX - 300;
        int searchW = Math.max(60, computed);
        int iconW = this.f_96547_.m_92895_(SEARCH_ICON);
        this.searchInnerPadLeft = 6 + iconW + 4;
        this.searchTextYOffset = 4;
        this.searchField = new EditBox(this.f_96547_, searchX + 2 + this.searchInnerPadLeft, rowY + 1 + this.searchTextYOffset, Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0), 16, (Component)Component.m_237113_((String)"Search\u2026"));
        this.searchField.m_257771_((Component)Component.m_237113_((String)"Search\u2026"));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(Integer.MAX_VALUE);
        this.searchField.m_94151_(s -> this.refreshVisible());
        this.m_142416_((GuiEventListener)this.searchField);
        int lblAll = this.f_96547_.m_92895_("All");
        int lblDanger = this.f_96547_.m_92895_("Danger");
        int lblSuper = this.f_96547_.m_92895_("Super");
        int lblNormal = this.f_96547_.m_92895_("Normal");
        int lblBlock = this.f_96547_.m_92895_("Block All");
        int lblAllow = this.f_96547_.m_92895_("Allow All");
        int wBtn = Math.max(Math.max(Math.max(lblAll, lblDanger), Math.max(lblSuper, lblNormal)), Math.max(lblBlock, lblAllow)) + 12;
        int groupW = wBtn * 5 + 16;
        int minSearchW = 60;
        int maxSearchW = Math.max(minSearchW, rightEdge - searchX - groupW - 4 - 2);
        if (searchW > maxSearchW) {
            searchW = maxSearchW;
            this.searchField.m_93674_(Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0));
            this.searchField.m_252865_(searchX + 2 + this.searchInnerPadLeft);
        }
        int xStart = searchX + searchW + 4 - 2 + 6 + 4;
        int step = wBtn + 4;
        int filterY = rowY + 1;
        this.btnAll = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xStart, filterY, wBtn, 16, (Component)Component.m_237113_((String)"All"), b -> this.onFilterPressed(Filter.ALL), true));
        this.btnDanger = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xStart + step, filterY, wBtn, 16, (Component)Component.m_237113_((String)"Danger"), b -> this.onFilterPressed(Filter.DANGER), true));
        this.btnSuper = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xStart + step * 2, filterY, wBtn, 16, (Component)Component.m_237113_((String)"Super"), b -> this.onFilterPressed(Filter.SUPER), true));
        this.btnNormal = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xStart + step * 3, filterY, wBtn, 16, (Component)Component.m_237113_((String)"Normal"), b -> this.onFilterPressed(Filter.NORMAL), true));
        this.btnMassToggle = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xStart + step * 4, filterY, wBtn, 16, (Component)Component.m_237113_((String)"Block All"), b -> this.toggleMass(), true));
        int desiredGap = 6;
        int newSearchW = Math.max(minSearchW, this.btnAll.m_252754_() - desiredGap - searchX);
        if (newSearchW != searchW) {
            searchW = newSearchW;
            this.searchField.m_93674_(Math.max(10, searchW - this.searchInnerPadLeft - 2 - 1 - 0));
            this.searchField.m_252865_(searchX + 2 + this.searchInnerPadLeft);
        }
        int fullW = this.f_96543_;
        int bottomY = this.f_96544_ - 12 - 16;
        int fullWButtons = 66;
        int bottomGap = 6;
        int footerW = fullWButtons * 3 + bottomGap * 2;
        int bottomX = Math.floorDiv(fullW - footerW, 2);
        this.m_142416_((GuiEventListener)new ShaderStyleButton(bottomX, bottomY, fullWButtons, 16, (Component)Component.m_237113_((String)"Cancel"), b -> {
            this.onCancel();
            this.playClickSound();
        }, true));
        this.m_142416_((GuiEventListener)new ShaderStyleButton(bottomX + fullWButtons + bottomGap, bottomY, fullWButtons, 16, (Component)Component.m_237113_((String)"Reset"), b -> this.openResetConfirm(), true));
        this.m_142416_((GuiEventListener)new ShaderStyleButton(bottomX + (fullWButtons + bottomGap) * 2, bottomY, fullWButtons, 16, (Component)Component.m_237113_((String)"Done"), b -> this.onDone(), true));
        int helpXRight = this.f_96543_ - 12 - 16;
        this.btnHelp = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(helpXRight, bottomY, 16, 16, (Component)Component.m_237113_((String)"\ud83d\udcd8"), b -> this.openHelp(), true));
        int advW = 68;
        int advX = this.btnHelp.m_252754_() - 1 - advW;
        this.m_142416_((GuiEventListener)new ShaderStyleButton(advX, bottomY, advW, 16, (Component)Component.m_237113_((String)"Advanced"), b -> this.openAdvanced(), true));
        if (this.showDonate) {
            int donateW = 64;
            int xDonate = 12;
            this.btnDonate = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xDonate, bottomY, donateW, 16, (Component)Component.m_237113_((String)"Donate"), b -> this.openDonate(), 0x22000000, 0x33000000, 0x55000000, -1711276033, -570425345, false, false));
            this.btnDonateClose = (ShaderStyleButton)this.m_142416_((GuiEventListener)new ShaderStyleButton(xDonate + donateW + 1, bottomY, 16, 16, (Component)Component.m_237113_((String)"X"), b -> this.closeDonate(), 0x22000000, 0x33000000, 0x55000000, -1711276033, -570425345, false, false));
        }
        this.buildEntriesFromRegistryAndConfig();
        this.setFilter(Filter.ALL);
    }

    private void openDonate() {
        try {
            Util.m_137581_().m_137648_(new URI("https://linktr.ee/zynwrodonate"));
            this.showTopRightStatus("Opening browser\u2026");
        }
        catch (Exception ignored) {
            this.showTopRightStatus("Failed to open browser");
        }
    }

    private void closeDonate() {
        this.showDonate = false;
        if (this.btnDonate != null) {
            this.btnDonate.f_93624_ = false;
        }
        if (this.btnDonateClose != null) {
            this.btnDonateClose.f_93624_ = false;
        }
    }

    private void openAdvanced() {
        if (this.searchField != null) {
            this.searchField.m_93692_(false);
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new AutoEatAdvancedScreen(this));
    }

    private void openHelp() {
        this.helpOpen = true;
        boolean bl = this.prevSearchFocused = this.searchField != null && this.searchField.m_93696_();
        if (this.searchField != null) {
            this.searchField.m_93692_(false);
        }
        int innerPad = 14;
        int maxW = Math.max(320, this.f_96543_ - 24);
        int maxH = Math.max(180, this.f_96544_ - 24);
        this.helpW = Math.min(maxW, Math.max(320, (int)((double)this.f_96543_ * 0.78)));
        this.helpH = Math.min(maxH, Math.max(200, (int)((double)this.f_96544_ * 0.72)));
        String body = AutoEatConfigScreen.readGuideText();
        int scrollbarReserve = 10;
        int wrapMax = Math.max(220, this.helpW - innerPad * 2 - scrollbarReserve);
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        for (String line : body.split("\n", -1)) {
            if (line.isEmpty()) {
                lines.add(FormattedCharSequence.f_13691_);
                continue;
            }
            lines.addAll(this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)line), wrapMax));
        }
        this.helpLines = lines;
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.helpX = cx - this.helpW / 2;
        this.helpY = cy - this.helpH / 2;
        int btnW = Math.min(120, Math.max(90, this.helpW / 4));
        int yBtn = this.helpY + this.helpH - 14 - 16;
        this.btnHelpClose = new ShaderStyleButton(this.helpX + (this.helpW - btnW) / 2, yBtn, btnW, 16, (Component)Component.m_237113_((String)"Close"), b -> this.closeHelp(), -2143270313, -1605675418, -1070976452, -1, -1, true, true);
        Objects.requireNonNull(this.f_96547_);
        int lineH = 9 + 4;
        this.helpTextH = this.helpLines.size() * lineH;
        this.helpScrollY = 0.0;
    }

    private void closeHelp() {
        this.helpOpen = false;
        if (this.searchField != null) {
            if (this.prevSearchFocused) {
                this.m_7522_((GuiEventListener)this.searchField);
                this.searchField.m_93692_(true);
            } else {
                this.searchField.m_93692_(false);
            }
        }
        this.btnHelpClose = null;
        this.helpLines = Collections.emptyList();
        this.helpScrollY = 0.0;
        this.helpTextH = 0;
        this.helpDraggingScrollbar = false;
        this.helpDragBarOffsetY = 0;
    }

    public void showTopRightStatus(String msg) {
        this.statusMsg = msg;
        this.statusTicks = 70;
    }

    private void toggleMass() {
        boolean block = !this.areAllBlacklisted(this.visibleEntries);
        int affected = 0;
        for (Entry e : this.visibleEntries) {
            if (e.blacklisted == block) continue;
            e.blacklisted = block;
            ++affected;
        }
        this.btnMassToggle.m_93666_((Component)Component.m_237113_((String)(block ? "Allow All" : "Block All")));
        this.showTopRightStatus((block ? "Blocked " : "Allowed ") + affected + " items");
        this.playClickSound();
    }

    private void onFilterPressed(Filter target) {
        if (this.filter == target) {
            this.setFilter(Filter.ALL);
        } else {
            this.lastPressedFilter = target;
            this.setFilter(target);
            this.pressedFlashTicks = 8;
        }
        this.playClickSound();
    }

    private void setFilter(Filter f) {
        this.filter = f;
        this.refreshVisible();
        this.filterFadeTicks = 12;
    }

    private boolean isDrink(Item it) {
        return it == Items.f_42787_;
    }

    private void buildEntriesFromRegistryAndConfig() {
        this.allEntries.clear();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            FoodProperties fp = new ItemStack((ItemLike)item).getFoodProperties(null);
            if (fp == null || this.isDrink(item)) continue;
            String key = item.m_5524_();
            boolean blacklisted = ConfigManager.isBlacklisted(key);
            ItemStack stack = new ItemStack((ItemLike)item);
            String display = Component.m_237115_((String)item.m_5524_()).getString();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            String ns = id != null ? id.m_135827_() : "minecraft";
            String path = id != null ? id.m_135815_() : "";
            this.allEntries.add(new Entry(stack, key, blacklisted, display, ns, path));
        }
        block1: for (Map.Entry entry : ConfigManager.blacklist.entrySet()) {
            String key = (String)entry.getKey();
            for (Item it : ForgeRegistries.ITEMS.getValues()) {
                boolean missing;
                if (!key.equals(it.m_5524_())) continue;
                FoodProperties fp = new ItemStack((ItemLike)it).getFoodProperties(null);
                if (fp == null || this.isDrink(it) || !(missing = this.allEntries.stream().noneMatch(en -> en.key.equals(key)))) continue block1;
                ItemStack stack = new ItemStack((ItemLike)it);
                String display = Component.m_237115_((String)it.m_5524_()).getString();
                ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)it);
                String ns = id != null ? id.m_135827_() : "minecraft";
                String path = id != null ? id.m_135815_() : "";
                this.allEntries.add(new Entry(stack, key, (Boolean)entry.getValue(), display, ns, path));
                continue block1;
            }
        }
        this.allEntries.sort((a, b) -> {
            int cb;
            int ca = this.categoryOrder((Entry)a);
            if (ca != (cb = this.categoryOrder((Entry)b))) {
                return Integer.compare(ca, cb);
            }
            return a.displayName.compareToIgnoreCase(b.displayName);
        });
        this.refreshVisible();
    }

    private int categoryOrder(Entry e) {
        Item i;
        Item item = i = e.stack.m_41619_() ? null : e.stack.m_41720_();
        if (i != null) {
            if (DANGER.contains(i)) {
                return 0;
            }
            if (SUPER.contains(i)) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    private boolean passFilter(Entry e) {
        if (this.filter == Filter.ALL) {
            return true;
        }
        Item i = e.stack.m_41619_() ? null : e.stack.m_41720_();
        return switch (this.filter) {
            case Filter.DANGER -> {
                if (i != null && DANGER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            case Filter.SUPER -> {
                if (i != null && SUPER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            case Filter.NORMAL -> {
                if (i != null && !DANGER.contains(i) && !SUPER.contains(i)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private void refreshVisible() {
        String q = this.searchField != null ? this.searchField.m_94155_().toLowerCase(Locale.ROOT) : "";
        this.visibleEntries = this.allEntries.stream().filter(this::passFilter).filter(e -> q.isEmpty() || this.matchesQuery((Entry)e, q)).collect(Collectors.toList());
        int rows = (this.visibleEntries.size() + 1) / 2;
        this.contentHeight = rows * 18;
        this.clampScroll();
        if (this.btnMassToggle != null) {
            this.btnMassToggle.m_93666_((Component)Component.m_237113_((String)(this.areAllBlacklisted(this.visibleEntries) ? "Allow All" : "Block All")));
        }
    }

    private static boolean entryMissing(Entry e, String term) {
        return !e.displayLower.contains(term) && !e.keyLower.contains(term) && !e.namespace.contains(term) && !e.idPath.contains(term);
    }

    private boolean matchesQuery(Entry e, String q) {
        if (q.isEmpty()) {
            return true;
        }
        block24: for (String raw : q.split("\\s+")) {
            if (raw.isEmpty()) continue;
            String t = raw.toLowerCase(Locale.ROOT);
            int i = t.indexOf(58);
            if (i > 0) {
                String key = t.substring(0, i);
                String val = t.substring(i + 1);
                switch (key) {
                    case "is": {
                        switch (val) {
                            case "blocked": 
                            case "block": 
                            case "b": {
                                if (e.blacklisted) continue block24;
                                return false;
                            }
                            case "allowed": 
                            case "allow": 
                            case "a": {
                                if (!e.blacklisted) continue block24;
                                return false;
                            }
                            default: {
                                if (!AutoEatConfigScreen.entryMissing(e, t)) continue block24;
                                return false;
                            }
                        }
                    }
                    case "mod": {
                        if (!val.isEmpty() && e.namespace.equals(val)) continue block24;
                        return false;
                    }
                    case "id": {
                        if (!val.isEmpty() && e.idPath.contains(val)) continue block24;
                        return false;
                    }
                    case "key": {
                        if (!val.isEmpty() && e.keyLower.contains(val)) continue block24;
                        return false;
                    }
                    default: {
                        if (!AutoEatConfigScreen.entryMissing(e, t)) continue block24;
                        return false;
                    }
                }
            }
            if (!AutoEatConfigScreen.entryMissing(e, t)) continue;
            return false;
        }
        return true;
    }

    private boolean areAllBlacklisted(List<Entry> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (Entry e : list) {
            if (e.blacklisted) continue;
            return false;
        }
        return true;
    }

    public void m_86600_() {
        if (this.confirmResetOpen || this.helpOpen) {
            return;
        }
        if (this.statusTicks > 0) {
            --this.statusTicks;
        }
        if (this.filterFadeTicks > 0) {
            --this.filterFadeTicks;
        }
        if (this.pressedFlashTicks > 0) {
            --this.pressedFlashTicks;
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float delta) {
        this.m_280273_(g);
        boolean prevVis = false;
        if (this.searchField != null) {
            prevVis = this.searchField.m_94213_();
            this.searchField.m_94194_(false);
        }
        super.m_88315_(g, mouseX, mouseY, delta);
        if (!this.confirmResetOpen && !this.helpOpen) {
            this.drawFilterActiveDark(g);
            this.drawFilterPressedFlash(g);
            this.drawFilterFadeHighlight(g);
        }
        int[] b = this.getListBounds();
        int mx = this.confirmResetOpen || this.helpOpen ? -10000 : mouseX;
        int my = this.confirmResetOpen || this.helpOpen ? -10000 : mouseY;
        g.m_280588_(b[0], b[1], b[2], b[3]);
        this.drawEntries(g, b[0], b[1], b[2], b[3], mx, my);
        g.m_280618_();
        this.drawScrollbar(g, b[1], b[2], b[3]);
        if (!this.confirmResetOpen && !this.helpOpen && this.visibleEntries.isEmpty()) {
            String l1 = "No matching foods found.";
            String l2 = "Using food mods? Enable \"Detect mod food\" in Advanced Settings.";
            int midX = (b[0] + b[2]) / 2;
            int n = (b[1] + b[3]) / 2;
            Objects.requireNonNull(this.f_96547_);
            int midY = n - 9;
            g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)l1), midX, midY, -1);
            MutableComponent mutableComponent = Component.m_237113_((String)l2);
            Objects.requireNonNull(this.f_96547_);
            g.m_280653_(this.f_96547_, (Component)mutableComponent, midX, midY + 9 + 4, -5592406);
        }
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 12, -1);
        Objects.requireNonNull(this.f_96547_);
        int subtitleY = 12 + 9 + 2;
        g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)SUBTITLE), this.f_96543_ / 2, subtitleY, -4144960);
        if (this.searchField != null) {
            this.searchField.m_94194_(prevVis);
            this.renderSearchBar(g, mouseX, mouseY, delta);
        }
        if (!(this.statusTicks <= 0 || this.statusMsg.isEmpty() || this.confirmResetOpen || this.helpOpen)) {
            float t = (float)this.statusTicks / 70.0f;
            float ease = 1.0f - (float)Math.pow(1.0f - t, 3.0);
            int alphaBg = (int)(204.0f * ease);
            int alphaText = (int)(255.0f * ease);
            int pad = 6;
            int textW = this.f_96547_.m_92895_(this.statusMsg);
            int w = textW + pad * 2;
            int h = 14;
            int x0 = this.f_96543_ - w - 12;
            int y0 = 12;
            int bg = alphaBg << 24;
            g.m_280509_(x0, y0, x0 + w, y0 + h, bg);
            int col = alphaText << 24 | 0xFFFFFF;
            g.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.statusMsg), x0 + w / 2, y0 + 3, col);
        }
        if (this.confirmResetOpen) {
            this.renderResetModal(g, mouseX, mouseY, delta);
        }
        if (this.helpOpen) {
            this.renderHelpModal(g, mouseX, mouseY, delta);
        }
    }

    private void renderSearchBar(GuiGraphics g, int mouseX, int mouseY, float delta) {
        if (this.searchField == null) {
            return;
        }
        int x = this.searchField.m_252754_() - this.searchInnerPadLeft;
        int y = this.searchField.m_252907_() - 4;
        int w = this.searchField.m_5711_() + this.searchInnerPadLeft + 2 + 1 + 0;
        int h = this.searchField.m_93694_();
        int bg = -2144191674;
        g.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, bg);
        g.m_280637_(x, y, w, h, -1);
        Objects.requireNonNull(this.f_96547_);
        int offsetY = (h - 9) / 2 + 2;
        int iconX = x + 6;
        int iconY = y + offsetY - 1;
        g.m_280488_(this.f_96547_, SEARCH_ICON, iconX, iconY, -1325400065);
        this.clipToWidgetRightSlack(g, this.searchField);
        this.searchField.m_88315_(g, mouseX, mouseY, delta);
        g.m_280618_();
    }

    private void drawFilterActiveDark(GuiGraphics g) {
        ShaderStyleButton targetBtn;
        switch (this.filter) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case DANGER: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case SUPER: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case NORMAL: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        int x = targetBtn.m_252754_();
        int y = targetBtn.m_252907_();
        int w = targetBtn.m_5711_();
        int h = targetBtn.m_93694_();
        g.m_280509_(x + 2, y + 2, x + w - 2, y + h - 2, 0x77000000);
    }

    private void drawFilterPressedFlash(GuiGraphics g) {
        ShaderStyleButton targetBtn;
        if (this.pressedFlashTicks <= 0) {
            return;
        }
        switch (this.lastPressedFilter) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case DANGER: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case SUPER: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case NORMAL: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        float t = (float)this.pressedFlashTicks / 8.0f;
        int alpha = (int)(102.0f * t);
        int rgb = switch (this.lastPressedFilter) {
            case Filter.DANGER -> 16734778;
            case Filter.SUPER -> 3842559;
            case Filter.NORMAL -> 5163391;
            default -> 0xAAAAAA;
        };
        int color = alpha << 24 | rgb;
        int x = targetBtn.m_252754_();
        int y = targetBtn.m_252907_();
        int w = targetBtn.m_5711_();
        int h = targetBtn.m_93694_();
        g.m_280509_(x + 2, y + 2, x + w - 2, y + h - 2, color);
    }

    private void drawFilterFadeHighlight(GuiGraphics g) {
        ShaderStyleButton targetBtn;
        if (this.filterFadeTicks <= 0) {
            return;
        }
        switch (this.filter) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                ShaderStyleButton shaderStyleButton = this.btnAll;
                break;
            }
            case DANGER: {
                ShaderStyleButton shaderStyleButton = this.btnDanger;
                break;
            }
            case SUPER: {
                ShaderStyleButton shaderStyleButton = this.btnSuper;
                break;
            }
            case NORMAL: {
                ShaderStyleButton shaderStyleButton = targetBtn = this.btnNormal;
            }
        }
        if (targetBtn == null) {
            return;
        }
        float t = (float)this.filterFadeTicks / 12.0f;
        int alpha = (int)(85.0f * t);
        int color = alpha << 24 | 0xFFFFFF;
        int x = targetBtn.m_252754_();
        int y = targetBtn.m_252907_();
        int w = targetBtn.m_5711_();
        int h = targetBtn.m_93694_();
        g.m_280509_(x + 1, y + 1, x + w - 1, y + h - 1, color);
    }

    private void renderHelpModal(GuiGraphics g, int mouseX, int mouseY, float delta) {
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1342177280);
        int innerPad = 14;
        g.m_280509_(this.helpX + 3, this.helpY + 4, this.helpX + this.helpW + 3, this.helpY + this.helpH + 4, 0x22000000);
        g.m_280509_(this.helpX, this.helpY, this.helpX + this.helpW, this.helpY + this.helpH, -300014806);
        g.m_280637_(this.helpX, this.helpY, this.helpW, this.helpH, -1);
        Objects.requireNonNull(this.f_96547_);
        int titleBarH = 9 + 10;
        g.m_280509_(this.helpX + 1, this.helpY + 1, this.helpX + this.helpW - 1, this.helpY + titleBarH, 858666818);
        g.m_280509_(this.helpX + 1, this.helpY + titleBarH, this.helpX + this.helpW - 1, this.helpY + titleBarH + 1, 0x44FFFFFF);
        String title = "\ud83d\udcd8 AutoEat Guide";
        int titleW = this.f_96547_.m_92895_(title);
        int titleX = this.helpX + (this.helpW - titleW) / 2;
        Objects.requireNonNull(this.f_96547_);
        int yTop = this.helpY + (titleBarH - 9) / 2 + 1;
        g.m_280488_(this.f_96547_, title, titleX, yTop, -1);
        int vpX1 = this.helpX + innerPad;
        int vpY1 = this.helpY + titleBarH + 8;
        int vpX2 = this.helpX + this.helpW - innerPad;
        int vpY2 = this.btnHelpClose != null ? this.btnHelpClose.m_252907_() - 10 : this.helpY + this.helpH - innerPad - 20;
        g.m_280509_(vpX1 - 1, vpY1 - 1, vpX2 + 1, vpY2 + 1, 0x22000000);
        g.m_280637_(vpX1 - 1, vpY1 - 1, vpX2 - vpX1 + 2, vpY2 - vpY1 + 2, 0x55FFFFFF);
        g.m_280588_(vpX1, vpY1, vpX2, vpY2);
        Objects.requireNonNull(this.f_96547_);
        int lineH = 9 + 4;
        int y = vpY1 - (int)this.helpScrollY;
        for (FormattedCharSequence ot : this.helpLines) {
            g.m_280648_(this.f_96547_, ot, vpX1, y, -520093697);
            y += lineH;
        }
        g.m_280618_();
        if (this.btnHelpClose != null) {
            this.btnHelpClose.m_88315_(g, mouseX, mouseY, delta);
        }
        int vpH = Math.max(0, vpY2 - vpY1);
        int maxScroll = Math.max(0, this.helpTextH - vpH);
        if (this.helpScrollY < 0.0) {
            this.helpScrollY = 0.0;
        }
        if (this.helpScrollY > (double)maxScroll) {
            this.helpScrollY = maxScroll;
        }
        int trackX = vpX2 - 6;
        g.m_280509_(trackX, vpY1, trackX + 3, vpY2, 0x33000000);
        if (this.helpTextH > vpH) {
            float pct = (float)(this.helpScrollY / (double)(this.helpTextH - vpH));
            int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
            int barY = vpY1 + (int)((float)(vpH - barH) * pct);
            g.m_280509_(trackX, barY, trackX + 3, barY + barH, 0x66FFFFFF);
        }
        g.m_280168_().m_85849_();
    }

    private void openResetConfirm() {
        this.confirmResetOpen = true;
        boolean bl = this.prevSearchFocusedReset = this.searchField != null && this.searchField.m_93696_();
        if (this.searchField != null) {
            this.searchField.m_93692_(false);
        }
        int maxW = Math.min(300, this.f_96543_ - 24);
        int innerPad = 14;
        String title = "Reset to defaults?";
        String msg = "Restore defaults. Dangerous items will be blocked.";
        List wrapped = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)msg), Math.max(220, maxW - innerPad * 4));
        int longest = Math.max(this.f_96547_.m_92895_(title), wrapped.stream().mapToInt(arg_0 -> ((Font)this.f_96547_).m_92724_(arg_0)).max().orElse(0));
        this.modalW = Math.max(260, Math.min(maxW, longest + innerPad * 3));
        Objects.requireNonNull(this.f_96547_);
        int titleH = 9;
        Objects.requireNonNull(this.f_96547_);
        int lineH = 9 + 3;
        int linesH = Math.max(lineH, wrapped.size() * lineH);
        int buttonsBlock = 26;
        this.modalH = innerPad + titleH + 8 + linesH + 10 + buttonsBlock + innerPad;
        int cx = this.f_96543_ / 2;
        int cy = this.f_96544_ / 2;
        this.modalX = cx - this.modalW / 2;
        this.modalY = cy - this.modalH / 2;
        int btnW = 110;
        int gap = 12;
        int yBtn = this.modalY + this.modalH - innerPad - 16;
        this.btnConfirmYes = new ShaderStyleButton(cx - btnW - gap / 2, yBtn, btnW, 16, (Component)Component.m_237113_((String)"Reset"), b -> {
            this.doReset();
            this.closeResetConfirm();
            this.playClickSound();
        }, -864408018, -527812809, -262394322, -1, -1, true, true);
        this.btnConfirmNo = new ShaderStyleButton(cx + gap / 2, yBtn, btnW, 16, (Component)Component.m_237113_((String)"Cancel"), b -> {
            this.closeResetConfirm();
            this.playClickSound();
        }, -2143270313, -1605675418, -1070976452, -1, -1, true, true);
    }

    private void closeResetConfirm() {
        this.confirmResetOpen = false;
        if (this.searchField != null) {
            if (this.prevSearchFocusedReset) {
                this.m_7522_((GuiEventListener)this.searchField);
                this.searchField.m_93692_(true);
            } else {
                this.searchField.m_93692_(false);
            }
        }
        this.btnConfirmYes = null;
        this.btnConfirmNo = null;
    }

    private void doReset() {
        for (Entry e : this.allEntries) {
            Item it = e.stack.m_41619_() ? null : e.stack.m_41720_();
            e.blacklisted = it != null && DANGER.contains(it);
        }
        this.refreshVisible();
        this.showTopRightStatus("Defaults restored");
    }

    private void renderResetModal(GuiGraphics g, int mouseX, int mouseY, float delta) {
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        g.m_280509_(0, 0, this.f_96543_, this.f_96544_, -1342177280);
        g.m_280509_(this.modalX + 2, this.modalY + 3, this.modalX + this.modalW + 2, this.modalY + this.modalH + 3, 0x33000000);
        g.m_280509_(this.modalX, this.modalY, this.modalX + this.modalW, this.modalY + this.modalH, -300014806);
        g.m_280637_(this.modalX, this.modalY, this.modalW, this.modalH, -1);
        String title = "Reset to defaults?";
        int titleW = this.f_96547_.m_92895_(title);
        int innerPad = 16;
        int cx = this.modalX + this.modalW / 2;
        int y = this.modalY + innerPad;
        g.m_280488_(this.f_96547_, title, cx - titleW / 2, y, -1);
        String msg = "Restore defaults. Dangerous items will be blocked.";
        List lines = this.f_96547_.m_92923_((FormattedText)Component.m_237113_((String)msg), this.modalW - innerPad * 2);
        Objects.requireNonNull(this.f_96547_);
        y += 9 + 8;
        for (FormattedCharSequence ot : lines) {
            int lw = this.f_96547_.m_92724_(ot);
            g.m_280648_(this.f_96547_, ot, cx - lw / 2, y, -520093697);
            Objects.requireNonNull(this.f_96547_);
            y += 9 + 3;
        }
        if (this.btnConfirmYes != null) {
            this.btnConfirmYes.m_88315_(g, mouseX, mouseY, delta);
        }
        if (this.btnConfirmNo != null) {
            this.btnConfirmNo.m_88315_(g, mouseX, mouseY, delta);
        }
        g.m_280168_().m_85849_();
    }

    public boolean m_6050_(double mx, double my, double delta) {
        if (this.helpOpen) {
            int vpY2;
            int innerPad = 14;
            Objects.requireNonNull(this.f_96547_);
            int titleBarH = 9 + 10;
            int vpX1 = this.helpX + innerPad;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpX2 = this.helpX + this.helpW - innerPad;
            int n = vpY2 = this.btnHelpClose != null ? this.btnHelpClose.m_252907_() - 10 : this.helpY + this.helpH - innerPad - 20;
            if (mx >= (double)vpX1 && mx <= (double)vpX2 && my >= (double)vpY1 && my <= (double)vpY2) {
                int vpH = Math.max(0, vpY2 - vpY1);
                int maxScroll = Math.max(0, this.helpTextH - vpH);
                this.helpScrollY -= delta * 12.0;
                if (this.helpScrollY < 0.0) {
                    this.helpScrollY = 0.0;
                }
                if (this.helpScrollY > (double)maxScroll) {
                    this.helpScrollY = maxScroll;
                }
                return true;
            }
            return true;
        }
        if (this.confirmResetOpen) {
            return true;
        }
        int[] b = this.getListBounds();
        if (mx >= (double)b[0] && mx <= (double)b[2] && my >= (double)b[1] && my <= (double)b[3]) {
            this.scrollY -= delta * 12.0;
            this.clampScroll();
            return true;
        }
        return super.m_6050_(mx, my, delta);
    }

    public boolean m_6375_(double mx, double my, int button) {
        int[] bounds;
        boolean inList;
        if (this.helpOpen) {
            int vpY2;
            int innerPad = 14;
            Objects.requireNonNull(this.f_96547_);
            int titleBarH = 9 + 10;
            int vpX1 = this.helpX + innerPad;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpX2 = this.helpX + this.helpW - innerPad;
            int n = vpY2 = this.btnHelpClose != null ? this.btnHelpClose.m_252907_() - 10 : this.helpY + this.helpH - innerPad - 20;
            if (this.btnHelpClose != null && AutoEatConfigScreen.hit(this.btnHelpClose, mx, my)) {
                this.btnHelpClose.m_5716_(mx, my);
                return true;
            }
            int vpH = Math.max(0, vpY2 - vpY1);
            if (this.helpTextH > vpH) {
                int trackX = vpX2 - 6;
                int sbX2 = trackX + 3;
                float pct = (float)(this.helpScrollY / (double)(this.helpTextH - vpH));
                int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
                int barY = vpY1 + (int)((float)(vpH - barH) * pct);
                if (mx >= (double)trackX && mx < (double)sbX2) {
                    if (my >= (double)barY && my < (double)(barY + barH)) {
                        this.helpDraggingScrollbar = true;
                        this.helpDragBarOffsetY = (int)(my - (double)barY);
                        return true;
                    }
                    if (my >= (double)vpY1 && my < (double)vpY2) {
                        int newBarTop = (int)my - barH / 2;
                        if (newBarTop < vpY1) {
                            newBarTop = vpY1;
                        }
                        if (newBarTop > vpY2 - barH) {
                            newBarTop = vpY2 - barH;
                        }
                        float t = (float)(newBarTop - vpY1) / (float)(vpH - barH);
                        this.helpScrollY = t * (float)(this.helpTextH - vpH);
                        return true;
                    }
                }
            }
            return true;
        }
        if (this.confirmResetOpen) {
            if (this.btnConfirmYes != null && AutoEatConfigScreen.hit(this.btnConfirmYes, mx, my)) {
                this.btnConfirmYes.m_5716_(mx, my);
                return true;
            }
            if (this.btnConfirmNo != null && AutoEatConfigScreen.hit(this.btnConfirmNo, mx, my)) {
                this.btnConfirmNo.m_5716_(mx, my);
                return true;
            }
            return true;
        }
        int[] b = this.getListBounds();
        Scrollbar sb = this.getScrollbar(b[1], b[2], b[3]);
        if (this.contentHeight > b[3] - b[1] && mx >= (double)sb.x && mx < (double)(sb.x + sb.w)) {
            if (my >= (double)sb.y && my < (double)(sb.h + sb.y)) {
                this.draggingScrollbar = true;
                this.dragBarOffsetY = (int)(my - (double)sb.y);
                return true;
            }
            if (my >= (double)b[1] && my < (double)b[3]) {
                this.jumpScrollbar(my, b, sb);
                return true;
            }
        }
        if (super.m_6375_(mx, my, button)) {
            return true;
        }
        if (this.searchField != null) {
            boolean insideText;
            int textLeft = this.searchField.m_252754_();
            int textRight = textLeft + this.searchField.m_5711_();
            int textTop = this.searchField.m_252907_();
            int textBottom = textTop + this.searchField.m_93694_();
            boolean bl = insideText = mx >= (double)textLeft && mx < (double)textRight && my >= (double)textTop && my < (double)textBottom;
            if (!insideText && this.searchField.m_93696_()) {
                this.searchField.m_93692_(false);
            }
        }
        boolean bl = inList = mx >= (double)(bounds = this.getListBounds())[0] && mx < (double)bounds[2] && my >= (double)bounds[1] && my < (double)bounds[3];
        if (!inList) {
            return false;
        }
        int left = bounds[0];
        int top = bounds[1];
        int right = bounds[2];
        int bottom = bounds[3];
        int colGap = 8;
        int colW = (right - left - colGap) / 2;
        int startY = top - (int)this.scrollY;
        int rows = (this.visibleEntries.size() + 1) / 2;
        for (int row = 0; row < rows; ++row) {
            int y = startY + row * 18;
            if (y + 18 <= top || y >= bottom) continue;
            int idxL = row * 2;
            if (idxL < this.visibleEntries.size() && this.handleCellClick(this.visibleEntries.get(idxL), left, y, colW, mx, my, button)) {
                return true;
            }
            int idxR = row * 2 + 1;
            if (idxR >= this.visibleEntries.size() || !this.handleCellClick(this.visibleEntries.get(idxR), left + colW + colGap, y, colW, mx, my, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (this.confirmResetOpen) {
            return true;
        }
        if (this.helpOpen) {
            this.helpDraggingScrollbar = false;
            return true;
        }
        this.draggingScrollbar = false;
        return super.m_6348_(mx, my, button);
    }

    public boolean m_7979_(double mx, double my, int button, double dx, double dy) {
        if (this.confirmResetOpen) {
            return true;
        }
        if (this.helpOpen) {
            int innerPad = 14;
            Objects.requireNonNull(this.f_96547_);
            int titleBarH = 9 + 10;
            int vpY1 = this.helpY + titleBarH + 8;
            int vpY2 = this.btnHelpClose != null ? this.btnHelpClose.m_252907_() - 10 : this.helpY + this.helpH - innerPad - 20;
            int vpH = Math.max(0, vpY2 - vpY1);
            if (this.helpDraggingScrollbar && this.helpTextH > vpH) {
                int barH = Math.max(22, (int)((float)vpH * ((float)vpH / (float)this.helpTextH)));
                int newBarTop = (int)my - this.helpDragBarOffsetY;
                if (newBarTop < vpY1) {
                    newBarTop = vpY1;
                }
                if (newBarTop > vpY2 - barH) {
                    newBarTop = vpY2 - barH;
                }
                float t = (float)(newBarTop - vpY1) / (float)(vpH - barH);
                this.helpScrollY = t * (float)(this.helpTextH - vpH);
                return true;
            }
            return true;
        }
        if (this.draggingScrollbar) {
            int newBarTop;
            int[] b = this.getListBounds();
            Scrollbar sb = this.getScrollbar(b[1], b[2], b[3]);
            int viewH = b[3] - b[1];
            int maxScroll = Math.max(0, this.contentHeight - viewH);
            int barTrackH = viewH - sb.h;
            if (barTrackH < 1) {
                barTrackH = 1;
            }
            if ((newBarTop = (int)my - this.dragBarOffsetY) < b[1]) {
                newBarTop = b[1];
            }
            if (newBarTop > b[1] + barTrackH) {
                newBarTop = b[1] + barTrackH;
            }
            float t = (float)(newBarTop - b[1]) / (float)barTrackH;
            this.scrollY = t * (float)maxScroll;
            this.clampScroll();
            return true;
        }
        return super.m_7979_(mx, my, button, dx, dy);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.helpOpen) {
            switch (keyCode) {
                case 256: 
                case 257: 
                case 335: {
                    this.closeHelp();
                    return true;
                }
            }
            return true;
        }
        if (this.confirmResetOpen) {
            switch (keyCode) {
                case 257: 
                case 335: {
                    if (this.btnConfirmYes != null) {
                        this.btnConfirmYes.m_5716_(0.0, 0.0);
                    }
                    return true;
                }
                case 256: {
                    if (this.btnConfirmNo != null) {
                        this.btnConfirmNo.m_5716_(0.0, 0.0);
                    }
                    return true;
                }
            }
            return true;
        }
        if (keyCode == AutoEat.getOpenSettingsKeyCode()) {
            if (!this.isTypingInSearch()) {
                Minecraft.m_91087_().m_91152_(null);
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.confirmResetOpen || this.helpOpen) {
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean isTypingInSearch() {
        return this.searchField != null && this.searchField.m_93696_();
    }

    private static boolean hit(Button b, double mx, double my) {
        return mx >= (double)b.m_252754_() && mx < (double)(b.m_252754_() + b.m_5711_()) && my >= (double)b.m_252907_() && my < (double)(b.m_252907_() + b.m_93694_());
    }

    private boolean handleCellClick(Entry e, int x, int y, int w, double mx, double my, int button) {
        if (this.confirmResetOpen || this.helpOpen) {
            return false;
        }
        if (button != 0) {
            return false;
        }
        if (!(mx >= (double)x && mx < (double)(x + w) && my >= (double)y && my < (double)(y + 18))) {
            return false;
        }
        if (e.lastBounds.contains((int)mx, (int)my)) {
            boolean bl = e.blacklisted = !e.blacklisted;
            if (this.btnMassToggle != null) {
                this.btnMassToggle.m_93666_((Component)Component.m_237113_((String)(this.areAllBlacklisted(this.visibleEntries) ? "Allow All" : "Block All")));
            }
            this.showTopRightStatus(e.blacklisted ? "Blocked 1 item" : "Allowed 1 item");
            this.playClickSound();
            return true;
        }
        return false;
    }

    private void onCancel() {
        Minecraft.m_91087_().m_91152_(null);
    }

    private void onDone() {
        for (Entry e : this.allEntries) {
            ConfigManager.set(e.key, e.blacklisted);
        }
        ConfigManager.save();
        Minecraft.m_91087_().m_91152_(null);
        this.playClickSound();
    }

    private void clipToWidgetRightSlack(GuiGraphics g, EditBox tf) {
        int lx = tf.m_252754_() - 1;
        int ty = tf.m_252907_() - 1;
        int rx = tf.m_252754_() + tf.m_5711_() + 2;
        int by = tf.m_252907_() + tf.m_93694_() + 1;
        g.m_280588_(lx, ty, rx, by);
    }

    private int[] getListBounds() {
        int left = 12;
        int right = this.f_96543_ - 12;
        int top = this.searchField.m_252907_() + this.searchField.m_93694_() - 4 + 4;
        int bottom = this.f_96544_ - 12 - 16 - 4;
        return new int[]{left, top, right, bottom};
    }

    private void clampScroll() {
        int viewH = this.getListViewHeight();
        int maxScroll = Math.max(0, this.contentHeight - viewH);
        if (this.scrollY < 0.0) {
            this.scrollY = 0.0;
        }
        if (this.scrollY > (double)maxScroll) {
            this.scrollY = maxScroll;
        }
    }

    private int getListViewHeight() {
        int[] b = this.getListBounds();
        return Math.max(0, b[3] - b[1]);
    }

    private void drawEntries(GuiGraphics g, int left, int top, int right, int bottom, int mouseX, int mouseY) {
        int colGap = 8;
        int colW = (right - left - colGap) / 2;
        int startY = top - (int)this.scrollY;
        int rows = (this.visibleEntries.size() + 1) / 2;
        for (int row = 0; row < rows; ++row) {
            int idxR;
            int y = startY + row * 18;
            if (y + 18 <= top || y >= bottom) continue;
            int idxL = row * 2;
            if (idxL < this.visibleEntries.size()) {
                this.drawCell(g, this.visibleEntries.get(idxL), left, y, colW, mouseX, mouseY, top, bottom);
            }
            if ((idxR = row * 2 + 1) >= this.visibleEntries.size()) continue;
            this.drawCell(g, this.visibleEntries.get(idxR), left + colW + colGap, y, colW, mouseX, mouseY, top, bottom);
        }
    }

    private void drawCell(GuiGraphics g, Entry e, int x, int y, int w, int mouseX, int mouseY, int listTop, int listBottom) {
        int cx = x + 6;
        int cy = y + 1;
        boolean hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + 18 && mouseY >= listTop && mouseY < listBottom;
        int bg = hovered ? 0x22FFFFFF : 0x11FFFFFF;
        g.m_280509_(x, y, x + w, y + 18, bg);
        if (!e.stack.m_41619_()) {
            g.m_280203_(e.stack, cx, cy);
        }
        int textX = cx + (e.stack.m_41619_() ? 0 : 22);
        int toggleW = 36;
        String string = e.displayName;
        Objects.requireNonNull(this.f_96547_);
        g.m_280488_(this.f_96547_, string, textX, y + (18 - 9) / 2, -1);
        int toggleX = x + w - toggleW - 8;
        int toggleY = y + 2;
        boolean blk = e.blacklisted;
        int border = blk ? -5223862 : -11882389;
        int fill = blk ? 860487680 : 855656960;
        g.m_280509_(toggleX, toggleY, toggleX + toggleW, toggleY + 14, fill);
        g.m_280637_(toggleX, toggleY, toggleW, 14, border);
        String state = blk ? "Yes" : "No";
        int tw = this.f_96547_.m_92895_(state);
        g.m_280488_(this.f_96547_, state, toggleX + (toggleW - tw) / 2, toggleY + 3, -1);
        e.lastBounds.setToggleRect(toggleX, toggleY, toggleW);
    }

    private Scrollbar getScrollbar(int top, int right, int bottom) {
        Scrollbar sb = new Scrollbar();
        int viewH = bottom - top;
        if (this.contentHeight <= viewH) {
            sb.x = right - 5;
            sb.y = top;
            sb.w = 3;
            sb.h = viewH;
            return sb;
        }
        float pct = (float)(this.scrollY / (double)(this.contentHeight - viewH));
        int barH = Math.max(22, (int)((float)viewH * ((float)viewH / (float)this.contentHeight)));
        int barY = top + (int)((float)(viewH - barH) * pct);
        sb.x = right - 5;
        sb.y = barY;
        sb.w = 3;
        sb.h = barH;
        return sb;
    }

    private void jumpScrollbar(double my, int[] b, Scrollbar sb) {
        int newBarTop;
        int viewH = b[3] - b[1];
        int maxScroll = Math.max(0, this.contentHeight - viewH);
        int barH = sb.h;
        int barTrackH = viewH - barH;
        if (barTrackH < 1) {
            barTrackH = 1;
        }
        if ((newBarTop = (int)my - barH / 2) < b[1]) {
            newBarTop = b[1];
        }
        if (newBarTop > b[1] + barTrackH) {
            newBarTop = b[1] + barTrackH;
        }
        float t = (float)(newBarTop - b[1]) / (float)barTrackH;
        this.scrollY = t * (float)maxScroll;
        this.clampScroll();
    }

    private void drawScrollbar(GuiGraphics g, int top, int right, int bottom) {
        int viewH = bottom - top;
        if (this.contentHeight <= viewH) {
            return;
        }
        Scrollbar sb = this.getScrollbar(top, right, bottom);
        g.m_280509_(sb.x, sb.y, sb.x + sb.w, sb.y + sb.h, 0x66FFFFFF);
    }

    private static String readGuideText() {
        String text;
        block13: {
            text = null;
            try {
                Path p = Path.of("config", "autoeat_guide.txt");
                if (Files.isRegularFile(p, new LinkOption[0])) {
                    text = Files.readString(p, StandardCharsets.UTF_8);
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            if (text == null) {
                try {
                    Optional res;
                    ResourceManager rm = Minecraft.m_91087_().m_91098_();
                    ResourceLocation loc = ResourceLocation.m_135820_((String)"autoeat:guide.txt");
                    if (loc == null || !(res = rm.m_213713_(loc)).isPresent()) break block13;
                    try (InputStream is = ((Resource)res.get()).m_215507_();){
                        text = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (text == null) {
            return "";
        }
        return text.replace("\ufeff", "").replace("\r\n", "\n").replace("\r", "\n");
    }

    private void playClickSound() {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private static enum Filter {
        ALL,
        DANGER,
        SUPER,
        NORMAL;

    }

    public static class ShaderStyleButton
    extends Button {
        private int pressedAnimTicks = 0;
        private static final int PRESSED_ANIM_MAX = 6;
        private final boolean drawBorder;
        private final boolean innerShadow;
        private final int baseColor;
        private final int hoverColor;
        private final int pressedColor;
        private final int textColorNormal;
        private final int textColorHover;

        public ShaderStyleButton(int x, int y, int w, int h, Component msg, Button.OnPress onPress, boolean drawBorder) {
            this(x, y, w, h, msg, onPress, -2144191674, -1606793644, -1071503568, -1052689, -1, drawBorder, false);
        }

        public ShaderStyleButton(int x, int y, int w, int h, Component msg, Button.OnPress onPress, int base, int hover, int press, int textNormal, int textHover, boolean drawBorder, boolean innerShadow) {
            super(x, y, w, h, msg, onPress, f_252438_);
            this.baseColor = base;
            this.hoverColor = hover;
            this.pressedColor = press;
            this.textColorNormal = textNormal;
            this.textColorHover = textHover;
            this.drawBorder = drawBorder;
            this.innerShadow = innerShadow;
        }

        public void m_5716_(double mx, double my) {
            this.pressedAnimTicks = 6;
            super.m_5716_(mx, my);
        }

        protected void m_87963_(GuiGraphics g, int mouseX, int mouseY, float delta) {
            boolean hovered;
            if (this.pressedAnimTicks > 0) {
                --this.pressedAnimTicks;
            }
            int x = this.m_252754_();
            int y = this.m_252907_();
            int w = this.m_5711_();
            int h = this.m_93694_();
            boolean bl = hovered = mouseX >= x && mouseX < x + w && mouseY >= y && mouseY < y + h;
            int bg = this.pressedAnimTicks > 0 ? this.pressedColor : (hovered ? this.hoverColor : this.baseColor);
            g.m_280509_(x, y, x + w, y + h, bg);
            if (this.innerShadow) {
                g.m_280509_(x + 1, y + 1, x + w - 1, y + 2, 0x22000000);
                g.m_280509_(x + 1, y + h - 2, x + w - 1, y + h - 1, 0x22000000);
            }
            if (this.drawBorder) {
                g.m_280637_(x, y, w, h, -1);
            }
            Font fr = Minecraft.m_91087_().f_91062_;
            int color = hovered ? this.textColorHover : this.textColorNormal;
            int tw = fr.m_92852_((FormattedText)this.m_6035_());
            int textX = x + (w - tw) / 2;
            Objects.requireNonNull(fr);
            int textY = y + (h - 9) / 2 + 1;
            if (tw > 0) {
                g.m_280430_(fr, this.m_6035_(), textX, textY, color);
            }
        }
    }

    private static class Entry {
        final ItemStack stack;
        final String key;
        boolean blacklisted;
        final String displayName;
        final String displayLower;
        final String keyLower;
        final String namespace;
        final String idPath;
        final Bounds lastBounds = new Bounds();

        Entry(ItemStack s, String k, boolean b, String display, String ns, String path) {
            this.stack = s;
            this.key = k;
            this.blacklisted = b;
            this.displayName = display;
            this.displayLower = display.toLowerCase(Locale.ROOT);
            this.keyLower = k.toLowerCase(Locale.ROOT);
            this.namespace = ns.toLowerCase(Locale.ROOT);
            this.idPath = path.toLowerCase(Locale.ROOT);
        }
    }

    private static class Scrollbar {
        int x;
        int y;
        int w;
        int h;

        private Scrollbar() {
        }
    }

    private static class Bounds {
        int x;
        int y;
        int w;
        int h;

        private Bounds() {
        }

        void setToggleRect(int X, int Y, int W) {
            this.x = X;
            this.y = Y;
            this.w = W;
            this.h = 14;
        }

        boolean contains(int mx, int my) {
            return mx >= this.x && mx < this.x + this.w && my >= this.y && my < this.y + this.h;
        }
    }
}

