/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.screen.GeneralConfigScreen;
import com.eruannie_9.booklinggear.util.MirroredImageButton;
import com.eruannie_9.booklinggear.util.screen.GuiType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GuiExecutor {
    private static final ResourceLocation BANNER_TEXTURE = new ResourceLocation("booklinggear", "textures/gui/config_banner.png");
    private static final ResourceLocation TEXT_OVERLAY = new ResourceLocation("booklinggear", "textures/gui/config_banner_text.png");
    private static final ResourceLocation BOOK_TEXTURE = new ResourceLocation("booklinggear", "textures/gui/config_book.png");

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            return;
        }
        GuiType guiType = (GuiType)((Object)ModConfiguration.GUI_TYPE.get());
        if (guiType == GuiType.BANNER) {
            Screen currentScreen = event.getScreen();
            if (currentScreen instanceof TitleScreen) {
                GuiExecutor.addBannerButton(currentScreen, event);
            } else if (currentScreen instanceof PauseScreen) {
                GuiExecutor.addBannerButton(currentScreen, event);
            }
        } else if (guiType == GuiType.BOOK && event.getScreen() instanceof OptionsScreen) {
            GuiExecutor.addBookButton((OptionsScreen)event.getScreen(), event);
        }
    }

    private static void addBannerButton(Screen screen, ScreenEvent.Init.Post event) {
        int y;
        int x;
        if (screen instanceof TitleScreen) {
            x = screen.f_96543_ / 2 - 122;
            y = screen.f_96544_ / 4 + 100;
        } else if (screen instanceof PauseScreen) {
            x = screen.f_96543_ / 2 - 124;
            y = screen.f_96544_ / 4 + 108;
        } else {
            x = screen.f_96543_ / 2 - 122;
            y = screen.f_96544_ / 4 + 48;
        }
        boolean mirrorTexture = (Boolean)ModConfiguration.MIRROR.get();
        MirroredImageButton configButton = new MirroredImageButton(x, y, 22, 8, 0, 0, 8, BANNER_TEXTURE, 22, 16, button -> Minecraft.m_91087_().m_91152_((Screen)new GeneralConfigScreen(screen)), (Component)Component.m_237119_(), mirrorTexture, TEXT_OVERLAY);
        event.addListener((GuiEventListener)configButton);
    }

    private static void addBookButton(OptionsScreen screen, ScreenEvent.Init.Post event) {
        int x = screen.f_96543_ / 2 - 177;
        int y = screen.f_96544_ / 6 + 114;
        ImageButton bookButton = new ImageButton(x, y, 20, 20, 0, 0, 20, BOOK_TEXTURE, 20, 40, button -> Minecraft.m_91087_().m_91152_((Screen)new GeneralConfigScreen((Screen)screen)), (Component)Component.m_237119_());
        event.addListener((GuiEventListener)bookButton);
    }
}

