/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.creative;

import com.eruannie_9.booklinggear.creative.FrameDataHandler;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class AnimatedCreativeModeTab
extends CreativeModeTab {
    private final Supplier<ItemStack[]> frameSupplier;
    private final FrameDataHandler frameDataHandler;
    private final long frameInterval;
    private final boolean useRandomFrame;
    private final RandomSource randomGenerator = RandomSource.m_216327_();
    private long lastFrameCount = -1L;
    private ItemStack cachedIcon = ItemStack.f_41583_;
    private int previousFrameIndex = -1;

    public AnimatedCreativeModeTab(CreativeModeTab.Builder builder, Supplier<ItemStack[]> frameSupplier, long frameInterval, FrameDataHandler frameDataHandler, boolean useRandomFrame) {
        super(builder);
        this.frameSupplier = frameSupplier;
        this.frameInterval = frameInterval;
        this.frameDataHandler = frameDataHandler;
        this.useRandomFrame = useRandomFrame;
    }

    public ItemStack m_40787_() {
        long currentTime = System.currentTimeMillis();
        long currentFrameCount = currentTime / this.frameInterval;
        if (currentFrameCount != this.lastFrameCount) {
            this.updateCachedIcon(currentFrameCount);
        }
        return this.cachedIcon;
    }

    private void updateCachedIcon(long frameCount) {
        int frameIndex;
        this.lastFrameCount = frameCount;
        this.randomGenerator.m_188584_(frameCount);
        ItemStack[] frames = this.frameSupplier.get();
        if (frames.length == 0) {
            this.cachedIcon = ItemStack.f_41583_;
            return;
        }
        this.previousFrameIndex = frameIndex = this.selectFrameIndex(frames.length);
        ItemStack selectedFrame = frames[frameIndex].m_41777_();
        if (this.frameDataHandler != null) {
            this.frameDataHandler.handle(selectedFrame, frameCount);
        }
        this.cachedIcon = selectedFrame;
    }

    private int selectFrameIndex(int frameCount) {
        if (this.useRandomFrame) {
            int randomIndex = this.randomGenerator.m_188503_(frameCount);
            if (frameCount > 1 && randomIndex == this.previousFrameIndex) {
                return (randomIndex + 1) % frameCount;
            }
            return randomIndex;
        }
        return (this.previousFrameIndex + 1) % frameCount;
    }
}

