/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.register;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;

public class DeferredRegisters {
    private final String modId;
    private final Map<IForgeRegistry<?>, DeferredRegister<?>> registries = new HashMap();
    private final Map<IForgeRegistry<?>, Boolean> hasEntries = new HashMap();

    public DeferredRegisters(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public <T> DeferredRegister<T> getOrCreateRegistry(IForgeRegistry<T> registry) {
        return this.registries.computeIfAbsent(registry, r -> {
            this.hasEntries.put((IForgeRegistry<?>)r, false);
            return DeferredRegister.create((IForgeRegistry)registry, (String)this.modId);
        });
    }

    public <T> void markHasEntries(IForgeRegistry<T> registry) {
        this.hasEntries.put(registry, true);
    }

    public void register(IEventBus eventBus) {
        this.registries.forEach((registry, deferredRegister) -> {
            if (this.hasEntries.getOrDefault(registry, false).booleanValue()) {
                deferredRegister.register(eventBus);
            }
        });
    }
}

