/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.screen.GeneralConfigScreen;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.ButtonList;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MissingModsScreen
extends Screen {
    private final Screen parentScreen;
    private final List<GeneralConfigScreen.ModInfo> missingModsList;
    private ButtonList buttonList;
    private AnimatedScreenTitle animatedTitle;

    public MissingModsScreen(Screen parentScreen, List<GeneralConfigScreen.ModInfo> missingModsList) {
        super((Component)Component.m_237113_((String)"Missing Compatible Mods"));
        this.parentScreen = parentScreen;
        this.missingModsList = missingModsList;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.missingModsList.isEmpty()) {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
            return;
        }
        int rowSpacing = 24;
        int buttonWidth = 200;
        int listTop = 32;
        int bannerHeight = 44;
        int listBottom = this.f_96544_ - bannerHeight;
        this.buttonList = new ButtonList(this.f_96541_, this.f_96543_, this.f_96544_, listTop, listBottom, rowSpacing);
        this.m_7787_((GuiEventListener)this.buttonList);
        for (GeneralConfigScreen.ModInfo info : this.missingModsList) {
            Button modButton = this.createModButton(info, buttonWidth);
            modButton.m_93674_(buttonWidth);
            this.buttonList.addInstant(modButton);
        }
        this.m_142416_((GuiEventListener)ScrollSlider.attach(this.buttonList).widget());
        int backX = this.f_96543_ / 2 - 100;
        int backY = listBottom + (bannerHeight - 20) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), b -> Minecraft.m_91087_().m_91152_(this.parentScreen)).m_252794_(backX, backY).m_253046_(200, 20).m_253136_());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
    }

    private Button createModButton(GeneralConfigScreen.ModInfo info, int buttonWidth) {
        String modName = info.displayName();
        String link = info.link();
        MutableComponent label = Component.m_237113_((String)(modName + " Mod"));
        Button.OnPress action = b -> {
            MutableComponent message = Component.m_237113_((String)"Do you want to open the following link?\n").m_7220_((Component)Component.m_237113_((String)link).m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true))));
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(yes -> {
                if (yes) {
                    Util.m_137581_().m_137646_(link);
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            }, (Component)Component.m_237113_((String)"Link Confirmation"), (Component)message, (Component)Component.m_237113_((String)"Yes"), (Component)Component.m_237113_((String)"No")));
        };
        return Button.m_253074_((Component)label, (Button.OnPress)action).m_252794_(0, 0).m_253046_(buttonWidth, 20).m_253136_();
    }

    public void m_6574_(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = 0.0;
        if (this.buttonList != null && this.buttonList.m_93518_() > 0) {
            scrollRatio = this.buttonList.m_93517_() / (double)this.buttonList.m_93518_();
        }
        super.m_6574_(mc, newWidth, newHeight);
        if (this.buttonList != null && this.buttonList.m_93518_() > 0) {
            this.buttonList.m_93410_(scrollRatio * (double)this.buttonList.m_93518_());
        }
    }

    public void m_86412_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.buttonList.tickAnimations();
        this.buttonList.m_86412_(poseStack, mouseX, mouseY, partialTick);
        this.animatedTitle.render(poseStack, this.f_96547_, this.f_96543_);
        super.m_86412_(poseStack, mouseX, mouseY, partialTick);
    }
}

