/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import com.eruannie_9.booklinggear.util.CommentText;
import com.eruannie_9.booklinggear.util.screen.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ValueEntry
extends ConfigOptionList.ConfigEntry {
    public static final List<EditBox> EDIT_BOXES = Collections.synchronizedList(new ArrayList());
    private final String label;
    private final ForgeConfigSpec.ConfigValue<?> configValue;
    private final AbstractWidget valueWidget;
    private final String comment;
    private final List<String> urls;
    private final Button editButton;
    private int cachedXPos;
    private int cachedYPos;
    private int cachedRowHeight;
    private static final int INDENT = 10;
    private static final int RIGHT_RESERVED = 105;

    public ValueEntry(String label, ForgeConfigSpec.ConfigValue<?> configValue, AbstractWidget valueWidget, int depth, String comment, ConfigScreen parentScreen) {
        super(depth);
        this.label = label;
        this.configValue = configValue;
        this.valueWidget = valueWidget;
        this.comment = comment;
        this.urls = CommentText.extractLinks(comment);
        if (configValue.get() instanceof List) {
            ForgeConfigSpec.ConfigValue<?> listConfig = configValue;
            this.editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), b -> parentScreen.openListEditScreen(label, this.fullPath(), (ForgeConfigSpec.ConfigValue<List<String>>)listConfig)).m_252794_(0, 0).m_253046_(100, 20).m_253136_();
        } else {
            String s;
            Object object = configValue.get();
            this.editButton = object instanceof String && ColorUtil.isHexColor(s = (String)object) ? Button.m_253074_((Component)Component.m_237113_((String)"Edit Color"), b -> parentScreen.openColorEditScreen(label, this.fullPath(), s)).m_252794_(0, 0).m_253046_(100, 20).m_253136_() : null;
        }
        if (valueWidget instanceof EditBox) {
            EditBox eb = (EditBox)valueWidget;
            EDIT_BOXES.add(eb);
        }
    }

    public ForgeConfigSpec.ConfigValue<?> configValue() {
        return this.configValue;
    }

    public AbstractWidget widget() {
        return this.valueWidget;
    }

    public String fullPath() {
        return String.join((CharSequence)".", this.configValue.getPath());
    }

    public void updateEditButtonLabel(String text) {
        if (this.editButton != null) {
            this.editButton.m_93666_((Component)Component.m_237113_((String)text));
        }
    }

    private boolean isOpaqueEditBox() {
        return this.valueWidget instanceof EditBox;
    }

    public void m_6311_(@NotNull PoseStack poseStack, int rowIndex, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        float widgetAlpha;
        String s;
        Object object;
        ConfigScreen screen;
        float progress = this.easedProgress();
        boolean opaqueEdit = this.isOpaqueEditBox();
        int slideOffset = opaqueEdit && !this.isTargetVisible() ? -Mth.m_14167_((float)((1.0f - progress) * (float)Minecraft.m_91087_().m_91268_().m_85445_())) : this.slideX(rowWidth);
        int adjustedY = this.easedY(yPos);
        this.cachedXPos = xPos + slideOffset;
        this.cachedYPos = adjustedY;
        this.cachedRowHeight = rowHeight;
        Font font = Minecraft.m_91087_().f_91062_;
        int maxLabelWidth = rowWidth - this.depth * 10 - 5 - 105;
        String display = TextUtil.abbreviate(font, this.label, maxLabelWidth);
        int labelX = xPos + this.depth * 10 + 5 + slideOffset;
        Objects.requireNonNull(font);
        int labelY = adjustedY + (rowHeight - 9) / 2;
        Screen screen2 = Minecraft.m_91087_().f_91080_;
        boolean tipsOn = screen2 instanceof ConfigScreen && (screen = (ConfigScreen)screen2).isTooltipEnabled();
        double d = mouseX;
        double d2 = mouseY;
        int n = font.m_92895_(display);
        Objects.requireNonNull(font);
        boolean overLabel = ValueEntry.in(d, d2, labelX, labelY, n, 9);
        int baseRGB = tipsOn && overLabel ? 0xFFFFA0 : 0xFFFFFF;
        int argb = Math.round(progress * 255.0f) << 24 | baseRGB;
        font.m_92883_(poseStack, display, (float)labelX, (float)labelY, argb);
        if (this.editButton != null && this.valueWidget == null && (object = this.configValue.get()) instanceof String && ColorUtil.isHexColor(s = (String)object)) {
            this.drawColourSwatch(poseStack, xPos, rowWidth, slideOffset, adjustedY, rowHeight, s, progress);
        }
        float f = opaqueEdit ? (this.isTargetVisible() ? progress : 1.0f) : (widgetAlpha = progress);
        if (this.valueWidget != null) {
            this.valueWidget.m_93650_(widgetAlpha);
            this.valueWidget.m_252865_(xPos + rowWidth - 105 + slideOffset);
            this.valueWidget.m_253211_(adjustedY + (rowHeight - this.valueWidget.m_93694_()) / 2);
            this.valueWidget.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (this.editButton != null) {
            this.editButton.m_93650_(widgetAlpha);
            this.editButton.m_252865_(xPos + rowWidth - 105 + slideOffset);
            this.editButton.m_253211_(adjustedY + (rowHeight - this.editButton.m_93694_()) / 2);
            this.editButton.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        }
        if (tipsOn && overLabel) {
            this.queueTooltip(mouseX, mouseY);
        }
    }

    private void drawColourSwatch(PoseStack poseStack, int xPos, int rowWidth, int slideOffset, int adjustedY, int rowHeight, String hex, float progress) {
        String drawHex = hex;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ConfigScreen) {
            String s;
            ConfigScreen scr = (ConfigScreen)screen;
            Object v = scr.currentValues.get(this.fullPath());
            if (v instanceof String && ColorUtil.isHexColor(s = (String)v)) {
                drawHex = s;
            }
        }
        int swatchSize = 20;
        int swatchX = xPos + rowWidth - 105 + slideOffset - swatchSize - 5;
        int swatchY = adjustedY + (rowHeight - swatchSize) / 2;
        int rgb = ColorUtil.hexToARGB(drawHex) & 0xFFFFFF;
        int fill = Math.round(progress * 255.0f) << 24 | rgb;
        int edge = Math.round(progress * 255.0f) << 24 | 0xFFFFFF;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)swatchX, (int)swatchY, (int)(swatchX + swatchSize), (int)(swatchY + swatchSize), (int)fill);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)swatchX, (int)swatchY, (int)(swatchX + swatchSize), (int)(swatchY + 1), (int)edge);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)swatchX, (int)(swatchY + swatchSize - 1), (int)(swatchX + swatchSize), (int)(swatchY + swatchSize), (int)edge);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)swatchX, (int)swatchY, (int)(swatchX + 1), (int)(swatchY + swatchSize), (int)edge);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(swatchX + swatchSize - 1), (int)swatchY, (int)(swatchX + swatchSize), (int)(swatchY + swatchSize), (int)edge);
    }

    private void queueTooltip(int mouseX, int mouseY) {
        List<Component> lines = CommentText.toTooltipComponents(this.comment);
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ConfigScreen) {
            ConfigScreen screen2 = (ConfigScreen)screen;
            screen2.tooltipLines = lines;
            screen2.tooltipX = mouseX;
            screen2.tooltipY = mouseY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Object url;
        ConfigScreen screen;
        Screen screen2;
        if (this.inLabel((int)mouseX, (int)mouseY) && !this.urls.isEmpty() && (screen2 = Minecraft.m_91087_().f_91080_) instanceof ConfigScreen && (screen = (ConfigScreen)screen2).isTooltipEnabled()) {
            url = this.urls.get(0);
            MutableComponent message = Component.m_237113_((String)"Do you want to open the following link?\n").m_7220_((Component)Component.m_237113_((String)url).m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true))));
            Minecraft.m_91087_().m_91152_((Screen)new ConfirmScreen(arg_0 -> ValueEntry.lambda$mouseClicked$3((String)url, screen, arg_0), (Component)Component.m_237113_((String)"Link Confirmation"), (Component)message, (Component)Component.m_237113_((String)"Yes"), (Component)Component.m_237113_((String)"No")));
            return true;
        }
        if (this.valueWidget != null && this.valueWidget.m_5953_(mouseX, mouseY)) {
            CycleButton cb;
            if (button == 1 && (url = this.valueWidget) instanceof CycleButton && ValueEntry.cycleEnumBackward(cb = (CycleButton)url)) {
                cb.m_7435_(Minecraft.m_91087_().m_91106_());
                return true;
            }
            boolean result = this.valueWidget.m_6375_(mouseX, mouseY, button);
            Object object = this.valueWidget;
            if (object instanceof EditBox) {
                EditBox clicked = (EditBox)object;
                object = EDIT_BOXES;
                synchronized (object) {
                    for (EditBox eb : EDIT_BOXES) {
                        if (eb == clicked) continue;
                        eb.m_93692_(false);
                    }
                }
                clicked.m_93692_(true);
                Objects.requireNonNull(Minecraft.m_91087_().f_91080_).m_7522_((GuiEventListener)clicked);
            }
            return result;
        }
        if (this.editButton != null && this.editButton.m_5953_(mouseX, mouseY)) {
            return this.editButton.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private static boolean cycleEnumBackward(CycleButton<?> c) {
        Object cur = c.m_168883_();
        if (!(cur instanceof Enum)) {
            return false;
        }
        Enum e = (Enum)cur;
        Enum[] constants = (Enum[])e.getDeclaringClass().getEnumConstants();
        if (constants == null || constants.length == 0) {
            return false;
        }
        int prev = (e.ordinal() - 1 + constants.length) % constants.length;
        c.m_168892_((Object)constants[prev]);
        return true;
    }

    private boolean inLabel(int mouseX, int mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int labelX = this.cachedXPos + this.depth * 10 + 5;
        Objects.requireNonNull(font);
        int labelY = this.cachedYPos + (this.cachedRowHeight - 9) / 2;
        double d = mouseX;
        double d2 = mouseY;
        int n = font.m_92895_(this.label);
        Objects.requireNonNull(font);
        return ValueEntry.in(d, d2, labelX, labelY, n, 9);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.valueWidget != null && this.valueWidget.m_93696_() ? this.valueWidget.m_7933_(keyCode, scanCode, modifiers) : super.m_7933_(keyCode, scanCode, modifiers);
    }

    private static boolean in(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    private static /* synthetic */ void lambda$mouseClicked$3(String url, ConfigScreen screen, boolean yes) {
        if (yes) {
            CommentText.openUrl(url);
        }
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }
}

