/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.update;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.update.UpdateMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="booklinggear", value={Dist.CLIENT})
public final class UpdateAnnouncer {
    private static final Map<String, Entry> PENDING = new LinkedHashMap<String, Entry>();
    private static boolean announcedThisSession = false;

    private UpdateAnnouncer() {
    }

    public static synchronized void queue(String modId, String displayName, String latest, String current, String url) {
        PENDING.put(modId, new Entry(displayName, latest, current, url));
    }

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        UpdateAnnouncer.announce();
    }

    private static synchronized void announce() {
        UpdateMode mode = (UpdateMode)((Object)ModConfiguration.MOD_UPDATES.get());
        if (mode == UpdateMode.NONE) {
            return;
        }
        if (mode == UpdateMode.SESSION && announcedThisSession) {
            return;
        }
        if (PENDING.isEmpty()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int count = PENDING.size();
        if (count > 1) {
            Objects.requireNonNull(player).m_213846_((Component)Component.m_237113_((String)"New updates available:").m_130940_(ChatFormatting.GOLD));
        }
        if (count == 1) {
            Entry entry2 = PENDING.values().iterator().next();
            Objects.requireNonNull(player).m_213846_((Component)UpdateAnnouncer.singleLine(entry2));
        } else {
            PENDING.values().forEach(entry -> player.m_213846_((Component)UpdateAnnouncer.bulletLine(entry)));
        }
        if (mode == UpdateMode.SESSION) {
            announcedThisSession = true;
        }
    }

    private static MutableComponent singleLine(Entry entry) {
        MutableComponent intro = Component.m_237113_((String)"New update available: ").m_130940_(ChatFormatting.GOLD);
        return Component.m_237119_().m_7220_((Component)intro).m_7220_((Component)UpdateAnnouncer.nameStyled(entry.name())).m_130946_(" ").m_7220_((Component)UpdateAnnouncer.versionPair(entry)).m_7220_((Component)UpdateAnnouncer.downloadButton(entry.url()));
    }

    private static MutableComponent bulletLine(Entry entry) {
        return Component.m_237113_((String)" \u2022 ").m_7220_((Component)UpdateAnnouncer.nameStyled(entry.name())).m_130946_(" ").m_7220_((Component)UpdateAnnouncer.versionPair(entry)).m_7220_((Component)UpdateAnnouncer.downloadButton(entry.url()));
    }

    private static MutableComponent nameStyled(String name) {
        return Component.m_237113_((String)name).m_130940_(ChatFormatting.AQUA);
    }

    private static MutableComponent versionPair(Entry entry) {
        MutableComponent current = Component.m_237113_((String)entry.current()).m_130940_(ChatFormatting.RED);
        MutableComponent arrow = Component.m_237113_((String)" \u2192 ").m_130940_(ChatFormatting.GRAY);
        MutableComponent latest = Component.m_237113_((String)entry.latest()).m_130940_(ChatFormatting.GREEN);
        return Component.m_237119_().m_7220_((Component)current).m_7220_((Component)arrow).m_7220_((Component)latest);
    }

    private static MutableComponent downloadButton(String url) {
        return Component.m_237113_((String)" [Download]").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Open CurseForge page"))));
    }

    private record Entry(String name, String latest, String current, String url) {
    }
}

