/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.list;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.AnimatedEntry;
import com.eruannie_9.booklinggear.screen.list.EntryList;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ListEditScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private final ConfigScreen parentScreen;
    private final String fullPath;
    private final List<String> valueList;
    private EntryList entryList;
    private AnimatedScreenTitle animatedTitle;

    public ListEditScreen(ConfigScreen parentScreen, String title, String fullPath, List<String> initialValues) {
        super((Component)Component.m_237113_((String)("Edit " + title)));
        this.parentScreen = parentScreen;
        this.fullPath = fullPath;
        this.valueList = new ArrayList<String>(initialValues);
    }

    protected void m_7856_() {
        int listTop = 40;
        int listBottom = this.f_96544_ - 80;
        this.entryList = new EntryList(this.f_96541_, this.f_96543_, this.f_96544_, listTop, listBottom, 24);
        this.m_142416_((GuiEventListener)ScrollSlider.attach(this.entryList).widget());
        this.m_7787_((GuiEventListener)this.entryList);
        for (String v : this.valueList) {
            this.entryList.addEntryInstant(new EntryList.Entry(this.entryList, v));
        }
        int buttonWidth = 100;
        int gap = 10;
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Add"), btn -> this.entryList.addEntryAnimated(new EntryList.Entry(this.entryList, ""))).m_252794_(centerX - buttonWidth - gap / 2, this.f_96544_ - 70).m_253046_(buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), btn -> this.saveAndClose()).m_252794_(centerX + gap / 2, this.f_96544_ - 70).m_253046_(buttonWidth, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.f_96541_.m_91152_((Screen)this.parentScreen)).m_252794_(centerX - buttonWidth / 2, this.f_96544_ - 40).m_253046_(buttonWidth, 20).m_253136_());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
    }

    private void saveAndClose() {
        List<String> newList = this.entryList.m_6702_().stream().filter(AnimatedEntry::isTargetVisible).map(EntryList.Entry::getValue).filter(s -> !s.isEmpty()).toList();
        this.parentScreen.onListEdits(this.fullPath, newList);
        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this.parentScreen);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.entryList.tickAnimations();
        this.entryList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.f_96547_, this.f_96543_);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_6574_(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = this.entryList != null && this.entryList.m_93518_() > 0 ? this.entryList.m_93517_() / (double)this.entryList.m_93518_() : 0.0;
        List<String> liveLines = Objects.requireNonNull(this.entryList).m_6702_().stream().filter(AnimatedEntry::isTargetVisible).map(EntryList.Entry::getValue).toList();
        this.valueList.clear();
        this.valueList.addAll(liveLines);
        super.m_6574_(mc, newWidth, newHeight);
        if (this.entryList != null && this.entryList.m_93518_() > 0) {
            this.entryList.m_93410_(scrollRatio * (double)this.entryList.m_93518_());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = this.entryList.m_6375_(mouseX, mouseY, button);
        if (!handled) {
            handled = super.m_6375_(mouseX, mouseY, button);
        }
        if (button == 0) {
            boolean overEditBox = this.entryList.m_6702_().stream().anyMatch(e -> e.getTextBox().m_5953_(mouseX, mouseY));
            if (overEditBox) {
                for (EntryList.Entry e2 : this.entryList.m_6702_()) {
                    if (!e2.getTextBox().m_93696_()) continue;
                    this.m_7522_((GuiEventListener)e2.getTextBox());
                    break;
                }
            } else {
                this.entryList.m_6702_().forEach(e -> e.getTextBox().m_93692_(false));
                this.m_7522_(null);
            }
        }
        return handled;
    }
}

