/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.packethandler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.zip.CRC32;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;

public final class PacketRegister {
    private static final Map<String, Channel> CHANNELS = new ConcurrentHashMap<String, Channel>();

    public static SimpleChannel channel(String modid) {
        return PacketRegister.of(modid).channel();
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass) {
        PacketRegister.of(modid).register(packetClass, Flow.BOTH, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass, Flow flow) {
        PacketRegister.of(modid).register(packetClass, flow, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).register(packetClass, flow, thread);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass) {
        PacketRegister.of(modid).register(id, packetClass, Flow.BOTH, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass, Flow flow) {
        PacketRegister.of(modid).register(id, packetClass, flow, ThreadPolicy.MAIN);
    }

    public static <MSG> void register(String modid, int id, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).register(id, packetClass, flow, thread);
    }

    public static <MSG> void registerLogin(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.of(modid).registerLogin(packetClass, flow, thread);
    }

    private static Channel of(String modid) {
        return CHANNELS.computeIfAbsent(modid, Channel::new);
    }

    public static final class Channel {
        private static final String DEFAULT_NAME = "main";
        private static final int DEFAULT_PROTOCOL = 1;
        private final String modid;
        private final SimpleChannel ch;
        private final Set<Integer> usedIds = new ConcurrentSkipListSet<Integer>();

        private Channel(String modid) {
            this.modid = modid;
            this.ch = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)DEFAULT_NAME)).networkProtocolVersion(1).clientAcceptedVersions(Channel.VersionTest.exact((int)1)).serverAcceptedVersions(Channel.VersionTest.exact((int)1)).simpleChannel();
        }

        public SimpleChannel channel() {
            return this.ch;
        }

        public <MSG> void register(Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            int id = Channel.deriveId(this.modid, packetClass);
            this.register(id, packetClass, flow, thread);
        }

        public <MSG> void register(int id, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            if (id <= 0) {
                throw new IllegalArgumentException("Packet id must be positive (got " + id + ") for " + this.modid);
            }
            if (!this.usedIds.add(id)) {
                throw new IllegalStateException("Duplicate packet id " + id + " for " + this.modid);
            }
            BiConsumer<MSG, FriendlyByteBuf> enc = Channel.findEncoder(packetClass);
            Function<FriendlyByteBuf, MSG> dec = Channel.findDecoder(packetClass);
            BiConsumer<MSG, CustomPayloadEvent.Context> userHandler = Channel.findHandler(packetClass);
            BiConsumer<MSG, CustomPayloadEvent.Context> guarded = Channel.guardByFlow(userHandler, flow);
            SimpleChannel.MessageBuilder b = flow.playDirection().map(dir -> this.ch.messageBuilder(packetClass, id, dir)).orElseGet(() -> this.ch.messageBuilder(packetClass, id));
            b.encoder(enc).decoder(dec);
            if (thread == ThreadPolicy.MAIN) {
                b.consumerMainThread(guarded);
            } else {
                b.consumerNetworkThread(guarded);
            }
            b.add();
        }

        public <MSG> void registerLogin(Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
            int id = Channel.deriveId(this.modid, packetClass);
            if (id <= 0) {
                throw new IllegalArgumentException("Packet id must be positive (got " + id + ") for " + this.modid);
            }
            if (!this.usedIds.add(id)) {
                throw new IllegalStateException("Duplicate packet id " + id + " for " + this.modid);
            }
            BiConsumer<MSG, FriendlyByteBuf> enc = Channel.findEncoder(packetClass);
            Function<FriendlyByteBuf, MSG> dec = Channel.findDecoder(packetClass);
            BiConsumer<MSG, CustomPayloadEvent.Context> userHandler = Channel.findHandler(packetClass);
            BiConsumer<MSG, CustomPayloadEvent.Context> guarded = Channel.guardByFlow(userHandler, flow);
            NetworkDirection loginDir = flow.loginDirection().orElseThrow(() -> new IllegalArgumentException("Login packets must specify TO_SERVER or TO_CLIENT flow (not BOTH)"));
            SimpleChannel.MessageBuilder b = this.ch.messageBuilder(packetClass, id, loginDir);
            b.encoder(enc).decoder(dec);
            if (thread == ThreadPolicy.MAIN) {
                b.consumerMainThread(guarded);
            } else {
                b.consumerNetworkThread(guarded);
            }
            b.add();
        }

        private static <MSG> BiConsumer<MSG, CustomPayloadEvent.Context> guardByFlow(BiConsumer<MSG, CustomPayloadEvent.Context> userHandler, Flow flow) {
            return switch (flow) {
                default -> throw new IncompatibleClassChangeError();
                case Flow.TO_SERVER -> (m, ctx) -> {
                    NetworkDirection d = ctx.getDirection();
                    if (d != NetworkDirection.PLAY_TO_SERVER && d != NetworkDirection.LOGIN_TO_SERVER) {
                        return;
                    }
                    if (ctx.getSender() == null) {
                        return;
                    }
                    userHandler.accept((Object)m, (CustomPayloadEvent.Context)ctx);
                };
                case Flow.TO_CLIENT -> (m, ctx) -> {
                    NetworkDirection d = ctx.getDirection();
                    if (d != NetworkDirection.PLAY_TO_CLIENT && d != NetworkDirection.LOGIN_TO_CLIENT) {
                        return;
                    }
                    userHandler.accept((Object)m, (CustomPayloadEvent.Context)ctx);
                };
                case Flow.BOTH -> userHandler;
            };
        }

        private static <MSG> BiConsumer<MSG, FriendlyByteBuf> findEncoder(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "encode", MethodType.methodType(Void.TYPE, cls, FriendlyByteBuf.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Void.TYPE, Object.class, FriendlyByteBuf.class));
                return (m, buf) -> {
                    try {
                        adapted.invokeExact(m, (FriendlyByteBuf)buf);
                    }
                    catch (Throwable t) {
                        throw Channel.sneaky(t);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static void encode(%s, FriendlyByteBuf)", cls.getSimpleName()), e);
            }
        }

        private static <MSG> Function<FriendlyByteBuf, MSG> findDecoder(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "decode", MethodType.methodType(cls, FriendlyByteBuf.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Object.class, FriendlyByteBuf.class));
                return buf -> {
                    try {
                        Object o = adapted.invokeExact((FriendlyByteBuf)buf);
                        return cls.cast(o);
                    }
                    catch (Throwable t) {
                        throw Channel.sneaky(t);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static %s decode(FriendlyByteBuf)", cls.getSimpleName()), e);
            }
        }

        private static <MSG> BiConsumer<MSG, CustomPayloadEvent.Context> findHandler(Class<MSG> cls) {
            try {
                MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "handle", MethodType.methodType(Void.TYPE, cls, CustomPayloadEvent.Context.class));
                MethodHandle adapted = exact.asType(MethodType.methodType(Void.TYPE, Object.class, CustomPayloadEvent.Context.class));
                return (m, ctx) -> {
                    try {
                        adapted.invokeExact(m, (CustomPayloadEvent.Context)ctx);
                    }
                    catch (Throwable t) {
                        throw Channel.sneaky(t);
                    }
                };
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalArgumentException(Channel.sigErr(cls, "public static void handle(%s, CustomPayloadEvent.Context)", cls.getSimpleName()), e);
            }
        }

        private static String sigErr(Class<?> cls, String fmt, Object ... args) {
            return "Packet class " + cls.getName() + " must declare: " + String.format(fmt, args);
        }

        private static int deriveId(String modid, Class<?> cls) {
            byte[] key = (modid + ":" + cls.getName()).getBytes(StandardCharsets.UTF_8);
            CRC32 crc = new CRC32();
            crc.update(key, 0, key.length);
            int id = (int)(crc.getValue() & 0xFFFFFFL);
            return id == 0 ? 1 : id;
        }

        private static RuntimeException sneaky(Throwable t) {
            if (t instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)t;
                return re;
            }
            if (t instanceof Error) {
                Error e = (Error)t;
                throw e;
            }
            return new RuntimeException(t);
        }
    }

    public static enum Flow {
        TO_SERVER(NetworkDirection.PLAY_TO_SERVER, NetworkDirection.LOGIN_TO_SERVER),
        TO_CLIENT(NetworkDirection.PLAY_TO_CLIENT, NetworkDirection.LOGIN_TO_CLIENT),
        BOTH(null, null);

        private final NetworkDirection playDir;
        private final NetworkDirection loginDir;

        private Flow(NetworkDirection playDir, NetworkDirection loginDir) {
            this.playDir = playDir;
            this.loginDir = loginDir;
        }

        Optional<NetworkDirection> playDirection() {
            return Optional.ofNullable(this.playDir);
        }

        Optional<NetworkDirection> loginDirection() {
            return Optional.ofNullable(this.loginDir);
        }
    }

    public static enum ThreadPolicy {
        MAIN,
        NETWORK;

    }
}

