/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.register;

import com.eruannie_9.booklinggear.register.DeferredRegisters;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class RegistrationHelper {
    private final DeferredRegisters deferredRegisters;

    public RegistrationHelper(DeferredRegisters deferredRegisters) {
        this.deferredRegisters = deferredRegisters;
    }

    public <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier, Item.Properties itemProperties) {
        return this.registerBlock(name, blockSupplier, itemProperties, BlockItem::new);
    }

    public <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier, Item.Properties itemProperties, BiFunction<T, Item.Properties, ? extends Item> itemFactory) {
        DeferredRegister blockRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.BLOCKS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.BLOCKS);
        RegistryObject blockRO = blockRegistry.register(name, blockSupplier);
        if (itemProperties != null && itemFactory != null) {
            DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.ITEMS);
            this.deferredRegisters.markHasEntries(ForgeRegistries.ITEMS);
            itemRegistry.register(name, () -> (Item)itemFactory.apply((Block)blockRO.get(), itemProperties));
        }
        return blockRO;
    }

    private <T extends Block> void registerBlockItem(String name, RegistryObject<T> block, Item.Properties itemProperties) {
        DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.ITEMS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.ITEMS);
        itemRegistry.register(name, () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public RegistryObject<Item> registerItem(String name, Supplier<Item> itemSupplier) {
        DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.ITEMS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.ITEMS);
        return itemRegistry.register(name, itemSupplier);
    }

    public <T extends ParticleType<?>> RegistryObject<T> registerParticleType(String name, Supplier<T> particleSupplier) {
        DeferredRegister particleRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.PARTICLE_TYPES);
        this.deferredRegisters.markHasEntries(ForgeRegistries.PARTICLE_TYPES);
        return particleRegistry.register(name, particleSupplier);
    }

    public <T extends Feature<?>> RegistryObject<T> registerFeature(String name, Supplier<T> featureSupplier) {
        DeferredRegister featureRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.FEATURES);
        this.deferredRegisters.markHasEntries(ForgeRegistries.FEATURES);
        return featureRegistry.register(name, featureSupplier);
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntityType(String name, Supplier<BlockEntityType<T>> blockEntitySupplier) {
        DeferredRegister blockEntityRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.BLOCK_ENTITY_TYPES);
        this.deferredRegisters.markHasEntries(ForgeRegistries.BLOCK_ENTITY_TYPES);
        return blockEntityRegistry.register(name, blockEntitySupplier);
    }

    public RegistryObject<SoundEvent> registerSound(String name) {
        DeferredRegister soundRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.SOUND_EVENTS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.SOUND_EVENTS);
        ResourceLocation id = new ResourceLocation(this.deferredRegisters.getModId(), name);
        return soundRegistry.register(name, () -> SoundEvent.m_262824_((ResourceLocation)id));
    }

    public <T extends MenuType<?>> RegistryObject<T> registerMenuType(String name, Supplier<T> menuSupplier) {
        DeferredRegister menuRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.MENU_TYPES);
        this.deferredRegisters.markHasEntries(ForgeRegistries.MENU_TYPES);
        return menuRegistry.register(name, menuSupplier);
    }

    public <T extends RecipeSerializer<?>> RegistryObject<T> registerRecipeSerializer(String name, Supplier<T> serializerSupplier) {
        DeferredRegister recipeRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.RECIPE_SERIALIZERS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.RECIPE_SERIALIZERS);
        return recipeRegistry.register(name, serializerSupplier);
    }

    public <T extends MobEffect> RegistryObject<T> registerMobEffect(String name, Supplier<T> effectSupplier) {
        DeferredRegister effectRegistry = this.deferredRegisters.getOrCreateRegistry(ForgeRegistries.MOB_EFFECTS);
        this.deferredRegisters.markHasEntries(ForgeRegistries.MOB_EFFECTS);
        return effectRegistry.register(name, effectSupplier);
    }
}

