/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.warning.WarningMessageScreen;
import com.eruannie_9.booklinggear.util.screen.ScreenUtil;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ModConfigSelectionScreen
extends Screen {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_SPACING = 24;
    private final Screen parentScreen;
    private final String modName;
    private final List<ModConfig> configList;
    private AnimatedScreenTitle animatedTitle;

    public ModConfigSelectionScreen(Screen parentScreen, String modName, List<ModConfig> configList) {
        super((Component)Component.m_237113_((String)("Select Config File for " + modName)));
        this.parentScreen = parentScreen;
        this.modName = modName;
        this.configList = configList;
    }

    protected void m_7856_() {
        super.m_7856_();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (ModConfig cfg : this.configList) {
            buttons.add(this.createConfigButton(cfg));
        }
        int yPos = ScreenUtil.computeStartY(this, 24, buttons.size());
        for (Button b : buttons) {
            b.m_252865_(this.f_96543_ / 2 - 100);
            b.m_253211_(yPos);
            yPos += 24;
            this.m_142416_((GuiEventListener)b);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.back"), btn -> Minecraft.m_91087_().m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 28).m_253046_(200, 20).m_253136_());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
    }

    private Button createConfigButton(ModConfig cfg) {
        String rawFile = cfg.getFileName();
        String display = rawFile.endsWith(".toml") ? rawFile.substring(0, rawFile.length() - 5) : rawFile;
        return Button.m_253074_((Component)Component.m_237113_((String)display), btn -> {
            if (cfg.getConfigData() == null) {
                Minecraft.m_91087_().m_91152_((Screen)new WarningMessageScreen(this, "The configuration file is not loaded."));
            } else {
                ForgeConfigSpec spec = (ForgeConfigSpec)cfg.getSpec();
                Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(this, "Configuration for " + this.modName, spec));
            }
        }).m_252794_(0, 0).m_253046_(200, 20).m_253136_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.f_96547_, this.f_96543_);
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
    }
}

