/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.eruannie_9.booklinggear.BooklingGear;
import com.eruannie_9.booklinggear.event.ConfigChangedEvent;
import com.eruannie_9.booklinggear.screen.config.ConfigEntryCollector;
import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.GroupEntry;
import com.eruannie_9.booklinggear.screen.config.ValueEntry;
import com.eruannie_9.booklinggear.screen.config.color.ColorPickerScreen;
import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import com.eruannie_9.booklinggear.screen.config.visibility.VisibilityChecker;
import com.eruannie_9.booklinggear.screen.config.warning.WarningConfigChecker;
import com.eruannie_9.booklinggear.screen.config.warning.WarningScreen;
import com.eruannie_9.booklinggear.screen.config.warning.options.AbstractWarningOption;
import com.eruannie_9.booklinggear.screen.list.ListEditScreen;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigScreen
extends Screen {
    private final Screen parentScreen;
    private final ForgeConfigSpec specification;
    private ConfigOptionList optionList;
    private Button tooltipButton;
    private boolean tooltipEnabled = true;
    public Map<String, Object> currentValues = new HashMap<String, Object>();
    private List<ConfigOptionList.ConfigEntry> allEntries = new ArrayList<ConfigOptionList.ConfigEntry>();
    private AnimatedScreenTitle animatedTitle;
    public List<Component> tooltipLines;
    public int tooltipX;
    public int tooltipY;

    public ConfigScreen(Screen parentScreen, String title, ForgeConfigSpec specification) {
        super((Component)Component.m_237113_((String)title));
        this.parentScreen = parentScreen;
        this.specification = specification;
    }

    protected void m_7856_() {
        super.m_7856_();
        int topY = 32;
        int bottomY = this.f_96544_ - 44;
        int listHeight = bottomY - topY;
        this.optionList = new ConfigOptionList(this.f_96541_, this.f_96543_, listHeight, topY, 24);
        this.m_142416_((GuiEventListener)this.optionList);
        this.m_142416_((GuiEventListener)ScrollSlider.attach(this.optionList).widget());
        if (this.allEntries.isEmpty()) {
            this.buildEntryCache();
        }
        this.optionList.m_6702_().clear();
        for (ConfigOptionList.ConfigEntry entry : this.allEntries) {
            if (!(entry.progress() > 0.0f)) continue;
            this.optionList.addConfigEntry(entry);
        }
        this.m_142416_((GuiEventListener)this.makeSaveButton());
        this.m_142416_((GuiEventListener)this.makeCancelButton());
        this.tooltipButton = this.makeTooltipToggleButton();
        this.m_142416_((GuiEventListener)this.tooltipButton);
        if (!this.currentValues.isEmpty()) {
            this.applyCurrentValues(this.currentValues);
        }
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
        this.animatedTitle.avoidRightEdge(() -> this.tooltipButton != null ? this.tooltipButton.m_252754_() : this.f_96543_);
    }

    private void buildEntryCache() {
        GroupEntry group;
        this.allEntries = ConfigEntryCollector.collect(this.specification, this);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        HashSet keepEntries = new HashSet();
        ArrayDeque<GroupEntry> groupStack = new ArrayDeque<GroupEntry>();
        for (ConfigOptionList.ConfigEntry entry : this.allEntries) {
            if (entry instanceof GroupEntry) {
                group = (GroupEntry)entry;
                while (groupStack.size() > group.depth) {
                    groupStack.pollLast();
                }
                groupStack.addLast(group);
                continue;
            }
            if (!(entry instanceof ValueEntry)) continue;
            ValueEntry valueEntry = (ValueEntry)entry;
            boolean show = VisibilityChecker.isVisible(valueEntry.fullPath(), defaults);
            entry.snapInitial(show);
            if (!show) continue;
            keepEntries.addAll(groupStack);
        }
        for (ConfigOptionList.ConfigEntry entry : this.allEntries) {
            if (!(entry instanceof GroupEntry) || keepEntries.contains((Object)(group = (GroupEntry)entry))) continue;
            group.snapInitial(false);
        }
    }

    public void m_6574_(@NotNull Minecraft minecraft, int Width, int Height) {
        double scrollRatio = this.optionList != null && this.optionList.m_93518_() > 0 ? this.optionList.m_93517_() / (double)this.optionList.m_93518_() : 0.0;
        this.currentValues = this.captureValues();
        super.m_6574_(minecraft, Width, Height);
        if (this.optionList != null && this.optionList.m_93518_() > 0) {
            this.optionList.m_93410_(scrollRatio * (double)this.optionList.m_93518_());
        }
        this.applyCurrentValues(this.currentValues);
    }

    private Map<String, Object> captureValues() {
        HashMap<String, Object> captured = new HashMap<String, Object>();
        if (this.optionList == null) {
            return captured;
        }
        for (ConfigOptionList.ConfigEntry entry : this.optionList.m_6702_()) {
            Object value;
            if (!(entry instanceof ValueEntry)) continue;
            ValueEntry valueEntry = (ValueEntry)entry;
            String path = valueEntry.fullPath();
            ForgeConfigSpec.ConfigValue<?> configValue = valueEntry.configValue();
            AbstractWidget widget = valueEntry.widget();
            if (widget instanceof Checkbox) {
                Checkbox checkbox = (Checkbox)widget;
                value = checkbox.m_93840_();
            } else if (widget instanceof EditBox) {
                EditBox editBox = (EditBox)widget;
                value = editBox.m_94155_();
            } else if (widget instanceof CycleButton) {
                CycleButton cycleButton = (CycleButton)widget;
                value = cycleButton.m_168883_();
            } else {
                value = this.currentValues.getOrDefault(path, configValue.get());
            }
            if (value == null) continue;
            captured.put(path, value);
        }
        return captured;
    }

    private void applyCurrentValues(Map<String, Object> values) {
        if (this.optionList == null) {
            return;
        }
        for (ConfigOptionList.ConfigEntry entry : this.optionList.m_6702_()) {
            String string;
            Checkbox checkbox;
            ValueEntry valueEntry;
            Object value;
            if (!(entry instanceof ValueEntry) || (value = values.get((valueEntry = (ValueEntry)entry).fullPath())) == null) continue;
            AbstractWidget widget = valueEntry.widget();
            if (widget instanceof Checkbox && (checkbox = (Checkbox)widget).m_93840_() != ((Boolean)value).booleanValue()) {
                checkbox.m_5691_();
                continue;
            }
            if (widget instanceof EditBox) {
                EditBox editBox = (EditBox)widget;
                editBox.m_94144_(String.valueOf(value));
                continue;
            }
            if (widget instanceof CycleButton) {
                CycleButton cycleButton = (CycleButton)widget;
                this.setCycle(cycleButton, value);
                continue;
            }
            if (widget != null) continue;
            this.currentValues.put(valueEntry.fullPath(), value);
            if (!(value instanceof String) || !ColorUtil.isHexColor(string = (String)value) || string.equals(String.valueOf(valueEntry.configValue().get()))) continue;
            valueEntry.updateEditButtonLabel(string);
        }
    }

    private <T> void setCycle(CycleButton<T> cycleButton, Object value) {
        cycleButton.m_168892_(value);
    }

    private Button makeSaveButton() {
        return Button.m_253074_((Component)Component.m_237113_((String)"Save"), button -> this.onSaveClick()).m_252794_(this.f_96543_ / 2 - 105, this.f_96544_ - 32).m_253046_(100, 20).m_253136_();
    }

    private Button makeCancelButton() {
        return Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), button -> Minecraft.m_91087_().m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 32).m_253046_(100, 20).m_253136_();
    }

    private Button makeTooltipToggleButton() {
        int buttonWidth = 100;
        return Button.m_253074_((Component)this.tooltipLabel(), button -> this.toggleTooltip()).m_252794_(this.f_96543_ - buttonWidth - 10, 10).m_253046_(buttonWidth, 20).m_253136_();
    }

    private void toggleTooltip() {
        this.tooltipEnabled = !this.tooltipEnabled;
        this.tooltipButton.m_93666_(this.tooltipLabel());
    }

    private Component tooltipLabel() {
        return Component.m_237113_((String)("Comments: " + (this.tooltipEnabled ? "ON" : "OFF")));
    }

    public boolean isTooltipEnabled() {
        return this.tooltipEnabled;
    }

    private void onSaveClick() {
        Map<String, Object> proposedValues = this.captureValues();
        ArrayList<Component> warningMessages = new ArrayList<Component>();
        ArrayList warningOptions = new ArrayList();
        for (ConfigOptionList.ConfigEntry entry : this.optionList.m_6702_()) {
            if (!(entry instanceof ValueEntry)) continue;
            ValueEntry value = (ValueEntry)entry;
            ForgeConfigSpec.ConfigValue<?> configValue = value.configValue();
            Object newValue = proposedValues.get(value.fullPath());
            for (AbstractWarningOption<?> option : WarningConfigChecker.getTriggeredOptions(configValue, newValue)) {
                warningMessages.add(option.warningMessage());
                warningOptions.add(option);
            }
        }
        if (!warningMessages.isEmpty()) {
            this.currentValues = proposedValues;
            Minecraft.m_91087_().m_91152_((Screen)new WarningScreen(new ArrayList<Component>(new LinkedHashSet(warningMessages)), () -> {
                warningOptions.forEach(AbstractWarningOption::markSeen);
                this.saveAndExit();
            }, () -> Minecraft.m_91087_().m_91152_((Screen)this)));
            return;
        }
        this.currentValues = proposedValues;
        this.saveAndExit();
    }

    private void saveAndExit() {
        try {
            Map<String, Object> updatedValues = this.captureValues();
            LinkedHashMap<String, Object> changedValues = new LinkedHashMap<String, Object>();
            for (ConfigOptionList.ConfigEntry configEntry : this.optionList.m_6702_()) {
                Object rawNew;
                Object typedNew;
                ValueEntry value;
                ForgeConfigSpec.ConfigValue<?> cfg;
                Object oldValue;
                if (!(configEntry instanceof ValueEntry) || Objects.equals(oldValue = (cfg = (value = (ValueEntry)configEntry).configValue()).get(), typedNew = ConfigScreen.coerceToSpecType(cfg, rawNew = updatedValues.get(value.fullPath())))) continue;
                changedValues.put(value.fullPath(), typedNew);
            }
            for (Map.Entry entry : changedValues.entrySet()) {
                this.setSpecValue((String)entry.getKey(), entry.getValue());
            }
            if (!changedValues.isEmpty()) {
                BooklingGear.LOGGER.info("Updated config values:");
                changedValues.forEach((key, val) -> BooklingGear.LOGGER.info("  {} \u2192 {}", key, val));
            }
            this.specification.save();
            if (!changedValues.isEmpty()) {
                MinecraftForge.EVENT_BUS.post((Event)new ConfigChangedEvent(changedValues));
            }
        }
        catch (Exception ex) {
            BooklingGear.LOGGER.error("Error while saving config", (Throwable)ex);
        }
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    private <T> void setSpecValue(String path, Object value) {
        for (ConfigOptionList.ConfigEntry entry : this.optionList.m_6702_()) {
            ValueEntry valueEntry;
            if (!(entry instanceof ValueEntry) || !(valueEntry = (ValueEntry)entry).fullPath().equals(path)) continue;
            valueEntry.configValue().set(value);
        }
    }

    public void onColorEdits(String path, String hex) {
        this.currentValues.put(path, hex);
    }

    public void onListEdits(String path, List<String> values) {
        this.currentValues.put(path, values);
    }

    public void openColorEditScreen(String label, String path, String originalHex) {
        String s;
        this.currentValues = this.captureValues();
        Object stored = this.currentValues.get(path);
        if (stored instanceof String && ColorUtil.isHexColor(s = (String)stored)) {
            originalHex = s;
        }
        Minecraft.m_91087_().m_91152_((Screen)new ColorPickerScreen(this, label, path, originalHex));
    }

    public void openListEditScreen(String label, String path, ForgeConfigSpec.ConfigValue<List<String>> cvList) {
        ArrayList<String> initial;
        this.currentValues = this.captureValues();
        Object stored = this.currentValues.get(path);
        if (stored instanceof List) {
            List list;
            List tmp = list = (List)stored;
            initial = new ArrayList(tmp);
        } else {
            initial = new ArrayList<String>((Collection)cvList.get());
        }
        Minecraft.m_91087_().m_91152_((Screen)new ListEditScreen(this, label, path, initial));
    }

    private void applyVisibilityFilter(Map<String, Object> values) {
        for (ConfigOptionList.ConfigEntry entry : this.allEntries) {
            if (!(entry instanceof ValueEntry)) continue;
            ValueEntry valueEntry = (ValueEntry)entry;
            entry.setTarget(VisibilityChecker.isVisible(valueEntry.fullPath(), values));
        }
        for (int i = this.allEntries.size() - 1; i >= 0; --i) {
            ConfigOptionList.ConfigEntry valueEntry = this.allEntries.get(i);
            if (!(valueEntry instanceof GroupEntry)) continue;
            GroupEntry group = (GroupEntry)valueEntry;
            boolean anyVisible = false;
            for (int j = i + 1; j < this.allEntries.size(); ++j) {
                ConfigOptionList.ConfigEntry next = this.allEntries.get(j);
                if (next instanceof GroupEntry) {
                    GroupEntry sibling = (GroupEntry)next;
                    if (sibling.depth <= group.depth) break;
                }
                if (!next.isTargetVisible()) continue;
                anyVisible = true;
                break;
            }
            group.setTarget(anyVisible);
        }
        boolean removing = false;
        Iterator iterator = this.optionList.m_6702_().iterator();
        while (iterator.hasNext()) {
            ConfigOptionList.ConfigEntry entry = (ConfigOptionList.ConfigEntry)((Object)iterator.next());
            entry.tickAnimator();
            if (!entry.isTargetVisible() && !entry.isFinished()) {
                removing = true;
            }
            if (!entry.isFinished()) continue;
            iterator.remove();
        }
        if (!removing) {
            List children = this.optionList.m_6702_();
            for (ConfigOptionList.ConfigEntry entry : this.allEntries) {
                int idx;
                if (children.contains((Object)entry) || entry.isFinished() || !entry.isTargetVisible()) continue;
                entry.restartVisible();
                int pos = this.allEntries.indexOf((Object)entry);
                for (idx = 0; idx < children.size() && this.allEntries.indexOf(children.get(idx)) < pos; ++idx) {
                }
                children.add(idx, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = this.optionList.m_6375_(mouseX, mouseY, button);
        if (!handled) {
            handled = super.m_6375_(mouseX, mouseY, button);
        }
        if (button == 0) {
            boolean overEditBox;
            List<EditBox> list = ValueEntry.EDIT_BOXES;
            synchronized (list) {
                overEditBox = ValueEntry.EDIT_BOXES.stream().anyMatch(box -> box.m_5953_(mouseX, mouseY));
            }
            if (overEditBox) {
                for (EditBox box2 : ValueEntry.EDIT_BOXES) {
                    if (!box2.m_93696_()) continue;
                    this.m_7522_((GuiEventListener)box2);
                    break;
                }
            } else {
                list = ValueEntry.EDIT_BOXES;
                synchronized (list) {
                    for (EditBox box3 : ValueEntry.EDIT_BOXES) {
                        box3.m_93692_(false);
                    }
                }
                this.m_7522_(null);
            }
        }
        return handled;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button) || this.optionList.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY, button, deltaY, deltaX) || this.optionList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_5534_(char character, int modifiers) {
        return super.m_5534_(character, modifiers) || this.m_7222_() != null && this.m_7222_().m_5534_(character, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers) || this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.applyVisibilityFilter(this.captureValues());
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.f_96547_, this.f_96543_);
        if (this.tooltipEnabled && this.tooltipLines != null) {
            guiGraphics.m_280666_(this.f_96547_, this.tooltipLines, this.tooltipX, this.tooltipY);
            this.tooltipLines = null;
        }
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
    }

    private static Object coerceToSpecType(ForgeConfigSpec.ConfigValue<?> cfg, Object raw) {
        Object current = ConfigScreen.safeGet(cfg);
        if (current == null || raw == null) {
            return raw != null ? raw : current;
        }
        if (current instanceof Enum && raw instanceof Enum) {
            return raw;
        }
        if (current instanceof List) {
            return raw;
        }
        if (current instanceof Boolean) {
            Boolean b = ConfigScreen.tryParseBoolean(raw);
            return b != null ? b : current;
        }
        if (current instanceof Integer) {
            Integer i = ConfigScreen.tryParseInt(raw);
            return i != null ? i : current;
        }
        if (current instanceof Long) {
            Long l = ConfigScreen.tryParseLong(raw);
            return l != null ? l : current;
        }
        if (current instanceof Float) {
            Double d = ConfigScreen.tryParseDouble(raw);
            return d != null ? Float.valueOf(d.floatValue()) : current;
        }
        if (current instanceof Double) {
            Double d = ConfigScreen.tryParseDouble(raw);
            return d != null ? d : current;
        }
        if (current instanceof String) {
            return String.valueOf(raw);
        }
        return raw;
    }

    private static Object safeGet(ForgeConfigSpec.ConfigValue<?> cfg) {
        try {
            return cfg.get();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String normalizeNumeric(String s) {
        boolean hasDot;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return s;
        }
        boolean hasComma = (s = s.replace(" ", "").replace("_", "")).indexOf(44) >= 0;
        boolean bl = hasDot = s.indexOf(46) >= 0;
        if (hasComma && hasDot) {
            int lastComma = s.lastIndexOf(44);
            int lastDot = s.lastIndexOf(46);
            if (lastDot > lastComma) {
                s = s.replace(",", "");
            } else {
                s = s.replace(".", "");
                s = s.replace(',', '.');
            }
        } else if (hasComma) {
            s = s.replace(',', '.');
        }
        return s;
    }

    private static Double tryParseDouble(Object raw) {
        if (raw instanceof Number) {
            Number n = (Number)raw;
            return n.doubleValue();
        }
        if (raw instanceof CharSequence) {
            CharSequence cs = (CharSequence)raw;
            String s = ConfigScreen.normalizeNumeric(cs.toString());
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Integer tryParseInt(Object raw) {
        if (raw instanceof Number) {
            Number n = (Number)raw;
            return n.intValue();
        }
        if (raw instanceof CharSequence) {
            CharSequence cs = (CharSequence)raw;
            String s = ConfigScreen.normalizeNumeric(cs.toString());
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                double d = Double.parseDouble(s);
                return (int)Math.round(d);
            }
            catch (NumberFormatException ignored) {
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Long tryParseLong(Object raw) {
        if (raw instanceof Number) {
            Number n = (Number)raw;
            return n.longValue();
        }
        if (raw instanceof CharSequence) {
            CharSequence cs = (CharSequence)raw;
            String s = ConfigScreen.normalizeNumeric(cs.toString());
            if (s == null || s.isEmpty()) {
                return null;
            }
            try {
                double d = Double.parseDouble(s);
                return Math.round(d);
            }
            catch (NumberFormatException ignored) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static Boolean tryParseBoolean(Object raw) {
        if (raw instanceof Boolean) {
            Boolean b = (Boolean)raw;
            return b;
        }
        if (raw instanceof CharSequence) {
            CharSequence cs = (CharSequence)raw;
            String s = cs.toString().trim().toLowerCase();
            if ("true".equals(s) || "yes".equals(s) || "on".equals(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equals(s) || "no".equals(s) || "off".equals(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

