/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
final class WidgetFactory {
    private WidgetFactory() {
    }

    static AbstractWidget create(ForgeConfigSpec.ConfigValue<?> configValue) {
        String stringValue;
        Object currentValue = configValue.get();
        if (currentValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)currentValue;
            return Checkbox.m_306644_((Component)Component.m_237119_(), (Font)Minecraft.m_91087_().f_91062_).m_307310_(0, 0).m_307950_(booleanValue.booleanValue()).m_307240_();
        }
        if (currentValue instanceof Number || currentValue instanceof String && !ColorUtil.isHexColor(stringValue = (String)currentValue)) {
            EditBox editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 100, 20, (Component)Component.m_237119_());
            editBox.m_94199_(512);
            editBox.m_94144_(String.valueOf(currentValue));
            if (currentValue instanceof Number) {
                editBox.m_94153_(WidgetFactory::numericCandidate);
            }
            return editBox;
        }
        if (currentValue instanceof Enum) {
            Enum enumValue = (Enum)currentValue;
            List<Enum> enumValues = Arrays.asList((Enum[])enumValue.getDeclaringClass().getEnumConstants());
            return CycleButton.m_168894_(e -> Component.m_237113_((String)e.name())).m_232502_(enumValues).m_168929_().m_168948_((Object)enumValue).m_168936_(0, 0, 100, 20, (Component)Component.m_237119_(), (button, value) -> {});
        }
        return null;
    }

    private static boolean numericCandidate(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("0123456789.,-+eE _".indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }
}

