/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.update;

import com.eruannie_9.booklinggear.BooklingGear;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class WorkerUpdater {
    private static final String ENDPOINT = "https://eruannie9.org";
    private static final HttpClient HTTP = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static CompletableFuture<List<Result>> CACHE;

    private WorkerUpdater() {
    }

    public static synchronized CompletableFuture<List<Result>> fetchAll(String mcVersion) {
        if (CACHE != null) {
            return CACHE;
        }
        CACHE = CompletableFuture.supplyAsync(() -> {
            try {
                HttpRequest request = HttpRequest.newBuilder(URI.create(ENDPOINT)).header("Accept", "application/json").header("User-Agent", "BooklingGearMod/5.0").build();
                String body = HTTP.send(request, HttpResponse.BodyHandlers.ofString()).body();
                JsonElement root = JsonParser.parseString((String)body);
                ArrayList<Result> out = new ArrayList<Result>();
                if (root.isJsonArray()) {
                    for (JsonElement element : root.getAsJsonArray()) {
                        WorkerUpdater.addIfMatches(element.getAsJsonObject(), mcVersion, out);
                    }
                } else {
                    WorkerUpdater.addIfMatches(root.getAsJsonObject(), mcVersion, out);
                }
                return out;
            }
            catch (Exception exception) {
                BooklingGear.LOGGER.debug("[UpdateChecker] Worker unreachable", (Throwable)exception);
                return List.of();
            }
        });
        return CACHE;
    }

    private static void addIfMatches(JsonObject object, String mcVersion, List<Result> list) {
        JsonObject version = object.getAsJsonObject("versions");
        if (!version.has(mcVersion)) {
            return;
        }
        String projectId = object.get("projectId").getAsString();
        String latest = version.get(mcVersion).getAsString();
        String url = object.get("url").getAsString();
        list.add(new Result(projectId, latest, url));
    }

    public static boolean isSameVersion(String a, String b) {
        String[] x = a.split("\\.");
        String[] y = b.split("\\.");
        int max = Math.max(x.length, y.length);
        for (int i = 0; i < max; ++i) {
            int yi;
            int xi = i < x.length ? WorkerUpdater.parseIntSafe(x[i]) : 0;
            int n = yi = i < y.length ? WorkerUpdater.parseIntSafe(y[i]) : 0;
            if (xi == yi) continue;
            return false;
        }
        return true;
    }

    private static int parseIntSafe(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public record Result(String projectId, String latestVersion, String url) {
    }
}

