/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util.scroll;

import com.eruannie_9.booklinggear.ModConfiguration;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class ScrollSlider {
    private static final int BAR_WIDTH = 6;
    private static final int MIN_KNOB_HEIGHT = 12;
    private static final int RIGHT_PADDING = 4;
    private static final int TRACK_COLOR = -16777216;
    private static final int BODY_COLOR = -8355712;
    private static final int HIGHLIGHT_COLOR = -4144960;
    private static final int SHADOW_COLOR = -12566464;
    private static final int BODY_HOVER_COLOR = -5921371;
    private final Knob sliderKnob;

    private ScrollSlider(AbstractSelectionList<?> targetList) {
        this.sliderKnob = new Knob(targetList);
    }

    public static ScrollSlider attach(AbstractSelectionList<?> targetList) {
        return new ScrollSlider(targetList);
    }

    public Knob widget() {
        return this.sliderKnob;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Knob
    extends AbstractWidget {
        private static final double SMOOTHING_TAU_SEC = 0.15;
        private final AbstractSelectionList<?> parentList;
        private boolean dragging;
        private double dragOffsetPx;
        private double smoothedHeight;
        private long lastFrameMillis;

        private Knob(AbstractSelectionList<?> parentList) {
            super(0, 0, 6, 12, (Component)Component.m_237119_());
            this.parentList = parentList;
            this.smoothedHeight = this.calculateKnobHeight();
            this.lastFrameMillis = Util.m_137550_();
        }

        private int trackLeft() {
            return this.parentList.m_307439_() - 6 - 4;
        }

        private int trackTop() {
            return this.parentList.m_252907_();
        }

        private int trackBottom() {
            return this.parentList.m_306468_();
        }

        private int trackHeight() {
            return Math.max(1, this.trackBottom() - this.trackTop());
        }

        private double maxScrollAmount() {
            return Math.max(1.0, (double)this.parentList.m_93518_());
        }

        private int calculateKnobHeight() {
            int visible = this.trackHeight();
            int height = visible * visible / (int)this.maxScrollAmount();
            return Mth.m_14045_((int)height, (int)12, (int)(visible - 8));
        }

        private static boolean isPrimaryMouseDown() {
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            return GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
        }

        public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.dragging && !Knob.isPrimaryMouseDown()) {
                this.dragging = false;
            }
            if (this.parentList.m_93518_() <= 0) {
                return;
            }
            double desiredHeight = this.calculateKnobHeight();
            if (((Boolean)ModConfiguration.ANIMATIONS_ENABLED.get()).booleanValue()) {
                long nowMillis = Util.m_137550_();
                double deltaSec = Math.min(0.25, (double)(nowMillis - this.lastFrameMillis) / 1000.0);
                this.lastFrameMillis = nowMillis;
                double alpha = 1.0 - Math.exp(-deltaSec / 0.15);
                this.smoothedHeight += (desiredHeight - this.smoothedHeight) * alpha;
                if (Math.abs(this.smoothedHeight - desiredHeight) < 0.05) {
                    this.smoothedHeight = desiredHeight;
                }
            } else {
                this.smoothedHeight = desiredHeight;
                this.lastFrameMillis = Util.m_137550_();
            }
            this.m_93674_(6);
            this.m_293384_((int)Math.round(this.smoothedHeight));
            guiGraphics.m_280509_(this.trackLeft(), this.trackTop(), this.trackLeft() + 6, this.trackBottom(), -16777216);
            if (this.dragging) {
                this.moveTo((double)mouseY - this.dragOffsetPx - (double)this.trackTop());
            }
            int availableSpace = this.trackHeight() - this.m_93694_();
            int newX = this.trackLeft();
            int newY = this.trackTop() + (int)(this.parentList.m_93517_() * (double)availableSpace / this.maxScrollAmount());
            this.m_252865_(newX);
            this.m_253211_(newY);
            int bodyColor = this.m_5953_(mouseX, mouseY) || this.dragging ? -5921371 : -8355712;
            int l = this.m_252754_();
            int r = l + 6;
            int t = this.m_252907_();
            int b = t + this.m_93694_();
            guiGraphics.m_280509_(l, t, r, t + 1, -4144960);
            guiGraphics.m_280509_(l, t, l + 1, b, -4144960);
            guiGraphics.m_280509_(r - 1, t, r, b, -12566464);
            guiGraphics.m_280509_(l, b - 1, r, b, -12566464);
            guiGraphics.m_280509_(l + 1, t + 1, r - 1, b - 1, bodyColor);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.trackLeft() || mouseX >= (double)(this.trackLeft() + 6) || mouseY < (double)this.trackTop() || mouseY >= (double)this.trackBottom()) {
                return false;
            }
            if (this.m_5953_(mouseX, mouseY)) {
                this.dragOffsetPx = mouseY - (double)this.m_252907_();
                this.dragging = true;
            } else {
                this.jumpTo(mouseY);
                this.dragging = true;
                this.dragOffsetPx = Math.min(Math.max(0.0, mouseY - (double)this.m_252907_()), (double)this.m_93694_());
            }
            return true;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
            if (!this.dragging || button != 0) {
                return false;
            }
            this.moveTo(mouseY - this.dragOffsetPx - (double)this.trackTop());
            return true;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (button == 0 && this.dragging) {
                this.dragging = false;
                return true;
            }
            return false;
        }

        private void moveTo(double newTopPx) {
            int availableSpace = this.trackHeight() - (int)Math.round(this.smoothedHeight);
            if (availableSpace <= 0) {
                this.parentList.m_93410_(0.0);
                return;
            }
            newTopPx = Mth.m_14008_((double)newTopPx, (double)0.0, (double)availableSpace);
            this.parentList.m_93410_(newTopPx / (double)availableSpace * (double)this.parentList.m_93518_());
        }

        private void jumpTo(double mouseY) {
            this.moveTo(mouseY - (double)this.trackTop() - this.smoothedHeight / 2.0);
        }

        protected void m_168797_(@NotNull NarrationElementOutput narration) {
        }
    }
}

