/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.BooklingGearClient;
import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.api.ModInfo;
import com.eruannie_9.booklinggear.api.ModInfoMessage;
import com.eruannie_9.booklinggear.api.ModInfoRegistry;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="booklinggear")
public class BooklingGear {
    public static final String MOD_ID = "booklinggear";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String IMC_REGISTER_METHOD = "booklinggear:register_mod_info";
    private static final Gson GSON = new Gson();

    public BooklingGear(IEventBus modEventBus, ModContainer container, Dist dist) {
        ModConfiguration.registerConfig(container);
        if (dist.isClient()) {
            BooklingGearClient.registerModBusEvents(modEventBus);
        }
        modEventBus.addListener(this::onProcessIMC);
    }

    public void onProcessIMC(InterModProcessEvent event) {
        event.getIMCStream().filter(message -> IMC_REGISTER_METHOD.equals(message.method())).forEach(message -> {
            Object payload = message.messageSupplier().get();
            try {
                if (payload instanceof String) {
                    String json = (String)payload;
                    ModInfo info = BooklingGear.parseJson(json);
                    ModInfoRegistry.register(info);
                    LOGGER.debug("Registered ModInfo via JSON IMC from {}: {}", (Object)message.senderModId(), (Object)info);
                } else if (payload instanceof ModInfoMessage) {
                    ModInfoMessage msg = (ModInfoMessage)payload;
                    ModInfo info = new ModInfo(msg.modid(), msg.displayName(), msg.link(), msg.noLinkMessage());
                    ModInfoRegistry.register(info);
                    LOGGER.debug("Registered ModInfo via typed IMC from {}: {}", (Object)message.senderModId(), (Object)info);
                } else {
                    LOGGER.warn("Unknown IMC payload from {}: {} (expected String JSON or ModInfoMessage)", (Object)message.senderModId(), (Object)payload.getClass().getName());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to handle IMC from {}: {}", (Object)message.senderModId(), (Object)ex.getMessage(), (Object)ex);
            }
        });
    }

    private static ModInfo parseJson(String json) {
        try {
            JsonObject object = (JsonObject)GSON.fromJson(json, JsonObject.class);
            String modid = object.get("modid").getAsString();
            String display = object.has("displayName") ? object.get("displayName").getAsString() : modid;
            String link = object.has("link") ? object.get("link").getAsString() : null;
            String msg = object.has("noLinkMessage") ? object.get("noLinkMessage").getAsString() : "No link was provided for " + display + ".";
            return new ModInfo(modid, display, link, msg);
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid ModInfo JSON: " + json, (Throwable)e);
        }
    }
}

