/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.BooklingGear;
import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import com.eruannie_9.booklinggear.update.UpdateAnnouncer;
import com.eruannie_9.booklinggear.update.WorkerUpdater;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

public class BooklingGearClient {
    public static void registerModBusEvents(IEventBus modEventBus) {
        modEventBus.addListener(BooklingGearClient::onClientSetup);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            String mc = SharedConstants.getCurrentVersion().getName();
            WorkerUpdater.fetchAll(mc).thenAccept(results -> {
                for (WorkerUpdater.Result value : results) {
                    String modId = value.projectId();
                    Optional opt = ModList.get().getModContainerById(modId);
                    if (opt.isEmpty()) continue;
                    String currentVersion = ((ModContainer)opt.get()).getModInfo().getVersion().toString();
                    String displayName = ((ModContainer)opt.get()).getModInfo().getDisplayName();
                    if (!WorkerUpdater.isSameVersion(value.latestVersion(), currentVersion)) {
                        UpdateAnnouncer.queue(modId, displayName, value.latestVersion(), currentVersion, value.url());
                        continue;
                    }
                    BooklingGear.LOGGER.debug("[{}] up\u2011to\u2011date ({})", (Object)displayName, (Object)currentVersion);
                }
            });
            JsonWarningList.load();
        });
    }
}

