/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.screen.GeneralConfigScreen;
import com.eruannie_9.booklinggear.util.CustomImageButton;
import com.eruannie_9.booklinggear.util.MirroredImageButton;
import com.eruannie_9.booklinggear.util.screen.GuiType;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.ScreenEvent;

@Mod(value="booklinggear", dist={Dist.CLIENT})
@EventBusSubscriber(modid="booklinggear", value={Dist.CLIENT})
public class GuiExecutor {
    private static final ResourceLocation BANNER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"booklinggear", (String)"textures/gui/config_banner.png");
    private static final ResourceLocation TEXT_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"booklinggear", (String)"textures/gui/config_banner_text.png");
    private static final ResourceLocation BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"booklinggear", (String)"textures/gui/config_book.png");
    private static final Map<Screen, MirroredImageButton> BANNER_BY_SCREEN = new WeakHashMap<Screen, MirroredImageButton>();
    private static final Map<Screen, CustomImageButton> BOOK_BY_SCREEN = new WeakHashMap<Screen, CustomImageButton>();
    private static final int BANNER_W = 22;
    private static final int BANNER_H = 8;
    private static final int BOOK_W = 20;
    private static final int BOOK_H = 20;
    private static final int BANNER_GAP = 6;
    private static final int BOOK_GAP = 6;
    private static final int BANNER_OFFSET_X = 6;
    private static final int BANNER_OFFSET_Y = 0;
    private static final int BOOK_OFFSET_X = 4;
    private static final int BOOK_OFFSET_Y = 0;
    private static final boolean BANNER_RIGHT_OF_ANCHOR = false;
    private static final boolean BOOK_RIGHT_OF_ANCHOR = false;
    private static final Set<String> MODS_KEYS = Set.of("fml.menu.mods", "neoforge.menu.mods", "menu.mods");
    private static final Set<String> OPTIONS_KEYS = Set.of("menu.options", "options.title");
    private static final Set<String> RESOURCEPACKS_KEYS = Set.of("options.resourcepack", "options.resource_packs", "options.resourcepacks");

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen;
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            return;
        }
        GuiType guiType = (GuiType)((Object)ModConfiguration.GUI_TYPE.get());
        if (guiType == GuiType.BANNER) {
            Screen s = event.getScreen();
            if (s instanceof TitleScreen || s instanceof PauseScreen) {
                GuiExecutor.addBannerButton(s, event);
            }
        } else if (guiType == GuiType.BOOK && (screen = event.getScreen()) instanceof OptionsScreen) {
            OptionsScreen opts = (OptionsScreen)screen;
            GuiExecutor.addBookButton(opts, event);
        }
    }

    private static void addBannerButton(Screen screen, ScreenEvent.Init.Post event) {
        boolean mirror = (Boolean)ModConfiguration.MIRROR.get();
        MirroredImageButton banner = new MirroredImageButton(0, 0, 22, 8, 0, 0, 8, BANNER_TEXTURE, 22, 16, b -> Minecraft.getInstance().setScreen((Screen)new GeneralConfigScreen(screen)), (Component)Component.empty(), mirror, TEXT_OVERLAY);
        BANNER_BY_SCREEN.put(screen, banner);
        event.addListener((GuiEventListener)banner);
    }

    private static void addBookButton(OptionsScreen screen, ScreenEvent.Init.Post event) {
        CustomImageButton book = new CustomImageButton(0, 0, 20, 20, 0, 0, 20, BOOK_TEXTURE, 20, 40, b -> Minecraft.getInstance().setScreen((Screen)new GeneralConfigScreen((Screen)screen)), (Component)Component.empty());
        BOOK_BY_SCREEN.put((Screen)screen, book);
        event.addListener((GuiEventListener)book);
    }

    @SubscribeEvent
    public static void onScreenRenderPre(ScreenEvent.Render.Pre event) {
        AbstractWidget anchor;
        if (!((Boolean)ModConfiguration.MAIN.get()).booleanValue()) {
            GuiExecutor.hideIfPresent(event.getScreen());
            return;
        }
        Screen s = event.getScreen();
        GuiType guiType = (GuiType)((Object)ModConfiguration.GUI_TYPE.get());
        if (s instanceof OptionsScreen) {
            boolean showBook;
            CustomImageButton book = BOOK_BY_SCREEN.get(s);
            boolean bl = showBook = guiType == GuiType.BOOK;
            if (book != null) {
                book.visible = showBook;
                book.active = showBook;
                if (!showBook) {
                    book.setFocused(false);
                } else {
                    anchor = GuiExecutor.findButtonByKeys(s, RESOURCEPACKS_KEYS);
                    if (anchor == null) {
                        anchor = GuiExecutor.findDoneButton(s);
                    }
                    if (anchor != null) {
                        GuiExecutor.anchorLeftOf(anchor, (AbstractWidget)book, 6, 4, 0);
                    } else {
                        book.setX(s.width - 20 - 8);
                        book.setY(8);
                    }
                }
            }
        }
        if (s instanceof TitleScreen || s instanceof PauseScreen) {
            boolean showBanner;
            MirroredImageButton banner = BANNER_BY_SCREEN.get(s);
            boolean bl = showBanner = guiType == GuiType.BANNER;
            if (banner != null) {
                banner.visible = showBanner;
                banner.active = showBanner;
                if (!showBanner) {
                    banner.setFocused(false);
                } else {
                    anchor = GuiExecutor.findButtonByKeys(s, MODS_KEYS);
                    if (anchor == null) {
                        anchor = GuiExecutor.findButtonByKeys(s, OPTIONS_KEYS);
                    }
                    if (anchor != null) {
                        GuiExecutor.anchorLeftOf(anchor, (AbstractWidget)banner, 6, 6, 0);
                    } else {
                        banner.setX(s.width / 2 - 122);
                        banner.setY(s.height / 4 + 108);
                    }
                }
            }
        }
    }

    private static void hideIfPresent(Screen s) {
        MirroredImageButton banner;
        CustomImageButton book = BOOK_BY_SCREEN.get(s);
        if (book != null) {
            book.visible = false;
            book.active = false;
            book.setFocused(false);
        }
        if ((banner = BANNER_BY_SCREEN.get(s)) != null) {
            banner.visible = false;
            banner.active = false;
            banner.setFocused(false);
        }
    }

    private static AbstractWidget findButtonByKeys(Screen screen, Set<String> keys) {
        for (GuiEventListener l : screen.children()) {
            TranslatableContents tc;
            AbstractWidget w;
            Component msg;
            ComponentContents componentContents;
            if (!(l instanceof AbstractWidget) || !((componentContents = (msg = (w = (AbstractWidget)l).getMessage()).getContents()) instanceof TranslatableContents) || !keys.contains((tc = (TranslatableContents)componentContents).getKey())) continue;
            return w;
        }
        return null;
    }

    private static AbstractWidget findDoneButton(Screen screen) {
        for (GuiEventListener l : screen.children()) {
            TranslatableContents tc;
            AbstractWidget w;
            Component msg;
            ComponentContents componentContents;
            if (!(l instanceof AbstractWidget) || !((componentContents = (msg = (w = (AbstractWidget)l).getMessage()).getContents()) instanceof TranslatableContents) || !"gui.done".equals((tc = (TranslatableContents)componentContents).getKey())) continue;
            return w;
        }
        return null;
    }

    private static void anchorLeftOf(AbstractWidget anchor, AbstractWidget who, int gap, int dx, int dy) {
        int x = anchor.getX() - gap - who.getWidth();
        int y = anchor.getY() + (anchor.getHeight() - who.getHeight()) / 2;
        who.setX(x + dx);
        who.setY(y + dy);
    }

    private static void anchorRightOf(AbstractWidget anchor, AbstractWidget who, int gap, int dx, int dy) {
        int x = anchor.getX() + anchor.getWidth() + gap;
        int y = anchor.getY() + (anchor.getHeight() - who.getHeight()) / 2;
        who.setX(x + dx);
        who.setY(y + dy);
    }
}

