/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.creative;

import com.eruannie_9.booklinggear.creative.FrameDataHandler;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AnimatedCreativeModeTab
extends CreativeModeTab {
    private final Supplier<ItemStack[]> frameSupplier;
    private final FrameDataHandler frameDataHandler;
    private final long frameInterval;
    private final boolean useRandomFrame;
    private final RandomSource randomGenerator = RandomSource.create();
    private long lastFrameCount = -1L;
    private ItemStack cachedIcon = ItemStack.EMPTY;
    private int previousFrameIndex = -1;

    public AnimatedCreativeModeTab(CreativeModeTab.Builder builder, Supplier<ItemStack[]> frameSupplier, long frameInterval, FrameDataHandler frameDataHandler, boolean useRandomFrame) {
        super(builder);
        this.frameSupplier = frameSupplier;
        this.frameInterval = frameInterval;
        this.frameDataHandler = frameDataHandler;
        this.useRandomFrame = useRandomFrame;
    }

    @NotNull
    public ItemStack getIconItem() {
        long currentTime = System.currentTimeMillis();
        long currentFrameCount = currentTime / this.frameInterval;
        if (currentFrameCount != this.lastFrameCount) {
            this.updateCachedIcon(currentFrameCount);
        }
        return this.cachedIcon;
    }

    private void updateCachedIcon(long frameCount) {
        int frameIndex;
        this.lastFrameCount = frameCount;
        this.randomGenerator.setSeed(frameCount);
        ItemStack[] frames = this.frameSupplier.get();
        if (frames.length == 0) {
            this.cachedIcon = ItemStack.EMPTY;
            return;
        }
        this.previousFrameIndex = frameIndex = this.selectFrameIndex(frames.length);
        ItemStack selectedFrame = frames[frameIndex].copy();
        if (this.frameDataHandler != null) {
            this.frameDataHandler.handle(selectedFrame, frameCount);
        }
        this.cachedIcon = selectedFrame;
    }

    private int selectFrameIndex(int frameCount) {
        if (this.useRandomFrame) {
            int randomIndex = this.randomGenerator.nextInt(frameCount);
            if (frameCount > 1 && randomIndex == this.previousFrameIndex) {
                return (randomIndex + 1) % frameCount;
            }
            return randomIndex;
        }
        return (this.previousFrameIndex + 1) % frameCount;
    }
}

