/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.packethandler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class PacketRegister {
    private static final String NETWORK_VERSION = "1";
    private static final Map<String, List<Registration<?>>> PENDING = new ConcurrentHashMap();

    private PacketRegister() {
    }

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(PacketRegister::onRegisterPayloads);
    }

    public static <MSG extends CustomPacketPayload> void register(String modid, Class<MSG> packetClass) {
        PacketRegister.queue(modid, packetClass, Flow.BIDIRECTIONAL, ThreadPolicy.MAIN, Phase.PLAY);
    }

    public static <MSG extends CustomPacketPayload> void register(String modid, Class<MSG> packetClass, Flow flow) {
        PacketRegister.queue(modid, packetClass, flow, ThreadPolicy.MAIN, Phase.PLAY);
    }

    public static <MSG extends CustomPacketPayload> void register(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.queue(modid, packetClass, flow, thread, Phase.PLAY);
    }

    public static <MSG extends CustomPacketPayload> void registerConfiguration(String modid, Class<MSG> packetClass, Flow flow, ThreadPolicy thread) {
        PacketRegister.queue(modid, packetClass, flow, thread, Phase.CONFIGURATION);
    }

    private static <MSG extends CustomPacketPayload> void queue(String modid, Class<MSG> cls, Flow flow, ThreadPolicy thread, Phase phase) {
        PENDING.computeIfAbsent(modid, k -> new ArrayList()).add(new Registration<MSG>(cls, flow, thread, phase));
    }

    private static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        if (PENDING.isEmpty()) {
            return;
        }
        PayloadRegistrar baseRegistrar = event.registrar(NETWORK_VERSION);
        for (List<Registration<?>> regs : PENDING.values()) {
            for (Registration<?> r : regs) {
                r.perform(baseRegistrar);
            }
        }
        PENDING.clear();
    }

    private static <T extends CustomPacketPayload> CustomPacketPayload.Type<T> findType(Class<T> cls) {
        try {
            Field f = cls.getField("TYPE");
            Object v = f.get(null);
            return (CustomPacketPayload.Type)v;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(PacketRegister.sigErr(cls, "public static CustomPacketPayload.Type<%s> TYPE"), e);
        }
    }

    private static <T extends CustomPacketPayload> StreamCodec<?, T> findRawCodec(Class<T> cls) {
        try {
            Field f = cls.getField("STREAM_CODEC");
            if (PacketRegister.isStaticStreamCodec(f)) {
                return (StreamCodec)f.get(null);
            }
        }
        catch (NoSuchFieldException f) {
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        for (Field f : cls.getFields()) {
            if (!PacketRegister.isStaticStreamCodec(f)) continue;
            try {
                return (StreamCodec)f.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(PacketRegister.sigErr(cls, "public static StreamCodec<?, %s> STREAM_CODEC"));
    }

    private static boolean isStaticStreamCodec(Field f) {
        int m = f.getModifiers();
        return Modifier.isPublic(m) && Modifier.isStatic(m) && StreamCodec.class.isAssignableFrom(f.getType());
    }

    private static <T extends CustomPacketPayload> StreamCodec<? super RegistryFriendlyByteBuf, T> asPlayCodec(StreamCodec<?, T> raw) {
        return raw;
    }

    private static <T extends CustomPacketPayload> StreamCodec<? super FriendlyByteBuf, T> asFriendlyCodec(StreamCodec<?, T> raw) {
        return raw;
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> findHandler(Class<T> cls) {
        try {
            MethodHandle exact = MethodHandles.publicLookup().findStatic(cls, "handle", MethodType.methodType(Void.TYPE, cls, IPayloadContext.class));
            MethodHandle adapted = exact.asType(MethodType.methodType(Void.TYPE, Object.class, IPayloadContext.class));
            return (payload, ctx) -> {
                try {
                    adapted.invokeExact(payload, ctx);
                }
                catch (Throwable t) {
                    throw PacketRegister.sneaky(t);
                }
            };
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException(PacketRegister.sigErr(cls, "public static void handle(%s, IPayloadContext)"), e);
        }
    }

    private static <T extends CustomPacketPayload> IPayloadHandler<T> guardByFlow(IPayloadHandler<T> user, Flow flow) {
        return switch (flow.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (p, ctx) -> {
                if (ctx.flow() == PacketFlow.SERVERBOUND) {
                    user.handle(p, ctx);
                }
            };
            case 1 -> (p, ctx) -> {
                if (ctx.flow() == PacketFlow.CLIENTBOUND) {
                    user.handle(p, ctx);
                }
            };
            case 2 -> user;
        };
    }

    private static String sigErr(Class<?> cls, String fmt) {
        return "Packet class " + cls.getName() + " must declare: " + String.format(fmt, cls.getSimpleName());
    }

    private static RuntimeException sneaky(Throwable t) {
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            return re;
        }
        if (t instanceof Error) {
            Error e = (Error)t;
            throw e;
        }
        return new RuntimeException(t);
    }

    public static enum Flow {
        TO_SERVER,
        TO_CLIENT,
        BIDIRECTIONAL;

    }

    public static enum ThreadPolicy {
        MAIN,
        NETWORK;

    }

    private static enum Phase {
        PLAY,
        CONFIGURATION,
        COMMON;

    }

    private record Registration<T extends CustomPacketPayload>(Class<T> clazz, Flow flow, ThreadPolicy thread, Phase phase) {
        void perform(PayloadRegistrar base) {
            PayloadRegistrar registrar = this.thread == ThreadPolicy.NETWORK ? base.executesOn(HandlerThread.NETWORK) : base;
            CustomPacketPayload.Type<T> type = PacketRegister.findType(this.clazz);
            StreamCodec<?, T> raw = PacketRegister.findRawCodec(this.clazz);
            IPayloadHandler<T> handler = PacketRegister.guardByFlow(PacketRegister.findHandler(this.clazz), this.flow);
            block0 : switch (this.phase.ordinal()) {
                case 0: {
                    StreamCodec<RegistryFriendlyByteBuf, T> codec = PacketRegister.asPlayCodec(raw);
                    switch (this.flow.ordinal()) {
                        case 0: {
                            registrar.playToServer(type, codec, handler);
                            break;
                        }
                        case 1: {
                            registrar.playToClient(type, codec, handler);
                            break;
                        }
                        case 2: {
                            registrar.playBidirectional(type, codec, handler);
                        }
                    }
                    break;
                }
                case 1: {
                    StreamCodec<FriendlyByteBuf, T> codec = PacketRegister.asFriendlyCodec(raw);
                    switch (this.flow.ordinal()) {
                        case 0: {
                            registrar.configurationToServer(type, codec, handler);
                            break;
                        }
                        case 1: {
                            registrar.configurationToClient(type, codec, handler);
                            break;
                        }
                        case 2: {
                            registrar.configurationBidirectional(type, codec, handler);
                        }
                    }
                    break;
                }
                case 2: {
                    StreamCodec<FriendlyByteBuf, T> codec = PacketRegister.asFriendlyCodec(raw);
                    switch (this.flow.ordinal()) {
                        case 0: {
                            registrar.commonToServer(type, codec, handler);
                            break block0;
                        }
                        case 1: {
                            registrar.commonToClient(type, codec, handler);
                            break block0;
                        }
                        case 2: {
                            registrar.commonBidirectional(type, codec, handler);
                        }
                    }
                }
            }
        }
    }
}

