/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.register;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class DeferredRegisters {
    private final String modId;
    private final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registries = new HashMap();
    private final Set<ResourceKey<? extends Registry<?>>> hasEntries = new HashSet();

    public DeferredRegisters(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public <T> DeferredRegister<T> getOrCreateRegistry(ResourceKey<? extends Registry<T>> key) {
        DeferredRegister<?> existing = this.registries.get(key);
        if (existing != null) {
            return existing;
        }
        DeferredRegister created = DeferredRegister.create(key, (String)this.modId);
        this.registries.put(key, created);
        return created;
    }

    public <T> void markHasEntries(ResourceKey<? extends Registry<T>> key) {
        this.hasEntries.add(key);
    }

    public void register(IEventBus eventBus) {
        this.registries.forEach((key, deferredRegister) -> {
            if (this.hasEntries.contains(key)) {
                deferredRegister.register(eventBus);
            }
        });
    }
}

