/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.register;

import com.eruannie_9.booklinggear.register.DeferredRegisters;
import com.mojang.serialization.MapCodec;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class RegistrationHelper {
    private final DeferredRegisters deferredRegisters;

    public RegistrationHelper(DeferredRegisters deferredRegisters) {
        this.deferredRegisters = deferredRegisters;
    }

    public <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> blockSupplier, Item.Properties itemProperties) {
        return this.registerBlock(name, blockSupplier, itemProperties, BlockItem::new);
    }

    public <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> blockSupplier, Item.Properties itemProperties, BiFunction<T, Item.Properties, ? extends Item> itemFactory) {
        DeferredRegister blockRegistry = this.deferredRegisters.getOrCreateRegistry(Registries.BLOCK);
        this.deferredRegisters.markHasEntries(Registries.BLOCK);
        DeferredHolder blockDH = blockRegistry.register(name, blockSupplier);
        if (itemProperties != null && itemFactory != null) {
            DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(Registries.ITEM);
            this.deferredRegisters.markHasEntries(Registries.ITEM);
            itemRegistry.register(name, () -> (Item)itemFactory.apply((Block)blockDH.get(), itemProperties));
        }
        return blockDH;
    }

    private <T extends Block> void registerBlockItem(String name, DeferredHolder<Block, T> block, Item.Properties itemProperties) {
        DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(Registries.ITEM);
        this.deferredRegisters.markHasEntries(Registries.ITEM);
        itemRegistry.register(name, () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public <T extends Item> DeferredHolder<Item, T> registerItem(String name, Supplier<T> itemSupplier) {
        DeferredRegister itemRegistry = this.deferredRegisters.getOrCreateRegistry(Registries.ITEM);
        this.deferredRegisters.markHasEntries(Registries.ITEM);
        return itemRegistry.register(name, itemSupplier);
    }

    public <T extends ParticleType<?>> DeferredHolder<ParticleType<?>, T> registerParticleType(String name, Supplier<T> particleSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.PARTICLE_TYPE);
        this.deferredRegisters.markHasEntries(Registries.PARTICLE_TYPE);
        return reg.register(name, particleSupplier);
    }

    public <T extends Feature<?>> DeferredHolder<Feature<?>, T> registerFeature(String name, Supplier<T> featureSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.FEATURE);
        this.deferredRegisters.markHasEntries(Registries.FEATURE);
        return reg.register(name, featureSupplier);
    }

    public <T extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<T>> registerBlockEntityType(String name, Supplier<BlockEntityType<T>> blockEntitySupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.BLOCK_ENTITY_TYPE);
        this.deferredRegisters.markHasEntries(Registries.BLOCK_ENTITY_TYPE);
        return reg.register(name, blockEntitySupplier);
    }

    public DeferredHolder<SoundEvent, SoundEvent> registerSound(String name) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.SOUND_EVENT);
        this.deferredRegisters.markHasEntries(Registries.SOUND_EVENT);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)this.deferredRegisters.getModId(), (String)name);
        return reg.register(name, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)id));
    }

    public <T extends MenuType<?>> DeferredHolder<MenuType<?>, T> registerMenuType(String name, Supplier<T> menuSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.MENU);
        this.deferredRegisters.markHasEntries(Registries.MENU);
        return reg.register(name, menuSupplier);
    }

    public <T extends RecipeSerializer<?>> DeferredHolder<RecipeSerializer<?>, T> registerRecipeSerializer(String name, Supplier<T> serializerSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.RECIPE_SERIALIZER);
        this.deferredRegisters.markHasEntries(Registries.RECIPE_SERIALIZER);
        return reg.register(name, serializerSupplier);
    }

    public <T extends MobEffect> DeferredHolder<MobEffect, T> registerMobEffect(String name, Supplier<T> effectSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.MOB_EFFECT);
        this.deferredRegisters.markHasEntries(Registries.MOB_EFFECT);
        return reg.register(name, effectSupplier);
    }

    public <P extends PlacementModifier> DeferredHolder<PlacementModifierType<?>, PlacementModifierType<P>> registerPlacementModifierType(String name, Supplier<? extends MapCodec<P>> codecSupplier) {
        DeferredRegister reg = this.deferredRegisters.getOrCreateRegistry(Registries.PLACEMENT_MODIFIER_TYPE);
        this.deferredRegisters.markHasEntries(Registries.PLACEMENT_MODIFIER_TYPE);
        return reg.register(name, () -> ((Supplier)codecSupplier)::get);
    }
}

