/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.api.ModInfo;
import com.eruannie_9.booklinggear.api.ModInfoRegistry;
import com.eruannie_9.booklinggear.screen.MissingModsScreen;
import com.eruannie_9.booklinggear.screen.ModConfigSelectionScreen;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.ButtonList;
import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import com.eruannie_9.booklinggear.screen.config.warning.WarningMessageScreen;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GeneralConfigScreen
extends Screen {
    private final Screen parentScreen;
    private ButtonList buttonList;
    private AnimatedScreenTitle animatedTitle;
    private static final int LIST_SPACING = 24;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 200;
    private static final int GAP_Y = 5;

    public GeneralConfigScreen(Screen parentScreen) {
        super((Component)Component.literal((String)"Bookling Gear Configuration"));
        this.parentScreen = parentScreen;
    }

    protected void init() {
        super.init();
        ArrayList<Button> mainButtons = new ArrayList<Button>();
        ArrayList<ModInfo> missingMods = new ArrayList<ModInfo>();
        for (ModInfo info : ModInfoRegistry.getAll()) {
            Button button;
            String modId = info.modid();
            Optional container = ModList.get().getModContainerById(modId);
            if (container.isEmpty()) {
                missingMods.add(info);
                continue;
            }
            String displayName = ((ModContainer)container.get()).getModInfo().getDisplayName();
            List<ModConfig> configs = this.getConfigsForMod(modId);
            if (configs.isEmpty()) {
                missingMods.add(info);
                continue;
            }
            if (configs.size() == 1) {
                ModConfig single = configs.get(0);
                if (single.getLoadedConfig() == null) {
                    button = Button.builder((Component)Component.literal((String)displayName), b -> this.minecraft.setScreen((Screen)new WarningMessageScreen(this, "The configuration file for '" + displayName + "' is not loaded."))).bounds(0, 0, 200, 20).build();
                } else {
                    ModConfigSpec spec = (ModConfigSpec)single.getSpec();
                    button = Button.builder((Component)Component.literal((String)displayName), b -> this.minecraft.setScreen((Screen)new ConfigScreen(this, "Configuration for " + displayName, spec))).bounds(0, 0, 200, 20).build();
                }
            } else {
                button = Button.builder((Component)Component.literal((String)displayName), b -> this.minecraft.setScreen((Screen)new ModConfigSelectionScreen(this, displayName, configs))).bounds(0, 0, 200, 20).build();
            }
            mainButtons.add(button);
        }
        int listTop = 32;
        boolean narrow = this.width < 460;
        int bannerH = narrow ? 80 : 60;
        int listBottom = this.height - bannerH;
        int listHeight = listBottom - listTop;
        this.buttonList = new ButtonList(this.minecraft, this.width, listHeight, listTop, 24);
        this.addRenderableWidget((GuiEventListener)this.buttonList);
        for (Button btn : mainButtons) {
            this.buttonList.addInstant(btn);
        }
        this.addRenderableWidget((GuiEventListener)ScrollSlider.attach(this.buttonList).widget());
        int doneX = this.width / 2 - 100;
        int doneY = this.height - 27;
        Button doneButton = Button.builder((Component)Component.translatable((String)"gui.done"), b -> this.minecraft.setScreen(this.parentScreen)).bounds(doneX, doneY, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
        Button resetButton = this.createResetWarningsButton();
        this.addRenderableWidget((GuiEventListener)resetButton);
        if (!missingMods.isEmpty()) {
            Button missingButton = Button.builder((Component)Component.literal((String)("Missing Mods (" + missingMods.size() + ")")), b -> this.minecraft.setScreen((Screen)new MissingModsScreen(this, missingMods))).bounds(0, 0, 120, 20).build();
            this.addRenderableWidget((GuiEventListener)missingButton);
            if (narrow) {
                int missingY = doneY - 20 - 5;
                int resetY = missingY - 20 - 5;
                missingButton.setX(this.width / 2 - missingButton.getWidth() / 2);
                missingButton.setY(missingY);
                resetButton.setX(this.width / 2 - resetButton.getWidth() / 2);
                resetButton.setY(resetY);
            } else {
                missingButton.setX(this.width - missingButton.getWidth() - 10);
                missingButton.setY(doneY);
                resetButton.setX(this.width / 2 - resetButton.getWidth() / 2);
                resetButton.setY(doneY - 20 - 5);
            }
        } else {
            resetButton.setX(this.width / 2 - resetButton.getWidth() / 2);
            resetButton.setY(doneY - 20 - 5);
        }
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.title.getString());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonList != null) {
            this.buttonList.tickAnimations();
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.font, this.width);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void resize(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = 0.0;
        if (this.buttonList != null && this.buttonList.getMaxScroll() > 0) {
            scrollRatio = this.buttonList.getScrollAmount() / (double)this.buttonList.getMaxScroll();
        }
        super.resize(mc, newWidth, newHeight);
        if (this.buttonList != null && this.buttonList.getMaxScroll() > 0) {
            this.buttonList.setScrollAmount(scrollRatio * (double)this.buttonList.getMaxScroll());
        }
    }

    private Button createResetWarningsButton() {
        Button btn = Button.builder((Component)Component.literal((String)"Reset Warnings"), b -> {
            if (!b.active) {
                return;
            }
            JsonWarningList.reset();
            SystemToast.add((ToastComponent)Minecraft.getInstance().getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.literal((String)"Warnings Restored"), (Component)Component.literal((String)"All warning messages are back"));
            b.active = false;
            b.setMessage((Component)Component.literal((String)"Warnings Reset"));
        }).bounds(0, 0, 110, 20).build();
        btn.active = JsonWarningList.hasWarnings();
        return btn;
    }

    private List<ModConfig> getConfigsForMod(String modId) {
        return ModConfigs.getModConfigs((String)modId).stream().filter(cfg -> cfg.getSpec() instanceof ModConfigSpec).toList();
    }
}

