/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.api.ModInfo;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.ButtonList;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MissingModsScreen
extends Screen {
    private final Screen parentScreen;
    private final List<ModInfo> missingModsList;
    private ButtonList buttonList;
    private AnimatedScreenTitle animatedTitle;

    public MissingModsScreen(Screen parentScreen, List<ModInfo> missingModsList) {
        super((Component)Component.literal((String)"Missing Compatible Mods"));
        this.parentScreen = parentScreen;
        this.missingModsList = missingModsList;
    }

    protected void init() {
        super.init();
        if (this.missingModsList.isEmpty()) {
            Minecraft.getInstance().setScreen(this.parentScreen);
            return;
        }
        int rowSpacing = 24;
        int buttonWidth = 200;
        int listTop = 32;
        int bannerHeight = 44;
        int listBottom = this.height - bannerHeight;
        int listHeight = listBottom - listTop;
        this.buttonList = new ButtonList(this.minecraft, this.width, listHeight, listTop, rowSpacing);
        this.addRenderableWidget((GuiEventListener)this.buttonList);
        for (ModInfo info : this.missingModsList) {
            Button modButton = this.createModButton(info, buttonWidth);
            modButton.setWidth(buttonWidth);
            this.buttonList.addInstant(modButton);
        }
        this.addRenderableWidget((GuiEventListener)ScrollSlider.attach(this.buttonList).widget());
        int backX = this.width / 2 - 100;
        int backY = listBottom + (bannerHeight - 20) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), b -> Minecraft.getInstance().setScreen(this.parentScreen)).pos(backX, backY).size(200, 20).build());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.title.getString());
        }
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private Button createModButton(ModInfo info, int buttonWidth) {
        String modName = info.displayName();
        MutableComponent label = Component.literal((String)(modName + " Mod"));
        Button.OnPress action = b -> this.openLinkOrNotify(info);
        return Button.builder((Component)label, (Button.OnPress)action).pos(0, 0).size(buttonWidth, 20).build();
    }

    private void openLinkOrNotify(ModInfo info) {
        Minecraft mc = Minecraft.getInstance();
        String link = info.link();
        if (link != null && !link.isBlank()) {
            MutableComponent title = Component.literal((String)"Link Confirmation");
            MutableComponent styledLink = Component.literal((String)link).withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)));
            MutableComponent message = Component.literal((String)"Do you want to open the following link?\n").append((Component)styledLink);
            mc.setScreen((Screen)new ConfirmScreen(yes -> {
                if (yes) {
                    Util.getPlatform().openUri(link);
                }
                mc.setScreen((Screen)this);
            }, (Component)title, (Component)message, (Component)Component.literal((String)"Yes"), (Component)Component.literal((String)"No")));
        } else {
            ToastComponent toasts = mc.getToasts();
            if (toasts.getToast(SystemToast.class, (Object)info.modid()) != null) {
                return;
            }
            SystemToast.addOrUpdate((ToastComponent)mc.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.literal((String)info.displayName()), (Component)Component.literal((String)info.noLinkMessage()));
        }
    }

    public void resize(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = 0.0;
        if (this.buttonList != null && this.buttonList.getMaxScroll() > 0) {
            scrollRatio = this.buttonList.getScrollAmount() / (double)this.buttonList.getMaxScroll();
        }
        super.resize(mc, newWidth, newHeight);
        if (this.buttonList != null && this.buttonList.getMaxScroll() > 0) {
            this.buttonList.setScrollAmount(scrollRatio * (double)this.buttonList.getMaxScroll());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.buttonList.tickAnimations();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.animatedTitle.render(guiGraphics, this.font, this.width);
    }
}

