/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.warning.WarningMessageScreen;
import com.eruannie_9.booklinggear.util.screen.ScreenUtil;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ModConfigSelectionScreen
extends Screen {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_SPACING = 24;
    private final Screen parentScreen;
    private final String modName;
    private final List<ModConfig> configList;
    private AnimatedScreenTitle animatedTitle;

    public ModConfigSelectionScreen(Screen parentScreen, String modName, List<ModConfig> configList) {
        super((Component)Component.literal((String)("Select Config File for " + modName)));
        this.parentScreen = parentScreen;
        this.modName = modName;
        this.configList = configList;
    }

    protected void init() {
        super.init();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (ModConfig cfg : this.configList) {
            buttons.add(this.createConfigButton(cfg));
        }
        int yPos = ScreenUtil.computeStartY(this, 24, buttons.size());
        for (Button b : buttons) {
            b.setX(this.width / 2 - 100);
            b.setY(yPos);
            yPos += 24;
            this.addRenderableWidget((GuiEventListener)b);
        }
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), btn -> Minecraft.getInstance().setScreen(this.parentScreen)).pos(this.width / 2 - 100, this.height - 28).size(200, 20).build());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.title.getString());
        }
    }

    private Button createConfigButton(ModConfig cfg) {
        String rawFile = cfg.getFileName();
        String display = rawFile.endsWith(".toml") ? rawFile.substring(0, rawFile.length() - 5) : rawFile;
        return Button.builder((Component)Component.literal((String)display), btn -> {
            if (cfg.getLoadedConfig() == null) {
                Minecraft.getInstance().setScreen((Screen)new WarningMessageScreen(this, "The configuration file is not loaded."));
            } else {
                ModConfigSpec spec = (ModConfigSpec)cfg.getSpec();
                Minecraft.getInstance().setScreen((Screen)new ConfigScreen(this, "Configuration for " + this.modName, spec));
            }
        }).pos(0, 0).size(200, 20).build();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.font, this.width);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

