/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.GroupEntry;
import com.eruannie_9.booklinggear.screen.config.ValueEntry;
import com.eruannie_9.booklinggear.screen.config.WidgetFactory;
import com.eruannie_9.booklinggear.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public final class ConfigEntryCollector {
    private ConfigEntryCollector() {
    }

    public static List<ConfigOptionList.ConfigEntry> collect(ModConfigSpec specification, ConfigScreen parentScreen) {
        ArrayList<ConfigOptionList.ConfigEntry> entries = new ArrayList<ConfigOptionList.ConfigEntry>();
        ConfigEntryCollector.recurse(new ArrayList<String>(), specification.getValues(), entries, specification, 0, parentScreen);
        return entries;
    }

    private static void recurse(List<String> path, UnmodifiableConfig config, List<ConfigOptionList.ConfigEntry> entryList, ModConfigSpec specification, int depth, ConfigScreen screen) {
        for (Map.Entry entry : config.valueMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            ArrayList<String> newPath = new ArrayList<String>(path);
            newPath.add(key);
            if (value instanceof ModConfigSpec.ConfigValue) {
                ModConfigSpec.ConfigValue configValue = (ModConfigSpec.ConfigValue)value;
                AbstractWidget widget = WidgetFactory.create(configValue);
                String display = StringUtil.formatDisplayName(key);
                String comment = ConfigEntryCollector.commentOf(specification, newPath);
                entryList.add(new ValueEntry(display, configValue, widget, depth, comment, screen));
                continue;
            }
            if (!(value instanceof UnmodifiableConfig)) continue;
            UnmodifiableConfig subConfig = (UnmodifiableConfig)value;
            entryList.add(new GroupEntry(StringUtil.formatDisplayName(key), depth));
            ConfigEntryCollector.recurse(newPath, subConfig, entryList, specification, depth + 1, screen);
        }
    }

    private static String commentOf(ModConfigSpec specification, List<String> path) {
        ModConfigSpec.ValueSpec valueSpec;
        Object raw = specification.getSpec().get(path);
        if (raw instanceof ModConfigSpec.ValueSpec && (valueSpec = (ModConfigSpec.ValueSpec)raw).getComment() != null) {
            return valueSpec.getComment();
        }
        return "";
    }
}

