/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.eruannie_9.booklinggear.screen.config.ConfigOptionList;
import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import com.eruannie_9.booklinggear.util.CommentText;
import com.eruannie_9.booklinggear.util.screen.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ValueEntry
extends ConfigOptionList.ConfigEntry {
    public static final List<EditBox> EDIT_BOXES = Collections.synchronizedList(new ArrayList());
    private final String label;
    private final ModConfigSpec.ConfigValue<?> configValue;
    private final AbstractWidget valueWidget;
    private final String comment;
    private final List<String> urls;
    private final Button editButton;
    private int cachedXPos;
    private int cachedYPos;
    private int cachedRowHeight;
    private static final int INDENT = 10;
    private static final int RIGHT_RESERVED = 105;

    public ValueEntry(String label, ModConfigSpec.ConfigValue<?> configValue, AbstractWidget valueWidget, int depth, String comment, ConfigScreen parentScreen) {
        super(depth);
        this.label = label;
        this.configValue = configValue;
        this.valueWidget = valueWidget;
        this.comment = comment;
        this.urls = CommentText.extractLinks(comment);
        if (configValue.get() instanceof List) {
            ModConfigSpec.ConfigValue<?> listConfig = configValue;
            this.editButton = Button.builder((Component)Component.literal((String)"Edit"), b -> parentScreen.openListEditScreen(label, this.fullPath(), (ModConfigSpec.ConfigValue<List<String>>)listConfig)).pos(0, 0).size(100, 20).build();
        } else {
            String s;
            Object object = configValue.get();
            this.editButton = object instanceof String && ColorUtil.isHexColor(s = (String)object) ? Button.builder((Component)Component.literal((String)"Edit Color"), b -> parentScreen.openColorEditScreen(label, this.fullPath(), s)).pos(0, 0).size(100, 20).build() : null;
        }
        if (valueWidget instanceof EditBox) {
            EditBox eb = (EditBox)valueWidget;
            EDIT_BOXES.add(eb);
        }
    }

    public ModConfigSpec.ConfigValue<?> configValue() {
        return this.configValue;
    }

    public AbstractWidget widget() {
        return this.valueWidget;
    }

    public String fullPath() {
        return String.join((CharSequence)".", this.configValue.getPath());
    }

    public void updateEditButtonLabel(String text) {
        if (this.editButton != null) {
            this.editButton.setMessage((Component)Component.literal((String)text));
        }
    }

    private boolean isOpaqueEditBox() {
        return this.valueWidget instanceof EditBox;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int rowIndex, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        float widgetAlpha;
        String s;
        Object object;
        ConfigScreen screen;
        float progress = this.easedProgress();
        boolean opaqueEdit = this.isOpaqueEditBox();
        int slideOffset = opaqueEdit && !this.isTargetVisible() ? -Mth.ceil((float)((1.0f - progress) * (float)Minecraft.getInstance().getWindow().getGuiScaledWidth())) : this.slideX(rowWidth);
        int adjustedY = this.easedY(yPos);
        this.cachedXPos = xPos + slideOffset;
        this.cachedYPos = adjustedY;
        this.cachedRowHeight = rowHeight;
        Font font = Minecraft.getInstance().font;
        int maxLabelWidth = rowWidth - this.depth * 10 - 5 - 105;
        String display = TextUtil.abbreviate(font, this.label, maxLabelWidth);
        int labelX = xPos + this.depth * 10 + 5 + slideOffset;
        Objects.requireNonNull(font);
        int labelY = adjustedY + (rowHeight - 9) / 2;
        Screen screen2 = Minecraft.getInstance().screen;
        boolean tipsOn = screen2 instanceof ConfigScreen && (screen = (ConfigScreen)screen2).isTooltipEnabled();
        double d = mouseX;
        double d2 = mouseY;
        int n = font.width(display);
        Objects.requireNonNull(font);
        boolean overLabel = ValueEntry.in(d, d2, labelX, labelY, n, 9);
        int baseRGB = tipsOn && overLabel ? 0xFFFFA0 : 0xFFFFFF;
        int argb = Math.round(progress * 255.0f) << 24 | baseRGB;
        guiGraphics.drawString(font, display, labelX, labelY, argb, false);
        if (this.editButton != null && this.valueWidget == null && (object = this.configValue.get()) instanceof String && ColorUtil.isHexColor(s = (String)object)) {
            this.drawColourSwatch(guiGraphics, xPos, rowWidth, slideOffset, adjustedY, rowHeight, s, progress);
        }
        float f = opaqueEdit ? (this.isTargetVisible() ? progress : 1.0f) : (widgetAlpha = progress);
        if (this.valueWidget != null) {
            this.valueWidget.setAlpha(widgetAlpha);
            this.valueWidget.setX(xPos + rowWidth - 105 + slideOffset);
            this.valueWidget.setY(adjustedY + (rowHeight - this.valueWidget.getHeight()) / 2);
            this.valueWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.editButton != null) {
            this.editButton.setAlpha(widgetAlpha);
            this.editButton.setX(xPos + rowWidth - 105 + slideOffset);
            this.editButton.setY(adjustedY + (rowHeight - this.editButton.getHeight()) / 2);
            this.editButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (tipsOn && overLabel) {
            this.queueTooltip(mouseX, mouseY);
        }
    }

    private void drawColourSwatch(GuiGraphics guiGraphics, int xPos, int rowWidth, int slideOffset, int adjustedY, int rowHeight, String hex, float progress) {
        String drawHex = hex;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ConfigScreen) {
            String s;
            ConfigScreen scr = (ConfigScreen)screen;
            Object v = scr.currentValues.get(this.fullPath());
            if (v instanceof String && ColorUtil.isHexColor(s = (String)v)) {
                drawHex = s;
            }
        }
        int swatchSize = 20;
        int swatchX = xPos + rowWidth - 105 + slideOffset - swatchSize - 5;
        int swatchY = adjustedY + (rowHeight - swatchSize) / 2;
        int rgb = ColorUtil.hexToARGB(drawHex) & 0xFFFFFF;
        int fill = Math.round(progress * 255.0f) << 24 | rgb;
        int edge = Math.round(progress * 255.0f) << 24 | 0xFFFFFF;
        guiGraphics.fill(swatchX, swatchY, swatchX + swatchSize, swatchY + swatchSize, fill);
        guiGraphics.fill(swatchX, swatchY, swatchX + swatchSize, swatchY + 1, edge);
        guiGraphics.fill(swatchX, swatchY + swatchSize - 1, swatchX + swatchSize, swatchY + swatchSize, edge);
        guiGraphics.fill(swatchX, swatchY, swatchX + 1, swatchY + swatchSize, edge);
        guiGraphics.fill(swatchX + swatchSize - 1, swatchY, swatchX + swatchSize, swatchY + swatchSize, edge);
    }

    private void queueTooltip(int mouseX, int mouseY) {
        List<Component> lines = CommentText.toTooltipComponents(this.comment);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ConfigScreen) {
            ConfigScreen screen2 = (ConfigScreen)screen;
            screen2.tooltipLines = lines;
            screen2.tooltipX = mouseX;
            screen2.tooltipY = mouseY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Object url;
        ConfigScreen screen;
        Screen screen2;
        if (this.inLabel((int)mouseX, (int)mouseY) && !this.urls.isEmpty() && (screen2 = Minecraft.getInstance().screen) instanceof ConfigScreen && (screen = (ConfigScreen)screen2).isTooltipEnabled()) {
            url = this.urls.get(0);
            MutableComponent message = Component.literal((String)"Do you want to open the following link?\n").append((Component)Component.literal((String)url).withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true))));
            Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(arg_0 -> ValueEntry.lambda$mouseClicked$3((String)url, screen, arg_0), (Component)Component.literal((String)"Link Confirmation"), (Component)message, (Component)Component.literal((String)"Yes"), (Component)Component.literal((String)"No")));
            return true;
        }
        if (this.valueWidget != null && this.valueWidget.isMouseOver(mouseX, mouseY)) {
            CycleButton cb;
            if (button == 1 && (url = this.valueWidget) instanceof CycleButton && ValueEntry.cycleEnumBackward(cb = (CycleButton)url)) {
                cb.playDownSound(Minecraft.getInstance().getSoundManager());
                return true;
            }
            boolean result = this.valueWidget.mouseClicked(mouseX, mouseY, button);
            Object object = this.valueWidget;
            if (object instanceof EditBox) {
                EditBox clicked = (EditBox)object;
                object = EDIT_BOXES;
                synchronized (object) {
                    for (EditBox eb : EDIT_BOXES) {
                        if (eb == clicked) continue;
                        eb.setFocused(false);
                    }
                }
                clicked.setFocused(true);
                Objects.requireNonNull(Minecraft.getInstance().screen).setFocused((GuiEventListener)clicked);
            }
            return result;
        }
        if (this.editButton != null && this.editButton.isMouseOver(mouseX, mouseY)) {
            return this.editButton.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private static boolean cycleEnumBackward(CycleButton<?> c) {
        Object cur = c.getValue();
        if (!(cur instanceof Enum)) {
            return false;
        }
        Enum e = (Enum)cur;
        Enum[] constants = (Enum[])e.getDeclaringClass().getEnumConstants();
        if (constants == null || constants.length == 0) {
            return false;
        }
        int prev = (e.ordinal() - 1 + constants.length) % constants.length;
        c.setValue((Object)constants[prev]);
        return true;
    }

    private boolean inLabel(int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        int labelX = this.cachedXPos + this.depth * 10 + 5;
        Objects.requireNonNull(font);
        int labelY = this.cachedYPos + (this.cachedRowHeight - 9) / 2;
        double d = mouseX;
        double d2 = mouseY;
        int n = font.width(this.label);
        Objects.requireNonNull(font);
        return ValueEntry.in(d, d2, labelX, labelY, n, 9);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.valueWidget != null && this.valueWidget.isFocused() ? this.valueWidget.keyPressed(keyCode, scanCode, modifiers) : super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static boolean in(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
    }

    private static /* synthetic */ void lambda$mouseClicked$3(String url, ConfigScreen screen, boolean yes) {
        if (yes) {
            CommentText.openUrl(url);
        }
        Minecraft.getInstance().setScreen((Screen)screen);
    }
}

